/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import java.awt.Rectangle;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Widget;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorContainer;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorTileEntity;
import mcjty.rftools.network.Argument;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiSpaceProjector
extends GenericGuiContainer<SpaceProjectorTileEntity> {
    public static final int PROJECTOR_WIDTH = 180;
    public static final int PROJECTOR_HEIGHT = 152;
    private EnergyBar energyBar;
    private ImageChoiceLabel redstoneMode;
    private Button projectButton;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/spaceprojector.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiSpaceProjector(SpaceProjectorTileEntity spaceProjectorTileEntity, SpaceProjectorContainer container) {
        super(spaceProjectorTileEntity, container);
        SpaceProjectorTileEntity.setCurrentRF(spaceProjectorTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((SpaceProjectorTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint(new PositionalLayout.PositionalHint(10, 7, 8, 54))).setShowText(false);
        SpaceProjectorTileEntity cfr_ignored_0 = (SpaceProjectorTileEntity)this.tileEntity;
        this.energyBar.setValue(SpaceProjectorTileEntity.getCurrentRF());
        this.projectButton = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Update")).setLayoutHint(new PositionalLayout.PositionalHint(100, 7, 70, 16))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiSpaceProjector.this.updateProjection();
            }
        });
        this.initRedstoneMode();
        Object toplevel = ((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout(new PositionalLayout()).addChild(this.energyBar)).addChild(this.redstoneMode)).addChild(this.projectButton);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((SpaceProjectorTileEntity)this.tileEntity).requestRfFromServer();
    }

    private void updateProjection() {
        this.sendServerCommand("project", new Argument[0]);
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiSpaceProjector.this.changeRedstoneMode();
            }
        }).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint(new PositionalLayout.PositionalHint(150, 46, 16, 16));
        this.redstoneMode.setCurrentChoice(((SpaceProjectorTileEntity)this.tileEntity).getRedstoneMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((SpaceProjectorTileEntity)this.tileEntity).setRedstoneMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoice()]);
        this.sendServerCommand("rsMode", new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoice()].getDescription()));
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.window.draw();
        SpaceProjectorTileEntity cfr_ignored_0 = (SpaceProjectorTileEntity)this.tileEntity;
        this.energyBar.setValue(SpaceProjectorTileEntity.getCurrentRF());
        ((SpaceProjectorTileEntity)this.tileEntity).requestRfFromServer();
    }
}

