/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic;

import java.util.Map;
import mcjty.entity.GenericTileEntity;
import mcjty.entity.SyncedValue;
import mcjty.rftools.blocks.BlockTools;
import mcjty.rftools.network.Argument;
import net.minecraft.nbt.NBTTagCompound;

public class CounterTileEntity
extends GenericTileEntity {
    public static final String CMD_SETCOUNTER = "setCounter";
    public static final String CMD_SETCURRENT = "setCurrent";
    private boolean prevIn = false;
    private int counter = 1;
    private int current = 0;
    private SyncedValue<Boolean> redstoneOut = new SyncedValue<Boolean>(false);

    public CounterTileEntity() {
        this.registerSyncedObject(this.redstoneOut);
    }

    public int getCounter() {
        return this.counter;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCounter(int counter) {
        this.counter = counter;
        this.current = 0;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setCurrent(int current) {
        this.current = current;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    protected void checkStateServer() {
        super.checkStateServer();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean newvalue = BlockTools.getRedstoneSignalIn(meta);
        boolean pulse = newvalue && !this.prevIn;
        this.prevIn = newvalue;
        boolean newout = false;
        if (pulse) {
            ++this.current;
            if (this.current >= this.counter) {
                this.current = 0;
                newout = true;
            }
            this.func_70296_d();
            if (newout != this.redstoneOut.getValue()) {
                this.redstoneOut.setValue(newout);
                this.notifyBlockUpdate();
            }
        }
    }

    @Override
    protected int updateMetaData(int meta) {
        meta = super.updateMetaData(meta);
        Boolean value = this.redstoneOut.getValue();
        return BlockTools.setRedstoneSignalOut(meta, value == null ? false : value);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.redstoneOut.setValue(tagCompound.func_74767_n("rs"));
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.counter = tagCompound.func_74762_e("counter");
        if (this.counter == 0) {
            this.counter = 1;
        }
        this.current = tagCompound.func_74762_e("current");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        Boolean value = this.redstoneOut.getValue();
        tagCompound.func_74757_a("rs", value == null ? false : value);
        tagCompound.func_74757_a("prevIn", this.prevIn);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("counter", this.counter);
        tagCompound.func_74768_a("current", this.current);
    }

    @Override
    public boolean execute(String command, Map<String, Argument> args) {
        boolean rc = super.execute(command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETCOUNTER.equals(command)) {
            this.setCounter(args.get("counter").getInteger());
            return true;
        }
        if (CMD_SETCURRENT.equals(command)) {
            this.setCurrent(args.get("current").getInteger());
            return true;
        }
        return false;
    }
}

