/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.gui.RenderHelper;
import mcjty.gui.Window;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class ChoiceLabel
extends Label<ChoiceLabel> {
    private List<String> choiceList = new ArrayList<String>();
    private Map<String, List<String>> tooltipMap = new HashMap<String, List<String>>();
    private String currentChoice = null;
    private List<ChoiceEvent> choiceEvents = null;

    public ChoiceLabel(Minecraft mc, Gui gui) {
        super(mc, gui);
        this.setText("");
    }

    public ChoiceLabel addChoices(String ... choices) {
        for (String choice : choices) {
            this.choiceList.add(choice);
            if (this.currentChoice != null) continue;
            this.currentChoice = choice;
            this.setText(this.currentChoice);
            this.fireChoiceEvents(this.currentChoice);
        }
        return this;
    }

    public ChoiceLabel setChoiceTooltip(String choice, String ... tooltips) {
        this.tooltipMap.put(choice, Arrays.asList(tooltips));
        return this;
    }

    public ChoiceLabel setChoice(String choice) {
        this.currentChoice = choice;
        this.setText(this.currentChoice);
        return this;
    }

    public String getCurrentChoice() {
        return this.currentChoice;
    }

    @Override
    public List<String> getTooltips() {
        List<String> tooltips = this.tooltipMap.get(this.currentChoice);
        if (tooltips == null) {
            return super.getTooltips();
        }
        return tooltips;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (this.isEnabled()) {
            RenderHelper.drawBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, -1118482, -13421773, -10066330);
        } else {
            RenderHelper.drawBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, -7829368, -11184811, -10066330);
        }
        super.draw(window, x, y);
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            if (this.choiceList.isEmpty()) {
                return null;
            }
            int index = this.choiceList.indexOf(this.currentChoice);
            if (++index >= this.choiceList.size()) {
                index = 0;
            }
            this.currentChoice = this.choiceList.get(index);
            this.setText(this.currentChoice);
            this.fireChoiceEvents(this.currentChoice);
        }
        return null;
    }

    public ChoiceLabel addChoiceEvent(ChoiceEvent event) {
        if (this.choiceEvents == null) {
            this.choiceEvents = new ArrayList<ChoiceEvent>();
        }
        this.choiceEvents.add(event);
        return this;
    }

    public void removeChoiceEvent(ChoiceEvent event) {
        if (this.choiceEvents != null) {
            this.choiceEvents.remove(event);
        }
    }

    private void fireChoiceEvents(String choice) {
        if (this.choiceEvents != null) {
            for (ChoiceEvent event : this.choiceEvents) {
                event.choiceChanged(this, choice);
            }
        }
    }
}

