/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.util.LanguageHelper;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xreliquary.items.ItemIceRod;

@ContentInit
public class ItemGlacialStaff
extends ItemIceRod {
    public ItemGlacialStaff() {
        super("glacial_staff");
    }

    @Override
    public boolean func_77662_d() {
        return true;
    }

    @Override
    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        return super.func_77659_a(ist, world, player);
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInteger("snowballs", ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.BLUE + Items.field_151126_ay.func_77653_i(new ItemStack(Items.field_151126_ay)))), ist, list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, ist, list);
    }

    public boolean onLeftClickEntity(ItemStack ist, EntityPlayer player, Entity e) {
        if (e instanceof EntityLivingBase && NBTHelper.getInteger("snowballs", ist) >= this.getSnowballCost()) {
            EntityLivingBase livingBase = (EntityLivingBase)e;
            PotionEffect slow = new PotionEffect(Potion.field_76421_d.field_76415_H, 30, 0);
            if (livingBase.func_70660_b(Potion.field_76421_d) != null) {
                slow = new PotionEffect(Potion.field_76421_d.field_76415_H, Math.min(livingBase.func_70660_b(Potion.field_76421_d).func_76459_b() + 30, 300), Math.min(livingBase.func_70660_b(Potion.field_76421_d).func_76458_c() + 1, 4));
            }
            ((EntityLivingBase)e).func_70690_d(slow);
            e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)slow.func_76458_c());
            NBTHelper.setInteger("snowballs", ist, NBTHelper.getInteger("snowballs", ist) - this.getSnowballCost());
        }
        return super.onLeftClickEntity(ist, player, e);
    }

    @Override
    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        int xOff;
        super.func_77663_a(ist, world, e, i, b);
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b) - 1;
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        if (this.isEnabled(ist)) {
            for (xOff = -2; xOff <= 2; ++xOff) {
                for (int zOff = -2; zOff <= 2; ++zOff) {
                    if (Math.abs(xOff) == 2 && Math.abs(zOff) == 2) continue;
                    this.doFreezeCheck(ist, x, y, z, world, xOff, zOff);
                }
            }
        }
        for (xOff = -5; xOff <= 5; ++xOff) {
            for (int yOff = -5; yOff <= 5; ++yOff) {
                for (int zOff = -5; zOff <= 5; ++zOff) {
                    if (Math.abs(yOff) < 3 && Math.abs(xOff) < 3 && Math.abs(zOff) < 3 && (Math.abs(xOff) != 2 || Math.abs(zOff) != 2)) continue;
                    this.doThawCheck(ist, x, y, z, world, xOff, yOff, zOff);
                }
            }
        }
    }

    public void doFreezeCheck(ItemStack ist, int x, int y, int z, World world, int xOff, int zOff) {
        block3: {
            Block block;
            block2: {
                block = world.func_147439_a(x += xOff, y, z += zOff);
                if (block.func_149688_o() != Material.field_151586_h || world.func_72805_g(x, y, z) != 0 || !world.func_147437_c(x, y + 1, z)) break block2;
                this.addFrozenBlockToList(ist, x, y, z);
                world.func_147449_b(x, y, z, Blocks.field_150403_cj);
                float red = 0.75f;
                float green = 0.75f;
                float blue = 1.0f;
                String nameOfParticle = "reddust";
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    if (!world.field_72995_K) continue;
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    Minecraft.func_71410_x().field_71438_f.func_72726_b(nameOfParticle, (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), (double)red, (double)green, (double)blue);
                }
                break block3;
            }
            if (block.func_149688_o() != Material.field_151587_i || world.func_72805_g(x, y, z) != 0) break block3;
            this.addFrozenBlockToList(ist, x, y, z);
            world.func_147449_b(x, y, z, Blocks.field_150343_Z);
            for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                float xVel = world.field_73012_v.nextFloat();
                float yVel = world.field_73012_v.nextFloat() + 0.5f;
                float zVel = world.field_73012_v.nextFloat();
                world.func_72869_a(world.field_73012_v.nextInt(3) == 0 ? "largesmoke" : "smoke", (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), 0.0, 0.2, 0.0);
            }
        }
    }

    public void doThawCheck(ItemStack ist, int x, int y, int z, World world, int xOff, int yOff, int zOff) {
        block4: {
            Block block;
            block3: {
                block = world.func_147439_a(x += xOff, y += yOff, z += zOff);
                if (block != Blocks.field_150403_cj) break block3;
                if (!this.removeFrozenBlockFromList(ist, x, y, z)) break block4;
                world.func_147449_b(x, y, z, Blocks.field_150355_j);
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    world.func_72869_a(world.field_73012_v.nextInt(3) == 0 ? "largesmoke" : "smoke", (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), 0.0, 0.2, 0.0);
                }
                break block4;
            }
            if (block == Blocks.field_150343_Z && this.removeFrozenBlockFromList(ist, x, y, z)) {
                world.func_147449_b(x, y, z, Blocks.field_150353_l);
                float red = 1.0f;
                float green = 0.0f;
                float blue = 0.0f;
                String nameOfParticle = "reddust";
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    if (!world.field_72995_K) continue;
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    Minecraft.func_71410_x().field_71438_f.func_72726_b(nameOfParticle, (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), (double)red, (double)green, (double)blue);
                }
            }
        }
    }

    private void addFrozenBlockToList(ItemStack ist, int x, int y, int z) {
        NBTTagCompound tagCompound = ist.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (tagCompound.func_74781_a("BlockLocations") == null) {
            tagCompound.func_74782_a("BlockLocations", (NBTBase)new NBTTagList());
        }
        NBTTagList tagList = tagCompound.func_150295_c("BlockLocations", 10);
        NBTTagCompound newTagData = new NBTTagCompound();
        newTagData.func_74768_a("x", x);
        newTagData.func_74768_a("y", y);
        newTagData.func_74768_a("z", z);
        tagList.func_74742_a((NBTBase)newTagData);
        tagCompound.func_74782_a("BlockLocations", (NBTBase)tagList);
        ist.func_77982_d(tagCompound);
    }

    private boolean removeFrozenBlockFromList(ItemStack ist, int x, int y, int z) {
        NBTTagCompound tagCompound = ist.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (tagCompound.func_74781_a("BlockLocations") == null) {
            tagCompound.func_74782_a("BlockLocations", (NBTBase)new NBTTagList());
        }
        NBTTagList tagList = tagCompound.func_150295_c("BlockLocations", 10);
        boolean removedBlock = false;
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            if (tagItemData.func_74762_e("x") != x || tagItemData.func_74762_e("y") != y || tagItemData.func_74762_e("z") != z) continue;
            tagItemData.func_74757_a("remove", true);
            removedBlock = true;
        }
        NBTTagList newTagList = new NBTTagList();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagItemData = tagList.func_150305_b(i);
            if (tagItemData.func_74767_n("remove")) continue;
            NBTTagCompound newTagData = new NBTTagCompound();
            newTagData.func_74768_a("x", tagItemData.func_74762_e("x"));
            newTagData.func_74768_a("y", tagItemData.func_74762_e("y"));
            newTagData.func_74768_a("z", tagItemData.func_74762_e("z"));
            newTagList.func_74742_a((NBTBase)newTagData);
        }
        tagCompound.func_74782_a("BlockLocations", (NBTBase)newTagList);
        ist.func_77982_d(tagCompound);
        return removedBlock;
    }
}

