/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.registries;

import appeng.api.config.Upgrades;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import thaumicenergistics.parts.AEPartArcaneCraftingTerminal;
import thaumicenergistics.parts.AEPartEssentiaExportBus;
import thaumicenergistics.parts.AEPartEssentiaImportBus;
import thaumicenergistics.parts.AEPartEssentiaLevelEmitter;
import thaumicenergistics.parts.AEPartEssentiaStorageBus;
import thaumicenergistics.parts.AEPartEssentiaTerminal;
import thaumicenergistics.parts.AEPartVisInterface;
import thaumicenergistics.parts.AbstractAEPartBase;
import thaumicenergistics.registries.ItemEnum;
import thaumicenergistics.registries.ThEStrings;

public enum AEPartsEnum {
    EssentiaImportBus(ThEStrings.Part_EssentiaImportBus, AEPartEssentiaImportBus.class, "thaumicenergistics.group.essentia.transport", AEPartsEnum.generatePair(Upgrades.CAPACITY, 2), AEPartsEnum.generatePair(Upgrades.REDSTONE, 1), AEPartsEnum.generatePair(Upgrades.SPEED, 2)),
    EssentiaLevelEmitter(ThEStrings.Part_EssentiaLevelEmitter, AEPartEssentiaLevelEmitter.class),
    EssentiaStorageBus(ThEStrings.Part_EssentiaStorageBus, AEPartEssentiaStorageBus.class, null, AEPartsEnum.generatePair(Upgrades.INVERTER, 1)),
    EssentiaExportBus(ThEStrings.Part_EssentiaExportBus, AEPartEssentiaExportBus.class, "thaumicenergistics.group.essentia.transport", AEPartsEnum.generatePair(Upgrades.CAPACITY, 2), AEPartsEnum.generatePair(Upgrades.REDSTONE, 1), AEPartsEnum.generatePair(Upgrades.SPEED, 2)),
    EssentiaTerminal(ThEStrings.Part_EssentiaTerminal, AEPartEssentiaTerminal.class),
    ArcaneCraftingTerminal(ThEStrings.Part_ArcaneCraftingTerminal, AEPartArcaneCraftingTerminal.class),
    VisInterface(ThEStrings.Part_VisRelayInterface, AEPartVisInterface.class);

    private ThEStrings unlocalizedName;
    private Class<? extends AbstractAEPartBase> partClass;
    private String groupName;
    private Map<Upgrades, Integer> upgrades = new HashMap<Upgrades, Integer>();
    public static final AEPartsEnum[] VALUES;

    private AEPartsEnum(ThEStrings unlocalizedName, Class<? extends AbstractAEPartBase> partClass) {
        this(unlocalizedName, partClass, null);
    }

    private AEPartsEnum(ThEStrings unlocalizedName, Class<? extends AbstractAEPartBase> partClass, String groupName) {
        this.unlocalizedName = unlocalizedName;
        this.partClass = partClass;
        this.groupName = groupName;
    }

    private AEPartsEnum(ThEStrings unlocalizedName, Class<? extends AbstractAEPartBase> partClass, String groupName, Pair<Upgrades, Integer> ... upgrades) {
        this(unlocalizedName, partClass, groupName);
        for (Pair<Upgrades, Integer> pair : upgrades) {
            this.upgrades.put((Upgrades)pair.getKey(), (Integer)pair.getValue());
        }
    }

    private static Pair<Upgrades, Integer> generatePair(Upgrades upgrade, int maximum) {
        return new ImmutablePair((Object)upgrade, (Object)maximum);
    }

    public static AEPartsEnum getPartFromDamageValue(ItemStack itemStack) {
        int clamped = MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)VALUES.length);
        return VALUES[clamped];
    }

    public static int getPartID(Class<? extends AbstractAEPartBase> partClass) {
        int id = -1;
        for (int i = 0; i < VALUES.length; ++i) {
            if (!VALUES[i].getPartClass().equals(partClass)) continue;
            id = i;
            break;
        }
        return id;
    }

    public AbstractAEPartBase createPartInstance(ItemStack itemStack) throws InstantiationException, IllegalAccessException {
        AbstractAEPartBase part = this.partClass.newInstance();
        part.setupPartFromItem(itemStack);
        return part;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getLocalizedName() {
        return this.unlocalizedName.getLocalized();
    }

    public Class<? extends AbstractAEPartBase> getPartClass() {
        return this.partClass;
    }

    public ItemStack getStack() {
        return ItemEnum.ITEM_AEPART.getItemStackWithDamage(this.ordinal());
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName.getUnlocalized();
    }

    public Map<Upgrades, Integer> getUpgrades() {
        return this.upgrades;
    }

    static {
        VALUES = AEPartsEnum.values();
    }
}

