/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.client.render.BlockRenderInfo;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.FloatBuffer;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BaseBlockRender {
    private static final int ORIENTATION_BITS = 7;
    private static final int FLIP_H_BIT = 8;
    private static final int FLIP_V_BIT = 16;
    private static final byte[][][] ORIENTATION_MAP = new byte[6][6][6];
    private final boolean hasTESR;
    private final double renderDistance;
    private final FloatBuffer rotMat = BufferUtils.createFloatBuffer((int)16);

    public BaseBlockRender() {
        this(false, 20.0);
    }

    public BaseBlockRender(boolean enableTESR, double tileEntitySpecialRendererRange) {
        this.hasTESR = enableTESR;
        this.renderDistance = tileEntitySpecialRendererRange;
        BaseBlockRender.setOriMap();
    }

    public static void setOriMap() {
        BaseBlockRender.ORIENTATION_MAP[0][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[1][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[2][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[4][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[5][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][5][1] = 1;
        BaseBlockRender.ORIENTATION_MAP[1][5][1] = 2;
        BaseBlockRender.ORIENTATION_MAP[2][5][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][5][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[4][5][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[5][5][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][2][1] = 3;
        BaseBlockRender.ORIENTATION_MAP[1][2][1] = 3;
        BaseBlockRender.ORIENTATION_MAP[2][2][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][2][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[4][2][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[5][2][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][4][1] = 2;
        BaseBlockRender.ORIENTATION_MAP[1][4][1] = 1;
        BaseBlockRender.ORIENTATION_MAP[2][4][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][4][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[4][4][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[5][4][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][3][0] = 8;
        BaseBlockRender.ORIENTATION_MAP[1][3][0] = 8;
        BaseBlockRender.ORIENTATION_MAP[2][3][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[3][3][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][3][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[5][3][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[0][4][0] = 10;
        BaseBlockRender.ORIENTATION_MAP[1][4][0] = 9;
        BaseBlockRender.ORIENTATION_MAP[2][4][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[3][4][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][4][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[5][4][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[0][5][0] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][5][0] = 10;
        BaseBlockRender.ORIENTATION_MAP[2][5][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[3][5][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][5][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[5][5][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[0][2][0] = 11;
        BaseBlockRender.ORIENTATION_MAP[1][2][0] = 11;
        BaseBlockRender.ORIENTATION_MAP[2][2][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[3][2][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][2][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[5][2][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[0][3][5] = 17;
        BaseBlockRender.ORIENTATION_MAP[1][3][5] = 9;
        BaseBlockRender.ORIENTATION_MAP[2][3][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[3][3][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[4][3][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[5][3][5] = 17;
        BaseBlockRender.ORIENTATION_MAP[0][1][5] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][1][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[2][1][5] = 19;
        BaseBlockRender.ORIENTATION_MAP[3][1][5] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][1][5] = 17;
        BaseBlockRender.ORIENTATION_MAP[5][1][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[0][2][5] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][2][5] = 9;
        BaseBlockRender.ORIENTATION_MAP[2][2][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[3][2][5] = 18;
        BaseBlockRender.ORIENTATION_MAP[4][2][5] = 17;
        BaseBlockRender.ORIENTATION_MAP[5][2][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[0][0][5] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][0][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[2][0][5] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][0][5] = 16;
        BaseBlockRender.ORIENTATION_MAP[4][0][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[5][0][5] = 17;
        BaseBlockRender.ORIENTATION_MAP[0][1][2] = 8;
        BaseBlockRender.ORIENTATION_MAP[1][1][2] = 0;
        BaseBlockRender.ORIENTATION_MAP[2][1][2] = 10;
        BaseBlockRender.ORIENTATION_MAP[3][1][2] = 1;
        BaseBlockRender.ORIENTATION_MAP[4][1][2] = 3;
        BaseBlockRender.ORIENTATION_MAP[5][1][2] = 11;
        BaseBlockRender.ORIENTATION_MAP[0][4][2] = 8;
        BaseBlockRender.ORIENTATION_MAP[1][4][2] = 8;
        BaseBlockRender.ORIENTATION_MAP[2][4][2] = 10;
        BaseBlockRender.ORIENTATION_MAP[3][4][2] = 1;
        BaseBlockRender.ORIENTATION_MAP[4][4][2] = 9;
        BaseBlockRender.ORIENTATION_MAP[5][4][2] = 2;
        BaseBlockRender.ORIENTATION_MAP[0][0][2] = 16;
        BaseBlockRender.ORIENTATION_MAP[1][0][2] = 0;
        BaseBlockRender.ORIENTATION_MAP[2][0][2] = 2;
        BaseBlockRender.ORIENTATION_MAP[3][0][2] = 9;
        BaseBlockRender.ORIENTATION_MAP[4][0][2] = 11;
        BaseBlockRender.ORIENTATION_MAP[5][0][2] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][5][2] = 8;
        BaseBlockRender.ORIENTATION_MAP[1][5][2] = 8;
        BaseBlockRender.ORIENTATION_MAP[2][5][2] = 2;
        BaseBlockRender.ORIENTATION_MAP[3][5][2] = 9;
        BaseBlockRender.ORIENTATION_MAP[4][5][2] = 2;
        BaseBlockRender.ORIENTATION_MAP[5][5][2] = 9;
        BaseBlockRender.ORIENTATION_MAP[0][0][3] = 11;
        BaseBlockRender.ORIENTATION_MAP[1][0][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[2][0][3] = 1;
        BaseBlockRender.ORIENTATION_MAP[3][0][3] = 10;
        BaseBlockRender.ORIENTATION_MAP[4][0][3] = 0;
        BaseBlockRender.ORIENTATION_MAP[5][0][3] = 8;
        BaseBlockRender.ORIENTATION_MAP[0][4][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[1][4][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[2][4][3] = 9;
        BaseBlockRender.ORIENTATION_MAP[3][4][3] = 2;
        BaseBlockRender.ORIENTATION_MAP[4][4][3] = 1;
        BaseBlockRender.ORIENTATION_MAP[5][4][3] = 10;
        BaseBlockRender.ORIENTATION_MAP[0][1][3] = 19;
        BaseBlockRender.ORIENTATION_MAP[1][1][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[2][1][3] = 9;
        BaseBlockRender.ORIENTATION_MAP[3][1][3] = 2;
        BaseBlockRender.ORIENTATION_MAP[4][1][3] = 11;
        BaseBlockRender.ORIENTATION_MAP[5][1][3] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][5][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[1][5][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[2][5][3] = 1;
        BaseBlockRender.ORIENTATION_MAP[3][5][3] = 10;
        BaseBlockRender.ORIENTATION_MAP[4][5][3] = 10;
        BaseBlockRender.ORIENTATION_MAP[5][5][3] = 1;
        BaseBlockRender.ORIENTATION_MAP[0][3][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[1][3][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[2][3][4] = 10;
        BaseBlockRender.ORIENTATION_MAP[3][3][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[4][3][4] = 10;
        BaseBlockRender.ORIENTATION_MAP[5][3][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[0][0][4] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][0][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[2][0][4] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][0][4] = 8;
        BaseBlockRender.ORIENTATION_MAP[4][0][4] = 10;
        BaseBlockRender.ORIENTATION_MAP[5][0][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[0][1][4] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][1][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[2][1][4] = 11;
        BaseBlockRender.ORIENTATION_MAP[3][1][4] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][1][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[5][1][4] = 9;
        BaseBlockRender.ORIENTATION_MAP[0][2][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[1][2][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[2][2][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[3][2][4] = 10;
        BaseBlockRender.ORIENTATION_MAP[4][2][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[5][2][4] = 9;
    }

    public boolean hasTESR() {
        return this.hasTESR;
    }

    protected int adjustBrightness(int v, double d) {
        int r = 0xFF & v >> 16;
        int g = 0xFF & v >> 8;
        int b = 0xFF & v;
        r = (int)((double)r * d);
        g = (int)((double)g * d);
        b = (int)((double)b * d);
        r = Math.min(255, Math.max(0, r));
        g = Math.min(255, Math.max(0, g));
        b = Math.min(255, Math.max(0, b));
        return r << 16 | g << 8 | b;
    }

    public double getTesrRenderDistance() {
        return this.renderDistance;
    }

    public void renderInventory(AEBaseBlock block, ItemStack item, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] data) {
        Tessellator tess = Tessellator.field_78398_a;
        BlockRenderInfo info = block.getRendererInstance();
        if (info.isValid()) {
            if (block.hasSubtypes()) {
                block.setRenderStateByMeta(item.func_77960_j());
            }
            renderer.field_147865_v = info.getTexture(ForgeDirection.DOWN).setFlip(BaseBlockRender.getOrientation(ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.UP));
            renderer.field_147867_u = info.getTexture(ForgeDirection.UP).setFlip(BaseBlockRender.getOrientation(ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.UP));
            renderer.field_147875_q = info.getTexture(ForgeDirection.EAST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.UP));
            renderer.field_147873_r = info.getTexture(ForgeDirection.WEST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.UP));
            renderer.field_147869_t = info.getTexture(ForgeDirection.NORTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.UP));
            renderer.field_147871_s = info.getTexture(ForgeDirection.SOUTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.SOUTH, ForgeDirection.SOUTH, ForgeDirection.UP));
        }
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), block, item, tess, 0xFFFFFF, renderer);
        if (block.hasSubtypes()) {
            info.setTemporaryRenderIcon(null);
        }
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
    }

    public static int getOrientation(ForgeDirection in, ForgeDirection forward, ForgeDirection up) {
        if (in == null || in == ForgeDirection.UNKNOWN || forward == null || forward == ForgeDirection.UNKNOWN || up == null || up == ForgeDirection.UNKNOWN) {
            return 0;
        }
        int a = in.ordinal();
        int b = forward.ordinal();
        int c = up.ordinal();
        return ORIENTATION_MAP[a][b][c];
    }

    public void renderInvBlock(EnumSet<ForgeDirection> sides, AEBaseBlock block, ItemStack item, Tessellator tess, int color, RenderBlocks renderer) {
        if (Platform.isDrawing(tess)) {
            tess.func_78381_a();
        }
        int meta = 0;
        if (block != null && block.hasSubtypes() && item != null) {
            meta = item.func_77960_j();
        }
        if (sides.contains(ForgeDirection.DOWN)) {
            tess.func_78382_b();
            tess.func_78375_b(0.0f, -1.0f, 0.0f);
            tess.func_78378_d(color);
            renderer.func_147768_a((Block)block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.field_147840_d, block.getRendererInstance().getTexture(ForgeDirection.DOWN), block.func_149691_a(ForgeDirection.DOWN.ordinal(), meta)));
            tess.func_78381_a();
        }
        if (sides.contains(ForgeDirection.UP)) {
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 1.0f, 0.0f);
            tess.func_78378_d(color);
            renderer.func_147806_b((Block)block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.field_147840_d, block.getRendererInstance().getTexture(ForgeDirection.UP), block.func_149691_a(ForgeDirection.UP.ordinal(), meta)));
            tess.func_78381_a();
        }
        if (sides.contains(ForgeDirection.NORTH)) {
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 0.0f, -1.0f);
            tess.func_78378_d(color);
            renderer.func_147761_c((Block)block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.field_147840_d, block.getRendererInstance().getTexture(ForgeDirection.NORTH), block.func_149691_a(ForgeDirection.NORTH.ordinal(), meta)));
            tess.func_78381_a();
        }
        if (sides.contains(ForgeDirection.SOUTH)) {
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 0.0f, 1.0f);
            tess.func_78378_d(color);
            renderer.func_147734_d((Block)block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.field_147840_d, block.getRendererInstance().getTexture(ForgeDirection.SOUTH), block.func_149691_a(ForgeDirection.SOUTH.ordinal(), meta)));
            tess.func_78381_a();
        }
        if (sides.contains(ForgeDirection.WEST)) {
            tess.func_78382_b();
            tess.func_78375_b(-1.0f, 0.0f, 0.0f);
            tess.func_78378_d(color);
            renderer.func_147798_e((Block)block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.field_147840_d, block.getRendererInstance().getTexture(ForgeDirection.WEST), block.func_149691_a(ForgeDirection.WEST.ordinal(), meta)));
            tess.func_78381_a();
        }
        if (sides.contains(ForgeDirection.EAST)) {
            tess.func_78382_b();
            tess.func_78375_b(1.0f, 0.0f, 0.0f);
            tess.func_78378_d(color);
            renderer.func_147764_f((Block)block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.field_147840_d, block.getRendererInstance().getTexture(ForgeDirection.EAST), block.func_149691_a(ForgeDirection.EAST.ordinal(), meta)));
            tess.func_78381_a();
        }
    }

    public IIcon firstNotNull(IIcon ... s) {
        for (IIcon o : s) {
            if (o == null) continue;
            return o;
        }
        return ExtraBlockTextures.getMissing();
    }

    public boolean renderInWorld(AEBaseBlock block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        this.preRenderInWorld(block, world, x, y, z, renderer);
        boolean o = renderer.func_147784_q((Block)block, x, y, z);
        this.postRenderInWorld(renderer);
        return o;
    }

    public void preRenderInWorld(AEBaseBlock block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        ForgeDirection forward = ForgeDirection.SOUTH;
        ForgeDirection up = ForgeDirection.UP;
        BlockRenderInfo info = block.getRendererInstance();
        IOrientable te = this.getOrientable(block, world, x, y, z);
        if (te != null) {
            forward = te.getForward();
            up = te.getUp();
            renderer.field_147865_v = info.getTexture(ForgeDirection.DOWN).setFlip(BaseBlockRender.getOrientation(ForgeDirection.DOWN, forward, up));
            renderer.field_147867_u = info.getTexture(ForgeDirection.UP).setFlip(BaseBlockRender.getOrientation(ForgeDirection.UP, forward, up));
            renderer.field_147875_q = info.getTexture(ForgeDirection.EAST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.EAST, forward, up));
            renderer.field_147873_r = info.getTexture(ForgeDirection.WEST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.WEST, forward, up));
            renderer.field_147869_t = info.getTexture(ForgeDirection.NORTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.NORTH, forward, up));
            renderer.field_147871_s = info.getTexture(ForgeDirection.SOUTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.SOUTH, forward, up));
        }
    }

    public void postRenderInWorld(RenderBlocks renderer) {
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
    }

    @Nullable
    public IOrientable getOrientable(AEBaseBlock block, IBlockAccess w, int x, int y, int z) {
        if (block.hasBlockTileEntity()) {
            return (AEBaseTile)block.getTileEntity(w, x, y, z);
        }
        if (block instanceof IOrientableBlock) {
            return ((IOrientableBlock)((Object)block)).getOrientable(w, x, y, z);
        }
        return null;
    }

    protected void setInvRenderBounds(RenderBlocks renderer, int i, int j, int k, int l, int m, int n) {
        renderer.func_147782_a((double)i / 16.0, (double)j / 16.0, (double)k / 16.0, (double)l / 16.0, (double)m / 16.0, (double)n / 16.0);
    }

    protected void renderBlockBounds(RenderBlocks renderer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, ForgeDirection x, ForgeDirection y, ForgeDirection z) {
        double aX = (minX /= 16.0) * (double)x.offsetX + (minY /= 16.0) * (double)y.offsetX + (minZ /= 16.0) * (double)z.offsetX;
        double aY = minX * (double)x.offsetY + minY * (double)y.offsetY + minZ * (double)z.offsetY;
        double aZ = minX * (double)x.offsetZ + minY * (double)y.offsetZ + minZ * (double)z.offsetZ;
        double bX = (maxX /= 16.0) * (double)x.offsetX + (maxY /= 16.0) * (double)y.offsetX + (maxZ /= 16.0) * (double)z.offsetX;
        double bY = maxX * (double)x.offsetY + maxY * (double)y.offsetY + maxZ * (double)z.offsetY;
        double bZ = maxX * (double)x.offsetZ + maxY * (double)y.offsetZ + maxZ * (double)z.offsetZ;
        if (x.offsetX + y.offsetX + z.offsetX < 0) {
            aX += 1.0;
            bX += 1.0;
        }
        if (x.offsetY + y.offsetY + z.offsetY < 0) {
            aY += 1.0;
            bY += 1.0;
        }
        if (x.offsetZ + y.offsetZ + z.offsetZ < 0) {
            aZ += 1.0;
            bZ += 1.0;
        }
        renderer.field_147859_h = Math.min(aX, bX);
        renderer.field_147855_j = Math.min(aY, bY);
        renderer.field_147851_l = Math.min(aZ, bZ);
        renderer.field_147861_i = Math.max(aX, bX);
        renderer.field_147857_k = Math.max(aY, bY);
        renderer.field_147853_m = Math.max(aZ, bZ);
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderCutoutFace(Block block, IIcon ico, int x, int y, int z, RenderBlocks renderer, ForgeDirection orientation, float edgeThickness) {
        Tessellator tess = Tessellator.field_78398_a;
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        double layerAX = 0.0;
        double layerAY = 0.0;
        double layerAZ = 0.0;
        double layerBX = 0.0;
        double layerBY = 0.0;
        double layerBZ = 0.0;
        boolean flip = false;
        switch (orientation) {
            case NORTH: {
                layerAX = 1.0;
                layerBY = 1.0;
                flip = true;
                break;
            }
            case SOUTH: {
                layerAX = 1.0;
                layerBY = 1.0;
                offsetZ = 1.0;
                break;
            }
            case EAST: {
                flip = true;
                layerAZ = 1.0;
                layerBY = 1.0;
                offsetX = 1.0;
                break;
            }
            case WEST: {
                layerAZ = 1.0;
                layerBY = 1.0;
                break;
            }
            case UP: {
                flip = true;
                layerAX = 1.0;
                layerBZ = 1.0;
                offsetY = 1.0;
                break;
            }
            case DOWN: {
                layerAX = 1.0;
                layerBZ = 1.0;
                break;
            }
        }
        this.renderFace(tess, offsetX += (double)x, offsetY += (double)y, offsetZ += (double)z, layerAX, layerAY, layerAZ, layerBX, layerBY, layerBZ, 0.0, 1.0, 0.0, edgeThickness, ico, flip);
        this.renderFace(tess, offsetX, offsetY, offsetZ, layerAX, layerAY, layerAZ, layerBX, layerBY, layerBZ, 0.0, edgeThickness, edgeThickness, 1.0 - (double)edgeThickness, ico, flip);
        this.renderFace(tess, offsetX, offsetY, offsetZ, layerAX, layerAY, layerAZ, layerBX, layerBY, layerBZ, 1.0 - (double)edgeThickness, 1.0, edgeThickness, 1.0 - (double)edgeThickness, ico, flip);
        this.renderFace(tess, offsetX, offsetY, offsetZ, layerAX, layerAY, layerAZ, layerBX, layerBY, layerBZ, 0.0, 1.0, 1.0 - (double)edgeThickness, 1.0, ico, flip);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderFace(Tessellator tess, double offsetX, double offsetY, double offsetZ, double ax, double ay, double az, double bx, double by, double bz, double ua, double ub, double va, double vb, IIcon ico, boolean flip) {
        if (flip) {
            tess.func_78374_a(offsetX + ax * ua + bx * va, offsetY + ay * ua + by * va, offsetZ + az * ua + bz * va, (double)ico.func_94214_a(ua * 16.0), (double)ico.func_94207_b(va * 16.0));
            tess.func_78374_a(offsetX + ax * ua + bx * vb, offsetY + ay * ua + by * vb, offsetZ + az * ua + bz * vb, (double)ico.func_94214_a(ua * 16.0), (double)ico.func_94207_b(vb * 16.0));
            tess.func_78374_a(offsetX + ax * ub + bx * vb, offsetY + ay * ub + by * vb, offsetZ + az * ub + bz * vb, (double)ico.func_94214_a(ub * 16.0), (double)ico.func_94207_b(vb * 16.0));
            tess.func_78374_a(offsetX + ax * ub + bx * va, offsetY + ay * ub + by * va, offsetZ + az * ub + bz * va, (double)ico.func_94214_a(ub * 16.0), (double)ico.func_94207_b(va * 16.0));
        } else {
            tess.func_78374_a(offsetX + ax * ua + bx * va, offsetY + ay * ua + by * va, offsetZ + az * ua + bz * va, (double)ico.func_94214_a(ua * 16.0), (double)ico.func_94207_b(va * 16.0));
            tess.func_78374_a(offsetX + ax * ub + bx * va, offsetY + ay * ub + by * va, offsetZ + az * ub + bz * va, (double)ico.func_94214_a(ub * 16.0), (double)ico.func_94207_b(va * 16.0));
            tess.func_78374_a(offsetX + ax * ub + bx * vb, offsetY + ay * ub + by * vb, offsetZ + az * ub + bz * vb, (double)ico.func_94214_a(ub * 16.0), (double)ico.func_94207_b(vb * 16.0));
            tess.func_78374_a(offsetX + ax * ua + bx * vb, offsetY + ay * ua + by * vb, offsetZ + az * ua + bz * vb, (double)ico.func_94214_a(ua * 16.0), (double)ico.func_94207_b(vb * 16.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderFace(int x, int y, int z, Block block, IIcon ico, RenderBlocks renderer, ForgeDirection orientation) {
        switch (orientation) {
            case NORTH: {
                renderer.func_147761_c(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case SOUTH: {
                renderer.func_147734_d(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case EAST: {
                renderer.func_147764_f(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case WEST: {
                renderer.func_147798_e(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case UP: {
                renderer.func_147806_b(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case DOWN: {
                renderer.func_147768_a(block, (double)x, (double)y, (double)z, ico);
                break;
            }
        }
    }

    public void selectFace(RenderBlocks renderer, ForgeDirection west, ForgeDirection up, ForgeDirection forward, int u1, int u2, int v1, int v2) {
        v1 = 16 - v1;
        v2 = 16 - v2;
        double minX = (double)(forward.offsetX > 0 ? 1 : 0) + this.mapFaceUV(west.offsetX, u1) + this.mapFaceUV(up.offsetX, v1);
        double minY = (double)(forward.offsetY > 0 ? 1 : 0) + this.mapFaceUV(west.offsetY, u1) + this.mapFaceUV(up.offsetY, v1);
        double minZ = (double)(forward.offsetZ > 0 ? 1 : 0) + this.mapFaceUV(west.offsetZ, u1) + this.mapFaceUV(up.offsetZ, v1);
        double maxX = (double)(forward.offsetX > 0 ? 1 : 0) + this.mapFaceUV(west.offsetX, u2) + this.mapFaceUV(up.offsetX, v2);
        double maxY = (double)(forward.offsetY > 0 ? 1 : 0) + this.mapFaceUV(west.offsetY, u2) + this.mapFaceUV(up.offsetY, v2);
        double maxZ = (double)(forward.offsetZ > 0 ? 1 : 0) + this.mapFaceUV(west.offsetZ, u2) + this.mapFaceUV(up.offsetZ, v2);
        renderer.field_147859_h = Math.max(0.0, Math.min(minX, maxX) - (forward.offsetX != 0 ? 0.0 : 0.001));
        renderer.field_147861_i = Math.min(1.0, Math.max(minX, maxX) + (forward.offsetX != 0 ? 0.0 : 0.001));
        renderer.field_147855_j = Math.max(0.0, Math.min(minY, maxY) - (forward.offsetY != 0 ? 0.0 : 0.001));
        renderer.field_147857_k = Math.min(1.0, Math.max(minY, maxY) + (forward.offsetY != 0 ? 0.0 : 0.001));
        renderer.field_147851_l = Math.max(0.0, Math.min(minZ, maxZ) - (forward.offsetZ != 0 ? 0.0 : 0.001));
        renderer.field_147853_m = Math.min(1.0, Math.max(minZ, maxZ) + (forward.offsetZ != 0 ? 0.0 : 0.001));
    }

    private double mapFaceUV(int offset, int uv) {
        if (offset == 0) {
            return 0.0;
        }
        if (offset > 0) {
            return (double)uv / 16.0;
        }
        return (16.0 - (double)uv) / 16.0;
    }

    public void renderTile(AEBaseBlock block, AEBaseTile tile, Tessellator tess, double x, double y, double z, float f, RenderBlocks renderer) {
        ForgeDirection forward = ForgeDirection.SOUTH;
        ForgeDirection up = ForgeDirection.UP;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147873_r = 0;
        renderer.field_147875_q = 0;
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
        this.applyTESRRotation(x, y, z, forward, up);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tess.func_78373_b((double)(-tile.field_145851_c), (double)(-tile.field_145848_d), (double)(-tile.field_145849_e));
        tess.func_78382_b();
        renderer.func_147775_a((Block)block);
        renderer.func_147784_q((Block)block, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        tess.func_78381_a();
        tess.func_78373_b(0.0, 0.0, 0.0);
        RenderHelper.func_74519_b();
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147873_r = 0;
        renderer.field_147875_q = 0;
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
    }

    protected void applyTESRRotation(double x, double y, double z, ForgeDirection forward, ForgeDirection up) {
        if (forward != null && up != null) {
            if (forward == ForgeDirection.UNKNOWN) {
                forward = ForgeDirection.SOUTH;
            }
            if (up == ForgeDirection.UNKNOWN) {
                up = ForgeDirection.UP;
            }
            ForgeDirection west = Platform.crossProduct(forward, up);
            this.rotMat.put(0, west.offsetX);
            this.rotMat.put(1, west.offsetY);
            this.rotMat.put(2, west.offsetZ);
            this.rotMat.put(3, 0.0f);
            this.rotMat.put(4, up.offsetX);
            this.rotMat.put(5, up.offsetY);
            this.rotMat.put(6, up.offsetZ);
            this.rotMat.put(7, 0.0f);
            this.rotMat.put(8, forward.offsetX);
            this.rotMat.put(9, forward.offsetY);
            this.rotMat.put(10, forward.offsetZ);
            this.rotMat.put(11, 0.0f);
            this.rotMat.put(12, 0.0f);
            this.rotMat.put(13, 0.0f);
            this.rotMat.put(14, 0.0f);
            this.rotMat.put(15, 1.0f);
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GL11.glMultMatrix((FloatBuffer)this.rotMat);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            GL11.glCullFace((int)1028);
        } else {
            GL11.glTranslated((double)x, (double)y, (double)z);
        }
    }

    public void doRenderItem(ItemStack itemstack, TileEntity par1EntityItemFrame) {
        if (itemstack != null) {
            EntityItem entityitem = new EntityItem(par1EntityItemFrame.func_145831_w(), 0.0, 0.0, 0.0, itemstack);
            entityitem.func_92059_d().field_77994_a = 1;
            entityitem.field_70290_d = 0.0f;
            entityitem.field_70292_b = 0;
            entityitem.field_70177_z = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-0.14f, (float)0.0f);
            RenderItem.field_82407_g = true;
            RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            RenderItem.field_82407_g = false;
            GL11.glPopMatrix();
        }
    }
}

