/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.BaseContainerBlock;
import gcewing.lighting.Floodlight;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFloodlight<TE extends TileEntity>
extends BaseContainerBlock<TE> {
    static int renderType;
    protected IIcon[] icons;

    public BlockFloodlight() {
        this(Material.field_151576_e, null);
    }

    public BlockFloodlight(Class<TE> clazz) {
        this(Material.field_151576_e, clazz);
    }

    public BlockFloodlight(Material material, Class<TE> clazz) {
        super(material, clazz);
    }

    @Override
    public void func_149651_a(IIconRegister iIconRegister) {
        this.icons = new IIcon[6];
        this.icons[0] = this.getIcon(iIconRegister, "floodlight-bottom");
        this.icons[1] = this.getIcon(iIconRegister, "floodlight-side");
        this.icons[2] = this.getIcon(iIconRegister, "floodlight-top");
        this.icons[3] = this.getIcon(iIconRegister, "floodlight-bottom-lit");
        this.icons[4] = this.getIcon(iIconRegister, "floodlight-side-lit");
        this.icons[5] = this.getIcon(iIconRegister, "floodlight-top-lit");
    }

    @Override
    public int func_149645_b() {
        return renderType;
    }

    @Override
    public void setRenderType(int n) {
        renderType = n;
    }

    public int func_149660_a(World world, int n, int n2, int n3, int n4, float f, float f2, float f3, int n5) {
        return n4 << 1;
    }

    @Override
    public IIcon func_149691_a(int n, int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 += 3;
        }
        switch (n) {
            case 0: {
                return this.icons[n3];
            }
            case 1: {
                return this.icons[n3 + 2];
            }
        }
        return this.icons[n3 + 1];
    }

    @Override
    public void func_149726_b(World world, int n, int n2, int n3) {
        this.update(world, n, n2, n3);
        this.updateBeam(world, n, n2, n3);
    }

    @Override
    public void func_149749_a(World world, int n, int n2, int n3, Block block, int n4) {
        ForgeDirection forgeDirection = this.direction(n4);
        super.func_149749_a(world, n, n2, n3, block, n4);
        Floodlight.updateBeamInDirection(world, n + forgeDirection.offsetX, n2 + forgeDirection.offsetY, n3 + forgeDirection.offsetZ, forgeDirection);
    }

    public void func_149695_a(World world, int n, int n2, int n3, Block block) {
        this.update(world, n, n2, n3);
        this.updateBeam(world, n, n2, n3);
    }

    public void update(World world, int n, int n2, int n3) {
        if (!world.field_72995_K) {
            boolean bl = this.isActive(world, n, n2, n3);
            this.setIlluminated(world, n, n2, n3, bl);
        }
    }

    public void updateBeam(World world, int n, int n2, int n3) {
        if (!world.field_72995_K) {
            ForgeDirection forgeDirection = this.getDirection(world, n, n2, n3);
            Floodlight.updateBeamInDirection(world, n + forgeDirection.offsetX, n2 + forgeDirection.offsetY, n3 + forgeDirection.offsetZ, forgeDirection);
        }
    }

    public void setIlluminated(World world, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = world.func_72805_g(n, n2, n3);
        if (n5 != (n4 = n5 & 0xE | (bl ? 1 : 0))) {
            world.func_72921_c(n, n2, n3, n4, 3);
            world.func_147471_g(n, n2, n3);
        }
    }

    public boolean isActive(World world, int n, int n2, int n3) {
        return world.func_72864_z(n, n2, n3);
    }

    public boolean isActiveInDirection(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return this.getDirection(world, n, n2, n3) == forgeDirection && this.isActive(world, n, n2, n3);
    }

    public ForgeDirection getDirection(World world, int n, int n2, int n3) {
        int n4 = world.func_72805_g(n, n2, n3);
        return this.direction(n4);
    }

    public ForgeDirection direction(int n) {
        return ForgeDirection.getOrientation((int)(n >> 1));
    }
}

