/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.tile;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import io.endertech.multiblock.MultiblockControllerBase;
import io.endertech.multiblock.MultiblockValidationException;
import io.endertech.multiblock.controller.ControllerTank;
import io.endertech.multiblock.tile.TileTankPart;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTankEnergyInput
extends TileTankPart
implements IEnergyHandler {
    public static final int MAX_INPUT_RATE = 10000;

    public static void init() {
        GameRegistry.registerTileEntity(TileTankEnergyInput.class, (String)"tile.endertech.enderTankEnergyInput");
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException("Tank energy inputs cannot be used for tank interior.");
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.canInteractFromDirection(from) || !this.isConnected()) {
            return 0;
        }
        ControllerTank controller = this.getTankController();
        return controller.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (!this.canInteractFromDirection(from) || !this.isConnected()) {
            return 0;
        }
        ControllerTank controller = this.getTankController();
        return controller.getStoredEnergy();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (!this.canInteractFromDirection(from)) {
            return 0;
        }
        return 10000000;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.canInteractFromDirection(from);
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        this.updateOutwardNeighbours();
    }

    @Override
    public void onMachineBroken() {
        this.updateOutwardNeighbours();
        super.onMachineBroken();
    }
}

