/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import java.util.Map;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.IMethodMap;

public class IndexedMethodMap
implements IMethodMap {
    protected final String[] names;
    protected final IMethodExecutor[] methods;

    public IndexedMethodMap(Map<String, IMethodExecutor> methods) {
        int methodCount = methods.size();
        this.names = new String[methodCount];
        this.methods = new IMethodExecutor[methodCount];
        int i = 0;
        for (Map.Entry<String, IMethodExecutor> e : methods.entrySet()) {
            this.names[i] = e.getKey();
            this.methods[i] = e.getValue();
            ++i;
        }
    }

    public IMethodExecutor[] getMethods() {
        return this.methods;
    }

    public String[] getMethodNames() {
        return this.names;
    }

    public IMethodExecutor getMethod(int index) {
        return this.methods[index];
    }

    public String getMethodName(int index) {
        return this.names[index];
    }

    @Override
    public int size() {
        return this.names.length;
    }

    @Override
    public boolean isEmpty() {
        return this.names.length == 0;
    }

    @Override
    public void visitMethods(IMethodMap.IMethodVisitor visitor) {
        for (int i = 0; i < this.names.length; ++i) {
            visitor.visit(this.names[i], this.methods[i]);
        }
    }
}

