/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.item;

import com.rwtema.extrautils.ICreativeTabSorting;
import com.rwtema.extrautils.XUHelper;
import com.rwtema.extrautils.item.ItemBlockMetadata;
import com.rwtema.extrautils.tileentity.TileEntityDrum;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.ItemFluidContainer;

public class ItemBlockDrum
extends ItemBlockMetadata
implements IFluidContainerItem,
ICreativeTabSorting {
    protected int capacity = 256000;
    public ItemFluidContainer slaveItem = new ItemFluidContainer(-1, this.capacity);

    public ItemBlockDrum(Block b) {
        super(b);
    }

    public void setCapacityFromMeta(int meta) {
        this.slaveItem.setCapacity(TileEntityDrum.getCapacityFromMetadata(meta));
    }

    public ItemFluidContainer setCapacity(int capacity) {
        return this.slaveItem.setCapacity(capacity);
    }

    public FluidStack getFluid(ItemStack container) {
        this.setCapacityFromMeta(container.func_77960_j());
        return this.slaveItem.getFluid(container);
    }

    public int getCapacity(ItemStack container) {
        this.setCapacityFromMeta(container.func_77960_j());
        return this.slaveItem.getCapacity(container);
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        this.setCapacityFromMeta(container.func_77960_j());
        return this.slaveItem.fill(container, resource, doFill);
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        this.setCapacityFromMeta(container.func_77960_j());
        FluidStack t = this.slaveItem.drain(container, maxDrain, doDrain);
        if (this.slaveItem.getFluid(container) != null && this.slaveItem.getFluid((ItemStack)container).amount < 0) {
            container.func_77982_d(null);
            throw new RuntimeException("Fluid container has been drained into negative numbers. This is a Forge bug.");
        }
        return t;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer par2EntityPlayer, List info, boolean par4) {
        this.setCapacityFromMeta(item.func_77960_j());
        FluidStack fluid = this.slaveItem.getFluid(item);
        if (fluid != null) {
            info.add(XUHelper.getFluidName(fluid) + ": " + String.format(Locale.ENGLISH, "%,d", fluid.amount) + " / " + String.format(Locale.ENGLISH, "%,d", this.slaveItem.getCapacity(null)));
        } else {
            info.add("Empty: 0 / " + String.format(Locale.ENGLISH, "%,d", this.slaveItem.getCapacity(null)));
        }
    }

    public String func_77653_i(ItemStack item) {
        String s = super.func_77653_i(item);
        FluidStack fluid = this.getFluid(item);
        if (fluid != null) {
            s = XUHelper.getFluidName(fluid) + " " + s;
        }
        return s.trim();
    }

    @Override
    public String getSortingName(ItemStack item) {
        return super.func_77653_i(item) + ":" + this.func_77653_i(item);
    }
}

