/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.utils;

import java.util.Map;
import minetweaker.IUndoableAction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseMapAddition
implements IUndoableAction {
    protected final Map map;
    protected String description;
    protected Object key;
    protected Object recipe;

    public BaseMapAddition(Map map, Object key, Object recipe) {
        this(null, map, key, recipe);
    }

    public BaseMapAddition(String description, Map map, Object key, Object recipe) {
        this.map = map;
        this.key = key;
        this.recipe = recipe;
        this.description = description;
    }

    public void apply() {
        this.map.put(this.key, this.recipe);
    }

    public boolean canUndo() {
        return this.map != null;
    }

    public void undo() {
        this.map.remove(this.key);
    }

    public String getRecipeInfo() {
        return "Unknown Item";
    }

    public String describe() {
        if (this.recipe instanceof ItemStack) {
            return "Adding " + this.description + " Recipe for :" + ((ItemStack)this.recipe).func_82833_r();
        }
        if (this.recipe instanceof FluidStack) {
            return "Adding " + this.description + " Recipe for :" + ((FluidStack)this.recipe).getFluid().getLocalizedName();
        }
        return "Adding " + this.description + " Recipe for :" + this.getRecipeInfo();
    }

    public String describeUndo() {
        if (this.recipe instanceof ItemStack) {
            return "Removing " + this.description + " Recipe for :" + ((ItemStack)this.recipe).func_82833_r();
        }
        if (this.recipe instanceof FluidStack) {
            return "Removing " + this.description + " Recipe for :" + ((FluidStack)this.recipe).getFluid().getLocalizedName();
        }
        return "Removing " + this.description + " Recipe for :" + this.getRecipeInfo();
    }

    public Object getOverrideKey() {
        return null;
    }
}

