/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.item;

import cofh.api.energy.IEnergyContainerItem;
import io.endertech.block.BlockChargePad;
import io.endertech.block.ItemBlockBasic;
import io.endertech.tile.TileChargePad;
import io.endertech.util.helper.KeyHelper;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.StringHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemBlockChargePad
extends ItemBlockBasic
implements IEnergyContainerItem {
    public ItemBlockChargePad(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        int type = par1ItemStack.func_77960_j();
        if (type == BlockChargePad.Types.CREATIVE.ordinal()) {
            return EnumRarity.epic;
        }
        if (type == BlockChargePad.Types.REDSTONE.ordinal()) {
            return EnumRarity.uncommon;
        }
        if (type == BlockChargePad.Types.RESONANT.ordinal()) {
            return EnumRarity.rare;
        }
        return EnumRarity.common;
    }

    public void checkAndSetDefaultTag(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
            TileChargePad.writeDefaultTag(stack.field_77990_d);
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        super.func_77624_a(stack, player, list, check);
        if (KeyHelper.isShiftDown()) {
            this.checkAndSetDefaultTag(stack);
            if (this.isCreative(stack)) {
                list.add(LocalisationHelper.localiseString("info.charge", "Infinite"));
            } else {
                list.add(LocalisationHelper.localiseString("info.charge", StringHelper.getEnergyString(this.getEnergyStored(stack)) + " / " + StringHelper.getEnergyString(this.getMaxEnergyStored(stack)) + " RF"));
            }
            if (!this.isCreative(stack)) {
                list.add(LocalisationHelper.localiseString("info.charge.receive", StringHelper.getEnergyString(TileChargePad.RECEIVE[stack.func_77960_j()]) + " RF/t"));
            }
            list.add(LocalisationHelper.localiseString("info.charge.send", StringHelper.getEnergyString(TileChargePad.SEND[stack.func_77960_j()]) + " RF/t"));
        } else {
            list.add(StringHelper.holdShiftForDetails);
        }
    }

    private boolean isCreative(ItemStack stack) {
        return stack.func_77960_j() == 0;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        this.checkAndSetDefaultTag(container);
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(TileChargePad.RECEIVE[container.func_77960_j()], maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return TileChargePad.CAPACITY[container.func_77960_j()];
    }
}

