/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.item;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.item.ItemAttachment;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemServo
extends ItemAttachment {
    IIcon[] icons;
    public static EnumRarity[] rarity = new EnumRarity[]{EnumRarity.common, EnumRarity.common, EnumRarity.uncommon, EnumRarity.uncommon, EnumRarity.rare};
    public static ItemStack basicServo;
    public static ItemStack hardenedServo;
    public static ItemStack reinforcedServo;
    public static ItemStack signalumServo;
    public static ItemStack resonantServo;

    public ItemServo() {
        this.func_77655_b("thermaldynamics.servo");
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + "." + itemStack.func_77960_j();
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 5; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return rarity[itemStack.func_77960_j() % 5];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iIconRegister) {
        this.icons = new IIcon[5];
        for (int i = 0; i < 5; ++i) {
            this.icons[i] = iIconRegister.func_94245_a("thermaldynamics:servo" + i);
        }
        this.field_77791_bV = this.icons[0];
    }

    public IIcon func_77617_a(int n) {
        return this.icons[n % this.icons.length];
    }

    @Override
    public Attachment getAttachment(int n, ItemStack itemStack, TileTDBase tileTDBase) {
        int n2 = itemStack.func_77960_j() % 5;
        if (tileTDBase instanceof TileFluidDuct) {
            return new ServoFluid(tileTDBase, (byte)(n ^ 1), n2);
        }
        if (tileTDBase instanceof TileItemDuct) {
            return new ServoItem(tileTDBase, (byte)(n ^ 1), n2);
        }
        return null;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        super.func_77624_a(itemStack, entityPlayer, list, bl);
        int n = itemStack.func_77960_j() % 5;
        if (!StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.getInfoText((String)"item.thermaldynamics.servo.info"));
            if (StringHelper.displayShiftForDetail) {
                list.add(StringHelper.shiftForDetails());
            }
            return;
        }
        if (ServoBase.canAlterRS(n)) {
            list.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneInt"));
        } else {
            list.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneExt"));
        }
        list.add("\u00a7e" + StringHelper.localize((String)"info.cofh.items") + "\u00a7r");
        list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + (ServoItem.tickDelays[n] % 20 == 0 ? Integer.toString(ServoItem.tickDelays[n] / 20) : Float.toString((float)ServoItem.tickDelays[n] / 20.0f)) + "s" + "\u00a7r");
        list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.maxStackSize") + ": " + "\u00a7f" + ServoItem.maxSize[n] + "\u00a7r");
        ItemServo.addFiltering(list, n, Duct.Type.ITEM);
        if (ServoItem.multiStack[n]) {
            list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotMulti"));
        } else {
            list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotSingle"));
        }
        if (ServoItem.speedBoost[n] != 1) {
            list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.speedBoost") + ": " + "\u00a7f" + ServoItem.speedBoost[n] + "x " + "\u00a7r");
        }
        list.add("\u00a7e" + StringHelper.localize((String)"info.cofh.fluids") + "\u00a7r");
        list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + Integer.toString((int)(ServoFluid.throttle[n] * 100.0f)) + "%" + "\u00a7r");
        ItemServo.addFiltering(list, n, Duct.Type.FLUID);
    }

    public static void addFiltering(List list, int n, Duct.Type type) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringHelper.localize((String)"info.thermaldynamics.filter.options") + ": " + "\u00a7f");
        boolean bl = false;
        for (int i = 0; i < FilterLogic.flagTypes.length; ++i) {
            if (!FilterLogic.canAlterFlag(type, n, i)) continue;
            if (bl) {
                stringBuilder.append(", ");
            } else {
                bl = true;
            }
            stringBuilder.append(StringHelper.localize((String)("info.thermaldynamics.filter." + FilterLogic.flagTypes[i])));
        }
        bl = false;
        for (String string : Minecraft.func_71410_x().field_71466_p.func_78271_c(stringBuilder.toString(), 140)) {
            if (bl) {
                string = "  \u00a7f" + string;
            }
            bl = true;
            list.add("  " + string + "\u00a7r");
        }
    }

    public boolean preInit() {
        GameRegistry.registerItem((Item)this, (String)"servo");
        basicServo = new ItemStack((Item)this, 1, 0);
        hardenedServo = new ItemStack((Item)this, 1, 1);
        reinforcedServo = new ItemStack((Item)this, 1, 2);
        signalumServo = new ItemStack((Item)this, 1, 3);
        resonantServo = new ItemStack((Item)this, 1, 4);
        return true;
    }
}

