/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.util;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import openmods.Log;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.IMethodMap;
import openperipheral.adapter.wrappers.AdapterWrapper;
import openperipheral.util.DocUtils;
import openperipheral.util.NameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocBuilder {
    private final Document doc;
    private final Element root;
    public static final IClassDecorator NULL_DECORATOR = new IClassDecorator(){

        @Override
        public void decorateEntry(Element element, Class<?> cls) {
        }
    };
    public static final IClassDecorator TILE_ENTITY_DECORATOR = new IClassDecorator(){

        @Override
        public void decorateEntry(Element element, Class<?> cls) {
            String teName = (String)Objects.firstNonNull((Object)NameUtils.getClassToNameMap().get(cls), (Object)"null");
            Document doc = element.getOwnerDocument();
            element.appendChild(DocBuilder.createProperty(doc, "name", teName));
            String docText = (String)DocUtils.DOC_TEXT_CACHE.getOrCreate(cls);
            if (!Strings.isNullOrEmpty((String)docText)) {
                element.appendChild(DocBuilder.createCDataProperty(doc, "docText", docText));
            }
        }
    };

    public DocBuilder() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            this.root = this.doc.createElement("documentation");
            this.doc.appendChild(this.root);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void dumpXml(File output, boolean applyXslt) {
        try {
            Transformer transformer = this.createTransformer(applyXslt);
            DOMSource source = new DOMSource(this.doc);
            StreamResult result = new StreamResult(output);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer createTransformer(boolean applyXslt) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!applyXslt) {
            return transformerFactory.newTransformer();
        }
        InputStream stylesheet = this.getClass().getResourceAsStream("/op_dump.xsl");
        try {
            StreamSource stylesource = new StreamSource(stylesheet);
            Transformer transformer = transformerFactory.newTransformer(stylesource);
            return transformer;
        }
        finally {
            stylesheet.close();
        }
    }

    public void createDocForClass(String architecture, String type, IClassDecorator decorator, Class<?> cls, IMethodMap methods) {
        if (methods.isEmpty()) {
            return;
        }
        Element result = this.doc.createElement("classMethods");
        result.setAttribute("type", type);
        result.setAttribute("architecture", architecture);
        this.fillDocForClass(result, cls, methods);
        decorator.decorateEntry(result, cls);
        this.root.appendChild(result);
    }

    public void createDocForAdapter(String type, String location, Class<?> targetClass, AdapterWrapper adapter) {
        Element result = this.doc.createElement("adapter");
        Class<?> adapterClass = adapter.getAdapterClass();
        result.setAttribute("class", adapterClass.getName());
        result.setAttribute("source", DocBuilder.getSourceFile(adapterClass));
        result.setAttribute("type", type);
        result.setAttribute("location", location);
        result.appendChild(this.createProperty("target", adapter.getTargetClass().getName()));
        result.appendChild(this.createProperty("source", adapter.source()));
        this.fillMethods(result, adapter.getMethods());
        this.root.appendChild(result);
    }

    public void setRootAttribute(String name, String value) {
        this.root.setAttribute(name, value);
    }

    private static String getSourceFile(Class<?> adapterClass) {
        try {
            ProtectionDomain protectionDomain = adapterClass.getProtectionDomain();
            if (protectionDomain == null) {
                return "none";
            }
            URL sourceUrl = protectionDomain.getCodeSource().getLocation();
            return sourceUrl != null ? sourceUrl.toString() : "none";
        }
        catch (Throwable e) {
            Log.warn((Throwable)e, (String)"Failed to get source for class %s", (Object[])new Object[]{adapterClass});
            return "unknown";
        }
    }

    protected void fillMethods(Element result, Collection<? extends IMethodExecutor> methods) {
        for (IMethodExecutor iMethodExecutor : methods) {
            Element methodDoc = this.doc.createElement("method");
            IDescriptable description = iMethodExecutor.description();
            Element names = this.doc.createElement("names");
            for (String name : description.getNames()) {
                names.appendChild(this.createProperty("name", name));
            }
            methodDoc.appendChild(names);
            this.fillDocForMethod(methodDoc, iMethodExecutor);
            result.appendChild(methodDoc);
        }
    }

    private void fillDocForClass(final Element result, Class<?> cls, IMethodMap list) {
        result.setAttribute("class", cls.getName());
        result.appendChild(this.createProperty("simpleName", cls.getSimpleName()));
        list.visitMethods(new IMethodMap.IMethodVisitor(){

            @Override
            public void visit(String name, IMethodExecutor executor) {
                Element methodDoc = DocBuilder.this.doc.createElement("method");
                methodDoc.setAttribute("name", name);
                DocBuilder.this.fillDocForMethod(methodDoc, executor);
                result.appendChild(methodDoc);
            }
        });
    }

    private void fillDocForMethod(Element result, IMethodExecutor method) {
        result.setAttribute("asynchronous", Boolean.toString(method.isAsynchronous()));
        IDescriptable description = method.description();
        result.appendChild(this.createProperty("signature", description.signature()));
        Element extra = this.doc.createElement("extra");
        this.serializeMap(extra, description.describe());
        result.appendChild(extra);
    }

    private void serializeValue(Element output, Object value) {
        if (value == null) {
            output.appendChild(this.doc.createTextNode("null"));
        } else if (value instanceof Map) {
            this.serializeMap(output, (Map)value);
        } else if (value instanceof Collection) {
            this.serializeCollection(output, (Collection)value);
        } else {
            output.appendChild(this.doc.createTextNode(value.toString()));
        }
    }

    private void serializeCollection(Element output, Collection<?> list) {
        int index = 0;
        for (Object o : list) {
            Element e = this.doc.createElement("e");
            e.setAttribute("index", Integer.toString(index++));
            this.serializeValue(e, o);
            output.appendChild(e);
        }
    }

    private void serializeMap(Element output, Map<?, ?> map) {
        for (Map.Entry<?, ?> e : map.entrySet()) {
            Object key = e.getKey();
            Element entry = this.doc.createElement(key == null ? "null" : key.toString());
            this.serializeValue(entry, e.getValue());
            output.appendChild(entry);
        }
    }

    private Element createProperty(String tag, String value) {
        return DocBuilder.createProperty(this.doc, tag, value);
    }

    private static Element createProperty(Document doc, String tag, String value) {
        Element el = doc.createElement(tag);
        el.appendChild(doc.createTextNode(value));
        return el;
    }

    private static Element createCDataProperty(Document doc, String tag, String value) {
        Element el = doc.createElement(tag);
        el.appendChild(doc.createCDATASection(value));
        return el;
    }

    public static interface IClassDecorator {
        public void decorateEntry(Element var1, Class<?> var2);
    }
}

