/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.factory.gadgets.MachineSqueezer;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Squeezer")
public class Squeezer {
    @ZenMethod
    public static void addRecipe(int timePerItem, IItemStack[] resources, ILiquidStack liquid, IItemStack remnants, int chance) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MachineSqueezer.Recipe(timePerItem, InputHelper.toStacks(resources), InputHelper.toFluid(liquid), InputHelper.toStack(remnants), chance)));
        MachineSqueezer.RecipeManager.recipeFluids.add(InputHelper.getFluid(liquid));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack liquid) {
        MineTweakerAPI.apply((IUndoableAction)new Remove((List)MachineSqueezer.RecipeManager.recipes, InputHelper.toFluid(liquid)));
    }

    private static class Remove
    extends BaseListRemoval {
        public Remove(List list, FluidStack liquid) {
            super(list, liquid);
        }

        public void apply() {
            for (MachineSqueezer.Recipe r : MachineSqueezer.RecipeManager.recipes) {
                if (r.liquid == null || !r.liquid.isFluidEqual(this.fluid)) continue;
                this.recipe = r;
                break;
            }
            MachineSqueezer.RecipeManager.recipes.remove(this.recipe);
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(MachineSqueezer.Recipe recipe) {
            super("Forestry Squeezer", MachineSqueezer.RecipeManager.recipes, recipe);
        }

        @Override
        public String getRecipeInfo() {
            return ((MachineSqueezer.Recipe)this.recipe).liquid.getLocalizedName();
        }
    }
}

