/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.registries;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.definitions.IParts;
import appeng.api.features.IGrinderEntry;
import appeng.api.features.IInscriberRecipe;
import appeng.api.util.AEColor;
import appeng.api.util.AEColoredItemDefinition;
import appeng.core.features.registries.entries.InscriberRecipe;
import appeng.recipes.GroupIngredient;
import appeng.recipes.Ingredient;
import appeng.recipes.game.ShapedRecipe;
import appeng.recipes.game.ShapelessRecipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumicenergistics.api.Blocks;
import thaumicenergistics.api.Items;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.util.ThELog;

public class AEAspectRegister {
    public static final AEAspectRegister instance = new AEAspectRegister();
    private static int CRYSTAL_BASE = 2;
    private static int CRYSTAL_PURE = 5;
    private static int FLUIX_CHARGE = 6;
    private List<AEItemInfo> ALL_ITEMS = new ArrayList<AEItemInfo>();
    private List<AEItemInfo> ITEMS_TO_ADD = new ArrayList<AEItemInfo>();
    private List<AEItemInfo> ITEMS_REGISTERED = new ArrayList<AEItemInfo>();
    List<AEItemInfo> DEPENDENCY_CHAIN = new ArrayList<AEItemInfo>();
    List<AEItemInfo> UNREGISTERABLE = new ArrayList<AEItemInfo>();
    List<IRecipe> NORMAL_RECIPES;
    List<IGrinderEntry> GRINDER_RECIPES;
    List<IInscriberRecipe> INSCRIBER_RECIPES;

    private AEAspectRegister() {
    }

    private void registerBase() {
        IMaterials aeMats = AEApi.instance().definitions().materials();
        IBlocks aeBlocks = AEApi.instance().definitions().blocks();
        IParts aeParts = AEApi.instance().definitions().parts();
        AspectList aspects = new AspectList();
        aspects.add(Aspect.CRYSTAL, CRYSTAL_BASE);
        this.registerItem(aeMats.certusQuartzCrystal(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.CRYSTAL, CRYSTAL_BASE);
        aspects.add(Aspect.ENERGY, 4);
        this.registerItem(aeMats.certusQuartzCrystalCharged(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.CRYSTAL, CRYSTAL_PURE);
        this.registerItem(aeMats.purifiedCertusQuartzCrystal(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.CRYSTAL, CRYSTAL_BASE);
        aspects.add(Aspect.EARTH, 1);
        this.registerItem((IItemDefinition)aeBlocks.quartzOre(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.CRYSTAL, CRYSTAL_BASE);
        aspects.add(Aspect.EARTH, 1);
        aspects.add(Aspect.ENERGY, 4);
        this.registerItem((IItemDefinition)aeBlocks.quartzOreCharged(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.CRYSTAL, 1);
        aspects.add(Aspect.EXCHANGE, 1);
        this.registerItem(AEApi.instance().definitions().items().crystalSeed(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.CRYSTAL, CRYSTAL_BASE);
        aspects.add(Aspect.ENERGY, FLUIX_CHARGE);
        this.registerItem(aeMats.fluixCrystal(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.CRYSTAL, CRYSTAL_PURE);
        aspects.add(Aspect.ENERGY, FLUIX_CHARGE);
        this.registerItem(aeMats.purifiedFluixCrystal(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.ELDRITCH, 2);
        aspects.add(Aspect.MOTION, 2);
        aspects.add(Aspect.MAGIC, 1);
        aspects.add(Aspect.ENTROPY, 1);
        this.registerItem(aeMats.enderDust(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.CRYSTAL, CRYSTAL_PURE);
        aspects.add(Aspect.ENERGY, 1);
        this.registerItem(aeMats.purifiedNetherQuartzCrystal(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.FIRE, 1);
        aspects.add(Aspect.SENSES, 1);
        aspects.add(Aspect.ORDER, 1);
        this.registerItem(aeMats.silicon(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.EARTH, 1);
        aspects.add(Aspect.DARKNESS, 1);
        this.registerItem((IItemDefinition)aeBlocks.skyStone(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.SLIME, 4);
        aspects.add(Aspect.EARTH, 4);
        aspects.add(Aspect.FLIGHT, 4);
        this.registerItem(aeMats.matterBall(), aspects);
        AspectList cableAspects = new AspectList();
        cableAspects.add(Aspect.CRYSTAL, 1);
        cableAspects.add(Aspect.ENERGY, 2);
        this.registerItem((IItemDefinition)aeBlocks.multiPart(), cableAspects);
        aspects = cableAspects.copy();
        this.registerCableSet(aeParts.cableGlass(), aspects);
        aspects = cableAspects.copy();
        aspects.add(Aspect.CLOTH, 1);
        this.registerCableSet(aeParts.cableCovered(), aspects);
        aspects = cableAspects.copy();
        aspects.add(Aspect.CLOTH, 1);
        aspects.add(Aspect.LIGHT, 1);
        aspects.add(Aspect.ENERGY, 1);
        this.registerCableSet(aeParts.cableSmart(), aspects);
        aspects = cableAspects.copy();
        aspects.add(Aspect.CLOTH, 1);
        aspects.add(Aspect.LIGHT, 2);
        aspects.add(Aspect.ENERGY, 3);
        this.registerCableSet(aeParts.cableDense(), aspects);
        aspects = new AspectList();
        aspects.add(Aspect.METAL, 1);
        this.registerItem(aeParts.cableAnchor(), aspects);
        AspectList p2pAspects = new AspectList();
        p2pAspects.add(Aspect.METAL, 6);
        p2pAspects.add(Aspect.ENERGY, 6);
        p2pAspects.add(Aspect.CRYSTAL, 4);
        p2pAspects.add(Aspect.GREED, 4);
        p2pAspects.add(Aspect.ORDER, 4);
        p2pAspects.add(Aspect.SENSES, 4);
        this.registerItem(aeParts.p2PTunnelME(), p2pAspects);
        this.registerItem(aeParts.p2PTunnelItems(), p2pAspects);
        aspects = p2pAspects.copy();
        aspects.add(Aspect.WATER, 4);
        this.registerItem(aeParts.p2PTunnelLiquids(), aspects);
        aspects = p2pAspects.copy();
        aspects.add(Aspect.LIGHT, 4);
        this.registerItem(aeParts.p2PTunnelLight(), aspects);
        aspects = p2pAspects.copy();
        aspects.add(Aspect.ENERGY, 2);
        this.registerItem(aeParts.p2PTunnelRedstone(), aspects);
    }

    private void registerCableSet(AEColoredItemDefinition cableSet, AspectList aspects) {
        AEColor[] colors;
        for (AEColor color : colors = AEColor.values()) {
            ThaumcraftApi.registerObjectTag((ItemStack)cableSet.stack(color, 1), (AspectList)aspects);
        }
    }

    private void registerItem(IItemDefinition itemDef, AspectList aspects) {
        AEItemInfo itemInfo = this.getInfoForDefinitionOrStack(itemDef);
        if (itemInfo == null) {
            return;
        }
        itemInfo.bonusAspects = aspects;
        this.registerItem(itemInfo);
    }

    private void registerThEItems() {
        AspectList aeCellAspects;
        Items teItems = ThEApi.instance().items();
        Blocks teBlocks = ThEApi.instance().blocks();
        ItemStack aeCell = (ItemStack)AEApi.instance().definitions().items().cell1k().maybeStack(1).orNull();
        AspectList cellAspects = null;
        if (aeCell != null && (aeCellAspects = ThaumcraftApiHelper.getObjectAspects((ItemStack)aeCell)) != null) {
            cellAspects = aeCellAspects.copy();
            int aspectCount = cellAspects.size();
            if (aspectCount > 4) {
                Aspect[] OrderedAspects = cellAspects.getAspectsSortedAmount();
                cellAspects.remove(OrderedAspects[aspectCount - 1]);
                if (aspectCount > 5) {
                    cellAspects.remove(OrderedAspects[aspectCount - 2]);
                }
            }
            cellAspects.add(Aspect.MAGIC, 3);
            cellAspects.add(Aspect.AURA, 5);
            ThaumcraftApi.registerObjectTag((ItemStack)teItems.EssentiaCell_1k.getStack(), (AspectList)cellAspects);
            ThaumcraftApi.registerObjectTag((ItemStack)teItems.EssentiaCell_4k.getStack(), (AspectList)cellAspects);
            ThaumcraftApi.registerObjectTag((ItemStack)teItems.EssentiaCell_16k.getStack(), (AspectList)cellAspects);
            ThaumcraftApi.registerObjectTag((ItemStack)teItems.EssentiaCell_64k.getStack(), (AspectList)cellAspects);
        }
        if (aeCell == null || cellAspects == null) {
            ThELog.info("'%s' was not registered for TC scanning.", "Essentia Cells");
        }
        AspectList ironGearboxAspects = new AspectList();
        ironGearboxAspects.add(Aspect.METAL, 7);
        ironGearboxAspects.add(Aspect.MECHANISM, 5);
        ironGearboxAspects.add(Aspect.EARTH, 2);
        ironGearboxAspects.add(Aspect.ENTROPY, 2);
        ThaumcraftApi.registerObjectTag((ItemStack)teBlocks.IronGearBox.getStack(), (AspectList)ironGearboxAspects);
        AspectList thaumGearbox = ironGearboxAspects.copy();
        thaumGearbox.add(Aspect.MAGIC, 10);
        thaumGearbox.add(Aspect.MECHANISM, 5);
        thaumGearbox.add(Aspect.METAL, 3);
        ThaumcraftApi.registerObjectTag((ItemStack)teBlocks.ThaumiumGearBox.getStack(), (AspectList)thaumGearbox);
    }

    public void registerAEAspects() {
        long sectionStartTime = ThELog.beginSection("AE Scanables");
        this.NORMAL_RECIPES = CraftingManager.func_77594_a().func_77592_b();
        this.GRINDER_RECIPES = AEApi.instance().registries().grinder().getRecipes();
        this.INSCRIBER_RECIPES = AEApi.instance().registries().inscriber().getRecipes();
        this.getItemsFromAERegistryClass(AEApi.instance().definitions().materials());
        this.getItemsFromAERegistryClass(AEApi.instance().definitions().items());
        this.getItemsFromAERegistryClass(AEApi.instance().definitions().blocks());
        this.getItemsFromAERegistryClass(AEApi.instance().definitions().parts());
        this.registerBase();
        for (int pass = 1; pass <= 2; ++pass) {
            while (this.ITEMS_TO_ADD.size() > 0) {
                AEItemInfo itemInfo = this.ITEMS_TO_ADD.get(0);
                this.ITEMS_TO_ADD.remove(0);
                itemInfo.registerItem(pass);
            }
            if (pass != 1) continue;
            this.ITEMS_TO_ADD.addAll(this.UNREGISTERABLE);
            this.UNREGISTERABLE.clear();
        }
        this.registerThEItems();
        this.NORMAL_RECIPES = null;
        this.GRINDER_RECIPES = null;
        this.ALL_ITEMS = null;
        this.ITEMS_REGISTERED = null;
        this.ITEMS_TO_ADD = null;
        this.DEPENDENCY_CHAIN = null;
        this.UNREGISTERABLE = null;
        ThELog.endSection("AE Scanables", sectionStartTime);
    }

    AEItemInfo getInfoForDefinitionOrStack(Object itemDefinitionOrStack) {
        AEItemInfo itemInfo = null;
        int index = -1;
        for (int i = 0; i < this.ALL_ITEMS.size(); ++i) {
            if (!this.ALL_ITEMS.get(i).equals(itemDefinitionOrStack)) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            itemInfo = this.ALL_ITEMS.get(index);
        }
        return itemInfo;
    }

    void getItemsFromAERegistryClass(Object AEDefinitionInstance) {
        Field[] fields;
        for (Field f : fields = AEDefinitionInstance.getClass().getDeclaredFields()) {
            try {
                AEItemInfo itemInfo;
                f.setAccessible(true);
                Object fObj = f.get(AEDefinitionInstance);
                if (!(fObj instanceof IItemDefinition) || this.ITEMS_REGISTERED.contains(itemInfo = new AEItemInfo((IItemDefinition)fObj))) continue;
                this.ITEMS_TO_ADD.add(itemInfo);
                this.ALL_ITEMS.add(itemInfo);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    void registerItem(AEItemInfo itemInfo) {
        this.ITEMS_TO_ADD.remove(itemInfo);
        if (!this.ITEMS_REGISTERED.contains(itemInfo)) {
            this.ITEMS_REGISTERED.add(itemInfo);
            ThaumcraftApi.registerObjectTag((ItemStack)itemInfo.itemStack, (AspectList)itemInfo.getFinalAspects());
        }
    }

    private class AEItemInfo {
        private String displayName = "";
        private ItemStack[] ingredients = null;
        private AspectList ingredientAspects = new AspectList();
        private Object recipe = null;
        private IItemDefinition definition;
        public AspectList bonusAspects = new AspectList();
        public ItemStack itemStack;
        private int pass;

        public AEItemInfo(IItemDefinition itemDef) {
            this.definition = itemDef;
            this.itemStack = (ItemStack)itemDef.maybeStack(1).orNull();
            if (this.itemStack != null) {
                this.displayName = this.itemStack.func_82833_r();
            }
        }

        private void addPredefinedBonuses() {
            IBlocks aeBlocks = AEApi.instance().definitions().blocks();
            IMaterials aeMats = AEApi.instance().definitions().materials();
            if (this.recipe instanceof IGrinderEntry) {
                this.bonusAspects.add(Aspect.ENTROPY, 1);
                this.ingredientAspects.remove(Aspect.EARTH);
            } else if (this.definition.equals(aeBlocks.molecularAssembler())) {
                this.bonusAspects.add(Aspect.CRAFT, 4);
                this.bonusAspects.add(Aspect.ENERGY, 6);
                this.bonusAspects.add(Aspect.MECHANISM, 2);
                this.bonusAspects.add(Aspect.CRYSTAL, 1);
            } else if (this.definition.equals(aeBlocks.skyStone())) {
                this.bonusAspects.add(Aspect.DARKNESS, 3);
            } else if (this.definition.equals(aeBlocks.skyChest())) {
                this.bonusAspects.add(Aspect.VOID, 4);
                this.ingredientAspects.remove(Aspect.EARTH);
            } else if (this.definition.equals(aeBlocks.quartzGlass())) {
                this.bonusAspects.add(Aspect.CRYSTAL, 4);
            } else if (this.definition.equals(aeBlocks.controller())) {
                this.bonusAspects.add(Aspect.MECHANISM, 3);
                this.bonusAspects.add(Aspect.SENSES, 1);
                this.bonusAspects.add(Aspect.MIND, 9);
                this.ingredientAspects.remove(Aspect.FIRE);
                this.ingredientAspects.remove(Aspect.ORDER);
            } else if (this.definition.equals(aeBlocks.drive())) {
                this.bonusAspects.add(Aspect.VOID, 4);
                this.ingredientAspects.remove(Aspect.FIRE);
                this.ingredientAspects.remove(Aspect.ORDER);
                this.ingredientAspects.remove(Aspect.SENSES);
                this.ingredientAspects.remove(Aspect.MECHANISM);
            } else if (this.definition.equals(aeBlocks.chest())) {
                this.bonusAspects.add(Aspect.VOID, 4);
                this.ingredientAspects.remove(Aspect.FIRE);
                this.ingredientAspects.remove(Aspect.ORDER);
                this.ingredientAspects.remove(Aspect.SENSES);
                this.ingredientAspects.remove(Aspect.MECHANISM);
            } else if (this.definition.equals(aeBlocks.iOPort())) {
                this.bonusAspects.add(Aspect.EXCHANGE, 4);
                this.ingredientAspects.remove(Aspect.FIRE);
                this.ingredientAspects.remove(Aspect.ORDER);
                this.ingredientAspects.remove(Aspect.SENSES);
                this.ingredientAspects.remove(Aspect.MECHANISM);
            } else if (this.definition.equals(aeBlocks.condenser())) {
                this.bonusAspects.add(Aspect.VOID, 10);
            } else if (this.definition.equals(aeMats.cardRedstone())) {
                this.bonusAspects.add(Aspect.SENSES, 2);
            } else if (this.definition.equals(aeBlocks.cellWorkbench())) {
                this.bonusAspects.add(Aspect.CLOTH, 2);
            } else if (this.definition.equals(aeBlocks.iface())) {
                this.bonusAspects.add(Aspect.EXCHANGE, 6);
            } else if (this.definition.equals(aeMats.logicProcessor())) {
                this.ingredientAspects.remove(Aspect.METAL);
                this.ingredientAspects.remove(Aspect.FIRE);
                this.ingredientAspects.remove(Aspect.ORDER);
                this.bonusAspects.add(Aspect.MIND, 3);
                this.bonusAspects.add(Aspect.METAL, 1);
            } else if (this.definition.equals(aeMats.calcProcessor())) {
                this.ingredientAspects.remove(Aspect.METAL);
                this.ingredientAspects.remove(Aspect.FIRE);
                this.ingredientAspects.remove(Aspect.ORDER);
                this.bonusAspects.add(Aspect.MIND, 6);
                this.bonusAspects.add(Aspect.METAL, 1);
            } else if (this.definition.equals(aeMats.engProcessor())) {
                this.ingredientAspects.remove(Aspect.METAL);
                this.ingredientAspects.remove(Aspect.FIRE);
                this.ingredientAspects.remove(Aspect.ORDER);
                this.bonusAspects.add(Aspect.MIND, 9);
            }
        }

        private void buildAspects() {
            ItemStack recipeOutput;
            for (IGrinderEntry iGrinderEntry : AEAspectRegister.this.GRINDER_RECIPES) {
                try {
                    recipeOutput = iGrinderEntry.getOutput();
                    if (recipeOutput == null || recipeOutput.func_77973_b() == null || !this.areStacksEqualIgnoreAmount(recipeOutput, this.itemStack) || !this.isRecipeUsable(iGrinderEntry)) continue;
                    return;
                }
                catch (Exception e) {
                }
            }
            if (AEAspectRegister.this.INSCRIBER_RECIPES != null) {
                for (IInscriberRecipe iInscriberRecipe : AEAspectRegister.this.INSCRIBER_RECIPES) {
                    try {
                        recipeOutput = iInscriberRecipe.getOutput();
                        if (recipeOutput == null || recipeOutput.func_77973_b() == null || !this.areStacksEqualIgnoreAmount(recipeOutput, this.itemStack) || !this.isRecipeUsable(iInscriberRecipe)) continue;
                        return;
                    }
                    catch (Exception e) {
                    }
                }
            }
            for (IRecipe iRecipe : AEAspectRegister.this.NORMAL_RECIPES) {
                try {
                    recipeOutput = iRecipe.func_77571_b();
                    if (recipeOutput == null || recipeOutput.func_77973_b() == null || !this.areStacksEqualIgnoreAmount(recipeOutput, this.itemStack) || !this.isRecipeUsable(iRecipe)) continue;
                    return;
                }
                catch (Exception exception) {
                }
            }
        }

        private void findAspectsForIngredients() {
            for (ItemStack stack : this.ingredients) {
                AEItemInfo ingInfo;
                AspectList stackAspects = ThaumcraftApiHelper.getObjectAspects((ItemStack)stack);
                if (!(stackAspects != null && stackAspects.size() != 0 || (ingInfo = AEAspectRegister.this.getInfoForDefinitionOrStack(stack)) == null || AEAspectRegister.this.DEPENDENCY_CHAIN.contains(ingInfo))) {
                    ingInfo.registerItem(this.pass);
                    stackAspects = ThaumcraftApiHelper.getObjectAspects((ItemStack)stack);
                }
                if (stackAspects == null || stackAspects.size() == 0) continue;
                for (Aspect currentStackAspect : stackAspects.getAspects()) {
                    int ingredientAspectAmount;
                    int existingAmount = this.ingredientAspects.getAmount(currentStackAspect);
                    if (existingAmount >= (ingredientAspectAmount = stackAspects.getAmount(currentStackAspect))) continue;
                    this.ingredientAspects.add(currentStackAspect, ingredientAspectAmount - existingAmount);
                }
            }
        }

        private void getIngredientsForRecipe() {
            Object[] ingredientObjects = null;
            if (this.recipe instanceof ShapedRecipe) {
                ingredientObjects = ((ShapedRecipe)this.recipe).getInput();
            } else if (this.recipe instanceof ShapelessRecipe) {
                ingredientObjects = ((ShapelessRecipe)this.recipe).getInput().toArray();
            } else if (this.recipe instanceof IGrinderEntry) {
                ingredientObjects = new Object[]{((IGrinderEntry)this.recipe).getInput()};
                this.bonusAspects.add(Aspect.ENTROPY, 1);
            } else if (this.recipe instanceof InscriberRecipe) {
                InscriberRecipe iRec = (InscriberRecipe)this.recipe;
                ArrayList<Object> inputs = new ArrayList<Object>(iRec.getInputs());
                if (iRec.getTopOptional().isPresent()) {
                    inputs.add(iRec.getTopOptional().get());
                }
                if (iRec.getBottomOptional().isPresent()) {
                    inputs.add(iRec.getBottomOptional().get());
                }
                ingredientObjects = inputs.toArray(new Object[inputs.size()]);
            } else if (this.recipe instanceof ShapedRecipes) {
                ingredientObjects = ((ShapedRecipes)this.recipe).field_77574_d;
            } else if (this.recipe instanceof ShapelessRecipes) {
                ingredientObjects = ((ShapelessRecipes)this.recipe).field_77579_b.toArray();
            }
            if (ingredientObjects != null) {
                ArrayList<ItemStack> ingredientStackList = new ArrayList<ItemStack>();
                for (int i = 0; i < ingredientObjects.length; ++i) {
                    Object ing = ingredientObjects[i];
                    if (ing == null) continue;
                    ItemStack currentIngredientStack = null;
                    try {
                        if (ing instanceof Ingredient) {
                            currentIngredientStack = ((Ingredient)ing).nameSpace.equalsIgnoreCase("oreDictionary") ? ((Ingredient)ing).getItemStackSet()[0] : ((Ingredient)ing).getItemStack();
                        } else if (ing instanceof GroupIngredient) {
                            currentIngredientStack = ((GroupIngredient)ing).getItemStackSet()[0];
                        } else if (ing instanceof ItemStack) {
                            currentIngredientStack = (ItemStack)ing;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (currentIngredientStack == null) continue;
                    ingredientStackList.add(currentIngredientStack);
                }
                if (ingredientStackList.size() > 0) {
                    this.ingredients = new ItemStack[ingredientStackList.size()];
                    this.ingredients = ingredientStackList.toArray(this.ingredients);
                }
            }
        }

        private boolean isRecipeUsable(Object recipe) {
            this.recipe = recipe;
            this.getIngredientsForRecipe();
            if (this.ingredients != null) {
                this.findAspectsForIngredients();
                if (this.ingredientAspects.size() != 0) {
                    return true;
                }
            }
            this.recipe = null;
            return false;
        }

        public boolean areStacksEqualIgnoreAmount(ItemStack stack1, ItemStack stack2) {
            if (stack1 == null || stack2 == null || stack1.func_77973_b() == null || stack2.func_77973_b() == null) {
                return false;
            }
            if (stack1.func_77973_b().equals(stack2.func_77973_b())) {
                if (stack1.func_77981_g()) {
                    if (stack1.func_77960_j() == stack2.func_77960_j()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AEItemInfo) {
                return this.isMatch(((AEItemInfo)obj).itemStack);
            }
            if (obj instanceof ItemStack) {
                return this.isMatch((ItemStack)obj);
            }
            if (obj instanceof IItemDefinition) {
                return this.isMatch((ItemStack)((IItemDefinition)obj).maybeStack(1).orNull());
            }
            return false;
        }

        public AspectList getFinalAspects() {
            int aspectCount;
            AspectList finalAspects = new AspectList();
            if (this.ingredientAspects != null) {
                for (Aspect aspect : this.ingredientAspects.getAspects()) {
                    if (aspect == null) continue;
                    finalAspects.add(aspect, this.ingredientAspects.getAmount(aspect));
                }
            }
            if (this.bonusAspects != null) {
                for (Aspect aspect : this.bonusAspects.getAspects()) {
                    if (aspect == null) continue;
                    finalAspects.add(aspect, this.bonusAspects.getAmount(aspect));
                }
            }
            if ((aspectCount = finalAspects.size()) == 0) {
                return finalAspects;
            }
            if (aspectCount > 6) {
                Aspect[] aspects = finalAspects.getAspectsSortedAmount();
                for (int index = 6; index < aspects.length; ++index) {
                    finalAspects.remove(aspects[index]);
                }
            }
            return finalAspects;
        }

        public int hashCode() {
            return this.itemStack.func_77973_b().hashCode() + this.itemStack.func_77960_j();
        }

        public boolean isMatch(ItemStack stack) {
            return this.areStacksEqualIgnoreAmount(stack, this.itemStack);
        }

        public void registerItem(int pass) {
            this.pass = pass;
            if (this.itemStack != null) {
                AEAspectRegister.this.DEPENDENCY_CHAIN.add(this);
                this.buildAspects();
                this.addPredefinedBonuses();
                AEAspectRegister.this.DEPENDENCY_CHAIN.remove(this);
            }
            if (this.ingredientAspects.size() == 0 && this.bonusAspects.size() == 0) {
                if (pass == 1) {
                    AEAspectRegister.this.UNREGISTERABLE.add(this);
                } else if (!this.displayName.isEmpty()) {
                    ThELog.info("'%s' was not registered for TC scanning.", this.displayName);
                }
                return;
            }
            AEAspectRegister.this.registerItem(this);
        }

        public String toString() {
            return this.displayName;
        }
    }
}

