/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityReactorPowerTap
extends TileEntityReactorPart
implements IEnergyProvider,
INeighborUpdatableEntity {
    IEnergyReceiver rfNetwork = null;

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborBlock) {
        if (this.isConnected()) {
            this.checkForConnections((IBlockAccess)world, x, y, z);
        }
    }

    @Override
    public void onNeighborTileChange(IBlockAccess world, int x, int y, int z, int neighborX, int neighborY, int neighborZ) {
        if (this.isConnected()) {
            this.checkForConnections(world, x, y, z);
        }
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.checkForConnections((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockControllerBase) {
        super.onMachineAssembled(multiblockControllerBase);
        this.checkForConnections((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.notifyNeighborsOfTileChange();
    }

    protected void checkForConnections(IBlockAccess world, int x, int y, int z) {
        boolean isConnected;
        boolean wasConnected = this.rfNetwork != null;
        ForgeDirection out = this.getOutwardsDir();
        if (out == ForgeDirection.UNKNOWN) {
            wasConnected = false;
            this.rfNetwork = null;
        } else {
            IEnergyReceiver handler;
            this.rfNetwork = null;
            TileEntity te = world.func_147438_o(x + out.offsetX, y + out.offsetY, z + out.offsetZ);
            if (!(te instanceof TileEntityReactorPowerTap) && te instanceof IEnergyReceiver && (handler = (IEnergyReceiver)te).canConnectEnergy(out.getOpposite())) {
                this.rfNetwork = handler;
            }
        }
        boolean bl = isConnected = this.rfNetwork != null;
        if (wasConnected != isConnected) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int onProvidePower(int units) {
        if (this.rfNetwork == null) {
            return units;
        }
        ForgeDirection approachDirection = this.getOutwardsDir().getOpposite();
        int energyConsumed = this.rfNetwork.receiveEnergy(approachDirection, units, false);
        return units -= energyConsumed;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.getOutwardsDir();
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.isConnected()) {
            return 0;
        }
        if (from == this.getOutwardsDir()) {
            return this.getReactorController().extractEnergy(from, maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (!this.isConnected()) {
            return 0;
        }
        return this.getReactorController().getEnergyStored(from);
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (!this.isConnected()) {
            return 0;
        }
        return this.getReactorController().getMaxEnergyStored(from);
    }

    public boolean hasEnergyConnection() {
        return this.rfNetwork != null;
    }
}

