/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.yunomakegoodmap;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.lex.yunomakegoodmap.VoidWorldType;
import net.minecraftforge.lex.yunomakegoodmap.WorldProviderEndVoid;
import net.minecraftforge.lex.yunomakegoodmap.WorldProviderHellVoid;
import net.minecraftforge.lex.yunomakegoodmap.WorldProviderSurfaceVoid;
import net.minecraftforge.lex.yunomakegoodmap.generators.IPlatformGenerator;
import net.minecraftforge.lex.yunomakegoodmap.generators.SingleBlockPlatform;
import net.minecraftforge.lex.yunomakegoodmap.generators.SkyBlock21;
import net.minecraftforge.lex.yunomakegoodmap.generators.TreePlatform;
import org.apache.logging.log4j.Level;

@Mod(modid="YUNoMakeGoodMap", name="YUNoMakeGoodMap", version="3.0", dependencies="after: BiomesOPlenty")
public class YUNoMakeGoodMap {
    @Mod.Instance(value="YUNoMakeGoodMap")
    public static YUNoMakeGoodMap instance;
    private VoidWorldType worldType;
    private boolean overrideDefault = false;
    private String platformType = "grass";
    private boolean generateSpikes = false;
    private boolean generateNetherFortress = false;
    private Map<String, IPlatformGenerator> generators = Maps.newHashMap();

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        Configuration config = null;
        File cfgFile = event.getSuggestedConfigurationFile();
        try {
            config = new Configuration(cfgFile);
        }
        catch (Exception e) {
            FMLLog.severe((String)"[YUNoMakeGoodMap] Error loading config, deleting file and resetting: ", (Object[])new Object[0]);
            e.printStackTrace();
            if (cfgFile.exists()) {
                cfgFile.delete();
            }
            config = new Configuration(cfgFile);
        }
        Property prop = config.get("general", "overrideDefault", this.overrideDefault);
        prop.comment = "Set to true to force the default world types to be void world. Use with caution.";
        this.overrideDefault = prop.getBoolean(this.overrideDefault);
        prop = config.get("general", "platformType", this.platformType);
        prop.comment = "Set the type of platform to create in the overworld, Possible values: \n  'grass' A single grass block\n  'tree' a small oak tree on a grass block\n  'skyblock21' For SkyBlock v2.1 platforms";
        this.platformType = prop.getString();
        prop = config.get("general", "generateSpikes", this.generateSpikes);
        prop.comment = "Set to true to enable generation of the obsidian 'spikes' in the end.";
        this.generateSpikes = prop.getBoolean(this.generateSpikes);
        prop = config.get("general", "generateNetherFortress", this.generateNetherFortress);
        prop.comment = "Set to true to enable generation of the nether fortresses.";
        this.generateNetherFortress = prop.getBoolean(this.generateNetherFortress);
        if (config.hasChanged()) {
            config.save();
        }
        this.generators.put("grass", new SingleBlockPlatform((Block)Blocks.field_150349_c));
        this.generators.put("tree", new TreePlatform());
        this.generators.put("skyblock21", new SkyBlock21());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        FMLLog.log((Level)Level.INFO, (String)"YUNoMakeGoodMap Initalized", (Object[])new Object[0]);
        this.worldType = new VoidWorldType();
        Hashtable providers = (Hashtable)ReflectionHelper.getPrivateValue(DimensionManager.class, null, (String[])new String[]{"providers"});
        providers.put(-1, WorldProviderHellVoid.class);
        providers.put(0, WorldProviderSurfaceVoid.class);
        providers.put(1, WorldProviderEndVoid.class);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world instanceof WorldServer) {
            WorldServer world = (WorldServer)event.world;
            int spawnX = (int)((double)event.world.func_72912_H().func_76079_c() / world.field_73011_w.getMovementFactor() / 16.0);
            int spawnZ = (int)((double)event.world.func_72912_H().func_76074_e() / world.field_73011_w.getMovementFactor() / 16.0);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    world.field_73059_b.func_73158_c(spawnX + x, spawnZ + z);
                }
            }
        }
    }

    public boolean shouldBeVoid(World world) {
        return this.overrideDefault || world.func_72912_H().func_76067_t() == this.worldType;
    }

    public IPlatformGenerator getPlatformType(World world) {
        IPlatformGenerator ret;
        if (this.platformType == null) {
            this.platformType = "grass";
        }
        if ((ret = this.generators.get(this.platformType.toLowerCase(Locale.ENGLISH))) == null) {
            this.platformType = "grass";
            ret = this.generators.get(this.platformType);
        }
        return ret;
    }

    public boolean shouldGenerateSpikes(World world) {
        return this.generateSpikes;
    }

    public boolean shouldGenerateNetherFortress(World world) {
        return this.generateNetherFortress;
    }
}

