/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidHelper {
    public static final int BUCKET_VOLUME = 1000;
    public static final Fluid WATER_FLUID = FluidRegistry.WATER;
    public static final Fluid LAVA_FLUID = FluidRegistry.LAVA;
    public static final FluidStack WATER = new FluidStack(WATER_FLUID, 1000);
    public static final FluidStack LAVA = new FluidStack(LAVA_FLUID, 1000);
    public static final FluidTankInfo[] NULL_TANK_INFO = new FluidTankInfo[0];

    private FluidHelper() {
    }

    public static FluidStack extractFluidFromHeldContainer(EntityPlayer player, int maxDrain, boolean doDrain) {
        ItemStack container = player.func_71045_bC();
        return FluidHelper.isFluidContainerItem(container) ? ((IFluidContainerItem)container.func_77973_b()).drain(container, maxDrain, doDrain) : null;
    }

    public static int insertFluidIntoHeldContainer(EntityPlayer player, FluidStack resource, boolean doFill) {
        ItemStack container = player.func_71045_bC();
        return FluidHelper.isFluidContainerItem(container) ? ((IFluidContainerItem)container.func_77973_b()).fill(container, resource, doFill) : 0;
    }

    public static boolean isPlayerHoldingFluidContainerItem(EntityPlayer player) {
        return FluidHelper.isFluidContainerItem(player.func_71045_bC());
    }

    public static boolean isFluidContainerItem(ItemStack container) {
        return container != null && container.func_77973_b() instanceof IFluidContainerItem;
    }

    public static FluidStack getFluidStackFromContainerItem(ItemStack container) {
        return ((IFluidContainerItem)container.func_77973_b()).getFluid(container);
    }

    public static ItemStack setDefaultFluidTag(ItemStack container, FluidStack resource) {
        container.func_77982_d(new NBTTagCompound());
        NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
        container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
        return container;
    }

    public static FluidStack extractFluidFromAdjacentFluidHandler(TileEntity tile, int side, int maxDrain, boolean doDrain) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        return handler instanceof IFluidHandler ? ((IFluidHandler)handler).drain(ForgeDirection.VALID_DIRECTIONS[side ^ 1], maxDrain, doDrain) : null;
    }

    public static int insertFluidIntoAdjacentFluidHandler(TileEntity tile, int side, FluidStack fluid, boolean doFill) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        return handler instanceof IFluidHandler ? ((IFluidHandler)handler).fill(ForgeDirection.VALID_DIRECTIONS[side ^ 1], fluid, doFill) : 0;
    }

    public static boolean isAdjacentFluidHandler(TileEntity tile, int side) {
        return BlockHelper.getAdjacentTileEntity(tile, side) instanceof IFluidHandler;
    }

    public static boolean isFluidHandler(TileEntity tile) {
        return tile instanceof IFluidHandler;
    }

    public static boolean fillContainerFromHandler(World world, IFluidHandler handler, EntityPlayer player, FluidStack tankFluid) {
        ItemStack container = player.func_71045_bC();
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)container)) {
            ItemStack returnStack = FluidContainerRegistry.fillFluidContainer((FluidStack)tankFluid, (ItemStack)container);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)returnStack);
            if (fluid == null || returnStack == null) {
                return false;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (container.field_77994_a == 1) {
                    container = container.func_77946_l();
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, returnStack);
                } else if (!player.field_71071_by.func_70441_a(returnStack)) {
                    return false;
                }
                handler.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
                --container.field_77994_a;
                if (container.field_77994_a <= 0) {
                    container = null;
                }
            } else {
                handler.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
            }
            return true;
        }
        return false;
    }

    public static boolean fillHandlerWithContainer(World world, IFluidHandler handler, EntityPlayer player) {
        ItemStack container = player.func_71045_bC();
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        if (fluid != null && (handler.fill(ForgeDirection.UNKNOWN, fluid, false) == fluid.amount || player.field_71075_bZ.field_75098_d)) {
            if (ServerHelper.isClientWorld(world)) {
                return true;
            }
            handler.fill(ForgeDirection.UNKNOWN, fluid, true);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemHelper.consumeItem(container));
            }
            return true;
        }
        return false;
    }

    public static void writeFluidStackToPacket(FluidStack fluid, DataOutput data) throws IOException {
        if (!FluidHelper.isValidFluidStack(fluid)) {
            data.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)fluid.writeToNBT(new NBTTagCompound()));
            data.writeShort((short)abyte.length);
            data.write(abyte);
        }
    }

    public static FluidStack readFluidStackFromPacket(DataInput data) throws IOException {
        short length = data.readShort();
        if (length < 0) {
            return null;
        }
        byte[] abyte = new byte[length];
        data.readFully(abyte);
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)new NBTSizeTracker(0x200000L)));
    }

    public static boolean isValidFluidStack(FluidStack fluid) {
        return fluid == null ? false : (fluid.fluidID == 0 ? false : FluidRegistry.getFluidName((FluidStack)fluid) != null);
    }

    public static int getFluidLuminosity(FluidStack fluid) {
        return fluid == null ? 0 : FluidHelper.getFluidLuminosity(fluid.getFluid());
    }

    public static int getFluidLuminosity(Fluid fluid) {
        return fluid == null ? 0 : fluid.getLuminosity();
    }

    public static FluidStack getFluidFromWorld(World world, int x, int y, int z) {
        Block bId = world.func_147439_a(x, y, z);
        int bMeta = world.func_72805_g(x, y, z);
        if (Block.func_149680_a((Block)bId, (Block)Blocks.field_150355_j)) {
            if (bMeta == 0) {
                return WATER.copy();
            }
            return null;
        }
        if (Block.func_149680_a((Block)bId, (Block)Blocks.field_150353_l)) {
            if (bMeta == 0) {
                return LAVA.copy();
            }
            return null;
        }
        if (bId instanceof IFluidBlock) {
            IFluidBlock block = (IFluidBlock)bId;
            return block.drain(world, x, y, z, true);
        }
        return null;
    }

    public static Fluid lookupFluidForBlock(Block block) {
        if (block == Blocks.field_150358_i) {
            return WATER_FLUID;
        }
        if (block == Blocks.field_150356_k) {
            return LAVA_FLUID;
        }
        return FluidRegistry.lookupFluidForBlock((Block)block);
    }

    public static FluidStack getFluidForFilledItem(ItemStack container) {
        if (container != null && container.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)container.func_77973_b()).getFluid(container);
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
    }

    public static boolean isFluidEqualOrNull(FluidStack resourceA, FluidStack resourceB) {
        return resourceA == null || resourceB == null || resourceA.isFluidEqual(resourceB);
    }

    public static boolean isFluidEqualOrNull(Fluid fluidA, FluidStack resourceB) {
        return fluidA == null || resourceB == null || fluidA == resourceB.getFluid();
    }

    public static boolean isFluidEqualOrNull(Fluid fluidA, Fluid fluidB) {
        return fluidA == null || fluidB == null || fluidA == fluidB;
    }

    public static boolean isFluidEqual(FluidStack resourceA, FluidStack resourceB) {
        return resourceA != null && resourceA.isFluidEqual(resourceB);
    }

    public static boolean isFluidEqual(Fluid fluidA, FluidStack resourceB) {
        return fluidA != null && resourceB != null && fluidA == resourceB.getFluid();
    }

    public static boolean isFluidEqual(Fluid fluidA, Fluid fluidB) {
        return fluidA != null && fluidB != null && fluidA.equals(fluidB);
    }
}

