/*
 * Decompiled with CFR 0.152.
 */
package org.wyldmods.simpleachievements.common.data;

import java.util.Arrays;
import java.util.List;
import org.wyldmods.simpleachievements.common.config.ConfigHandler;
import org.wyldmods.simpleachievements.common.data.Element;

public class DataHandler {
    private Element[] elements;

    public DataHandler(List<Element> listOfElements) {
        this.elements = new Element[listOfElements.size()];
        for (int i = 0; i < listOfElements.size(); ++i) {
            this.elements[i] = listOfElements.get(i);
        }
    }

    public DataHandler() {
        this(ConfigHandler.defaultElements);
    }

    public void toggleAchievement(Element ach) {
        ach.toggle();
    }

    public void toggleAchievement(int id) {
        this.toggleAchievement(this.elements[id]);
    }

    public Element getAchievement(int id) {
        return this.elements[id];
    }

    public String getAchievementText(int id) {
        return this.elements[id].getText();
    }

    public boolean getAchievementState(int id) {
        return this.elements[id].getState();
    }

    public List<Element> getAchievementList() {
        return Arrays.asList(this.elements);
    }

    public Element[] getAchievementArr() {
        return Arrays.copyOf(this.elements, this.elements.length);
    }

    public int numElements() {
        return this.elements.length;
    }
}

