/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.block.BlockRotationMode;
import openmods.block.OpenBlock;
import openmods.utils.ColorUtils;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    private static float fogRed;
    private static float fogGreen;
    private static float fogBlue;

    public static void setupBillboard(Entity rve) {
        GL11.glRotatef((float)(-rve.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rve.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static World getRenderWorld() {
        if (Minecraft.func_71410_x() != null) {
            return Minecraft.func_71410_x().field_71441_e;
        }
        return null;
    }

    public static double interpolateValue(double current, double prev, float partialTickTime) {
        return prev + (double)partialTickTime * (current - prev);
    }

    public static float interpolateYaw(Entity e, float f) {
        return e.field_70126_B + (e.field_70177_z - e.field_70126_B) * f;
    }

    public static float interpolatePitch(Entity e, float f) {
        return e.field_70127_C + (e.field_70125_A - e.field_70127_C) * f;
    }

    public static void translateToPlayer(Entity e, float partialTickTime) {
        GL11.glTranslated((double)(RenderUtils.interpolateValue(e.field_70165_t, e.field_70169_q, partialTickTime) - RenderManager.field_78725_b), (double)(RenderUtils.interpolateValue(e.field_70163_u, e.field_70167_r, partialTickTime) - RenderManager.field_78726_c), (double)(RenderUtils.interpolateValue(e.field_70161_v, e.field_70166_s, partialTickTime) - RenderManager.field_78723_d));
    }

    public static void translateToWorld(Entity e, float partialTickTime) {
        GL11.glTranslated((double)RenderUtils.interpolateValue(e.field_70165_t, e.field_70169_q, partialTickTime), (double)RenderUtils.interpolateValue(e.field_70163_u, e.field_70167_r, partialTickTime), (double)RenderUtils.interpolateValue(e.field_70161_v, e.field_70166_s, partialTickTime));
    }

    public static void rotateFacesOnRenderer(OpenBlock block, ForgeDirection rotation, RenderBlocks renderer) {
        BlockRotationMode mode = block.getRotationMode();
        block0 : switch (mode) {
            case SIX_DIRECTIONS: {
                switch (rotation) {
                    case DOWN: {
                        renderer.field_147871_s = 3;
                        renderer.field_147869_t = 3;
                        renderer.field_147875_q = 3;
                        renderer.field_147873_r = 3;
                        break block0;
                    }
                    case EAST: {
                        renderer.field_147867_u = 1;
                        renderer.field_147865_v = 2;
                        renderer.field_147873_r = 1;
                        renderer.field_147875_q = 2;
                        break block0;
                    }
                    case NORTH: {
                        renderer.field_147869_t = 2;
                        renderer.field_147871_s = 1;
                        break block0;
                    }
                    case SOUTH: {
                        renderer.field_147867_u = 3;
                        renderer.field_147865_v = 3;
                        renderer.field_147869_t = 1;
                        renderer.field_147871_s = 2;
                        break block0;
                    }
                    case UNKNOWN: {
                        break block0;
                    }
                    case UP: {
                        break block0;
                    }
                    case WEST: {
                        renderer.field_147867_u = 2;
                        renderer.field_147865_v = 1;
                        renderer.field_147873_r = 2;
                        renderer.field_147875_q = 1;
                        break block0;
                    }
                }
                break;
            }
            case FOUR_DIRECTIONS: {
                switch (rotation) {
                    case EAST: {
                        renderer.field_147867_u = 1;
                        break block0;
                    }
                    case WEST: {
                        renderer.field_147867_u = 2;
                        break block0;
                    }
                    case SOUTH: {
                        renderer.field_147867_u = 3;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public static void resetFacesOnRenderer(RenderBlocks renderer) {
        renderer.field_147865_v = 0;
        renderer.field_147875_q = 0;
        renderer.field_147869_t = 0;
        renderer.field_147871_s = 0;
        renderer.field_147867_u = 0;
        renderer.field_147873_r = 0;
        renderer.field_147842_e = false;
    }

    public static void renderInventoryBlock(RenderBlocks renderer, Block block, ForgeDirection rotation) {
        RenderUtils.renderInventoryBlock(renderer, block, rotation, -1);
    }

    public static void renderInventoryBlock(RenderBlocks renderer, Block block, ForgeDirection rotation, int colorMultiplier) {
        RenderUtils.renderInventoryBlock(renderer, block, rotation, colorMultiplier, EnumSet.allOf(ForgeDirection.class));
    }

    public static void renderInventoryBlock(RenderBlocks renderer, Block block, ForgeDirection rotation, int colorMultiplier, Set<ForgeDirection> enabledSides) {
        Tessellator tessellator = Tessellator.field_78398_a;
        block.func_149683_g();
        renderer.func_147775_a(block);
        if (colorMultiplier > -1) {
            float r = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
            float g = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
            float b = (float)(colorMultiplier & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        int metadata = rotation.ordinal();
        if (enabledSides.contains(ForgeDirection.DOWN)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides.contains(ForgeDirection.UP)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides.contains(ForgeDirection.SOUTH)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides.contains(ForgeDirection.NORTH)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides.contains(ForgeDirection.WEST)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides.contains(ForgeDirection.EAST)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
            tessellator.func_78381_a();
        }
        GL11.glPopMatrix();
    }

    public static void renderCube(Tessellator tes, double x1, double y1, double z1, double x2, double y2, double z2) {
        tes.func_78377_a(x1, y1, z1);
        tes.func_78377_a(x1, y2, z1);
        tes.func_78377_a(x2, y2, z1);
        tes.func_78377_a(x2, y1, z1);
        tes.func_78377_a(x1, y1, z2);
        tes.func_78377_a(x2, y1, z2);
        tes.func_78377_a(x2, y2, z2);
        tes.func_78377_a(x1, y2, z2);
        tes.func_78377_a(x1, y1, z1);
        tes.func_78377_a(x1, y1, z2);
        tes.func_78377_a(x1, y2, z2);
        tes.func_78377_a(x1, y2, z1);
        tes.func_78377_a(x2, y1, z1);
        tes.func_78377_a(x2, y2, z1);
        tes.func_78377_a(x2, y2, z2);
        tes.func_78377_a(x2, y1, z2);
        tes.func_78377_a(x1, y1, z1);
        tes.func_78377_a(x2, y1, z1);
        tes.func_78377_a(x2, y1, z2);
        tes.func_78377_a(x1, y1, z2);
        tes.func_78377_a(x1, y2, z1);
        tes.func_78377_a(x1, y2, z2);
        tes.func_78377_a(x2, y2, z2);
        tes.func_78377_a(x2, y2, z1);
    }

    public static void disableLightmap() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void enableLightmap() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static ColorUtils.RGB getFogColor() {
        return new ColorUtils.RGB(fogRed, fogGreen, fogBlue);
    }

    public static void registerFogUpdater() {
        MinecraftForge.EVENT_BUS.register((Object)new FogColorUpdater());
    }

    public static class FogColorUpdater {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onFogColor(EntityViewRenderEvent.FogColors evt) {
            fogRed = evt.red;
            fogGreen = evt.green;
            fogBlue = evt.blue;
        }
    }
}

