/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.oc.asm.object;

import java.util.Map;
import java.util.Set;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.IndexedMethodMap;
import openperipheral.interfaces.oc.asm.CommonMethodsBuilder;
import openperipheral.interfaces.oc.asm.ICodeGenerator;
import openperipheral.interfaces.oc.asm.Utils;
import openperipheral.interfaces.oc.asm.object.ObjectEnvironmentBase;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class ObjectCodeGenerator
implements ICodeGenerator {
    private static final Type BASE_TYPE = Type.getType(ObjectEnvironmentBase.class);
    private static final Type SUPER_CTOR_TYPE = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[0]);

    @Override
    public byte[] generate(String clsName, Class<?> targetClass, Set<Class<?>> exposedInterfaces, IndexedMethodMap methods, int methodsId) {
        ClassWriter writer = new ClassWriter(3);
        writer.visit(50, 4145, clsName, null, BASE_TYPE.getInternalName(), Utils.getInterfaces(exposedInterfaces));
        Type targetType = Type.getType(targetClass);
        CommonMethodsBuilder builder = new CommonMethodsBuilder(writer, clsName, targetType);
        builder.addTargetField();
        builder.addMethodsField();
        builder.addClassInit(methodsId);
        ObjectCodeGenerator.createConstructors(writer, clsName, targetType);
        Map<Method, Type> exposedMethods = Utils.getExposedMethods(exposedInterfaces);
        for (Map.Entry<Method, Type> e : exposedMethods.entrySet()) {
            builder.addExposedMethodBypass(e.getKey(), e.getValue());
        }
        for (int i = 0; i < methods.size(); ++i) {
            String name = methods.getMethodName(i);
            IMethodExecutor executor = methods.getMethod(i);
            builder.createScriptMethodWrapper(name, i, executor);
        }
        writer.visitEnd();
        return writer.toByteArray();
    }

    private static void createConstructors(ClassWriter writer, String clsName, Type targetType) {
        ObjectCodeGenerator.createDefaultConstructor(writer, clsName, targetType);
        ObjectCodeGenerator.createDummyConstructor(writer, clsName, targetType);
    }

    private static void visitSuperCtor(MethodVisitor init) {
        init.visitVarInsn(25, 0);
        init.visitInsn(89);
        init.visitMethodInsn(183, BASE_TYPE.getInternalName(), "<init>", SUPER_CTOR_TYPE.getDescriptor());
    }

    private static void createDefaultConstructor(ClassWriter writer, String clsName, Type targetType) {
        Type ctorType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{targetType});
        MethodVisitor init = writer.visitMethod(4097, "<init>", ctorType.getDescriptor(), null, null);
        init.visitCode();
        ObjectCodeGenerator.visitSuperCtor(init);
        init.visitVarInsn(25, 1);
        init.visitFieldInsn(181, clsName, "target", targetType.getDescriptor());
        init.visitInsn(177);
        init.visitMaxs(0, 0);
        init.visitEnd();
    }

    private static void createDummyConstructor(ClassWriter writer, String clsName, Type targetType) {
        Type ctorType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[0]);
        MethodVisitor init = writer.visitMethod(4097, "<init>", ctorType.getDescriptor(), null, null);
        init.visitCode();
        ObjectCodeGenerator.visitSuperCtor(init);
        init.visitInsn(1);
        init.visitFieldInsn(181, clsName, "target", targetType.getDescriptor());
        init.visitInsn(177);
        init.visitMaxs(0, 0);
        init.visitEnd();
    }
}

