/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import mcjty.rftools.RFTools;
import mcjty.rftools.dimension.world.GenericWorldProvider;
import net.minecraftforge.common.DimensionManager;

public class DimensionSyncPacket {
    private ByteBuf data = Unpooled.buffer();
    private byte[] dimensions;

    public void addDimension(int id) {
        this.data.writeByte(id);
    }

    public void consumePacket(ByteBuf data) {
        this.dimensions = new byte[data.readableBytes()];
        data.readBytes(this.dimensions);
    }

    public ByteBuf getData() {
        return this.data;
    }

    public void execute() {
        for (byte id : this.dimensions) {
            RFTools.log("DimensionSyncPacket: Registering id: id = " + id);
            if (DimensionManager.isDimensionRegistered((int)id)) continue;
            DimensionManager.registerProviderType((int)id, GenericWorldProvider.class, (boolean)false);
            DimensionManager.registerDimension((int)id, (int)id);
        }
    }
}

