/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.EntityLivingUtil;
import com.carpentersblocks.util.registry.BlockRegistry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Bed {
    public static final byte TYPE_NORMAL = 0;

    public static final int getType(TEBase TE) {
        return TE.getData() & 0xF;
    }

    public static void setType(TEBase TE, int type) {
        int temp = TE.getData() & 0xFFFFFFF0 | type;
        TE.setData(temp);
    }

    public static boolean isOccupied(TEBase TE) {
        return (TE.getData() & 0x10) != 0;
    }

    public static void setOccupied(TEBase TE, boolean isOccupied) {
        int temp = TE.getData() & 0xFFFFFFEF;
        if (isOccupied) {
            temp |= 0x10;
        }
        TE.setData(temp);
    }

    public static TEBase getOppositeTE(TEBase TE) {
        ForgeDirection dir = Bed.getDirection(TE);
        int x = TE.field_145851_c;
        int z = TE.field_145849_e;
        if (Bed.isHeadOfBed(TE)) {
            x = TE.field_145851_c + dir.offsetX;
            z = TE.field_145849_e + dir.offsetZ;
        } else {
            x = TE.field_145851_c - dir.offsetX;
            z = TE.field_145849_e - dir.offsetZ;
        }
        World world = TE.func_145831_w();
        if (world.func_147439_a(x, TE.field_145848_d, z).equals(BlockRegistry.blockCarpentersBed)) {
            return (TEBase)world.func_147438_o(x, TE.field_145848_d, z);
        }
        return null;
    }

    public static boolean isHeadOfBed(TEBase TE) {
        return (TE.getData() & 0x8000) != 0;
    }

    public static void setHeadOfBed(TEBase TE) {
        int temp = TE.getData() & 0xFFFF7FFF | 0x8000;
        TE.setData(temp);
    }

    public static ForgeDirection getDirection(TEBase TE) {
        int rot = (TE.getData() & 0x6000) >> 13;
        return EntityLivingUtil.getRotationFacing(rot).getOpposite();
    }

    public static void setDirection(TEBase TE, int facing) {
        int temp = TE.getData() & 0xFFFF9FFF | facing << 13;
        TE.setData(temp);
    }
}

