/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.utils.LabeledPositionedStack;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public abstract class BaseBreedingRecipeHandler
extends TemplateRecipeHandler {
    private final ISpeciesRoot speciesRoot;

    public BaseBreedingRecipeHandler(ISpeciesRoot root) {
        this.speciesRoot = root;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
            return;
        }
        if (!outputId.equals(this.getRecipeIdent())) {
            return;
        }
        for (IMutation mutation : this.speciesRoot.getMutations(false)) {
            if (mutation.isSecret() && !AddonForestry.showSecret) continue;
            this.arecipes.add(new CachedBreedingRecipe(mutation));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (!this.speciesRoot.isMember(result)) {
            return;
        }
        IIndividual resultIndividual = this.speciesRoot.getMember(result);
        if (resultIndividual == null) {
            AddonForestry.instance.logWarning("IIndividual is null searching recipe for %s", result.toString());
            return;
        }
        if (resultIndividual.getGenome() == null) {
            AddonForestry.instance.logWarning("Genome is null when searching recipe for %s", result.toString());
            return;
        }
        if (resultIndividual.getGenome().getPrimary() == null) {
            AddonForestry.instance.logWarning("Species is null when searching recipe for %s", result.toString());
            return;
        }
        IAlleleSpecies species = resultIndividual.getGenome().getPrimary();
        for (IMutation mutation : this.speciesRoot.getMutations(false)) {
            if (!mutation.getTemplate()[0].equals(species) || mutation.isSecret() && !AddonForestry.showSecret) continue;
            this.arecipes.add(new CachedBreedingRecipe(mutation));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!this.speciesRoot.isMember(ingredient)) {
            return;
        }
        IIndividual individual = this.speciesRoot.getMember(ingredient);
        if (individual == null) {
            AddonForestry.instance.logWarning("IIndividual is null searching recipe for %s", ingredient.toString());
            return;
        }
        if (individual.getGenome() == null) {
            AddonForestry.instance.logWarning("Genome is null when searching recipe for %s", ingredient.toString());
            return;
        }
        if (individual.getGenome().getPrimary() == null) {
            AddonForestry.instance.logWarning("Species is null when searching recipe for %s", ingredient.toString());
            return;
        }
        IAlleleSpecies species = individual.getGenome().getPrimary();
        for (IMutation mutation : this.speciesRoot.getMutations(false)) {
            if (!mutation.getAllele0().equals(species) && !mutation.getAllele1().equals(species) || mutation.isSecret() && !AddonForestry.showSecret) continue;
            this.arecipes.add(new CachedBreedingRecipe(mutation));
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(49, 26, 15, 15), this.getRecipeIdent(), new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(98, 26, 21, 18), this.getRecipeIdent(), new Object[0]));
    }

    public void drawExtras(int recipe) {
        CachedBreedingRecipe rec = (CachedBreedingRecipe)((Object)this.arecipes.get(recipe));
        rec.result.drawLabel();
        rec.parrent1.drawLabel();
        rec.parrent2.drawLabel();
        if (rec.requirements.size() > 0 && AddonForestry.showReqs) {
            Utils.drawCenteredString(String.format("[%.0f%%]", Float.valueOf(rec.chance)), 108, 15, 0xFF0000);
        } else {
            Utils.drawCenteredString(String.format("%.0f%%", Float.valueOf(rec.chance)), 108, 15, 0xFFFFFF);
        }
    }

    public abstract String getRecipeIdent();

    public String getGuiTexture() {
        return "neiaddons:textures/gui/breeding.png";
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        CachedBreedingRecipe rec = (CachedBreedingRecipe)((Object)this.arecipes.get(recipe));
        if (AddonForestry.showReqs && rec.requirements.size() > 0 && GuiContainerManager.shouldShowTooltip((GuiContainer)gui) && currenttip.size() == 0) {
            Point offset = gui.getRecipePosition(recipe);
            Point pos = GuiDraw.getMousePosition();
            Rectangle tiprect = new Rectangle(84, 13, 48, 12);
            Point relMouse = new Point(pos.x - gui.field_147003_i - offset.x, pos.y - gui.field_147009_r - offset.y);
            if (tiprect.contains(relMouse)) {
                currenttip.addAll(rec.requirements);
                return currenttip;
            }
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public class CachedBreedingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        LabeledPositionedStack parrent1;
        LabeledPositionedStack parrent2;
        LabeledPositionedStack result;
        public float chance;
        public Collection<String> requirements;

        public CachedBreedingRecipe(IMutation mutation) {
            super((TemplateRecipeHandler)BaseBreedingRecipeHandler.this);
            ItemStack stackParent1 = GeneticsUtils.stackFromSpecies((IAlleleSpecies)mutation.getAllele0(), GeneticsUtils.RecipePosition.Parent1);
            ItemStack stackParent2 = GeneticsUtils.stackFromSpecies((IAlleleSpecies)mutation.getAllele1(), GeneticsUtils.RecipePosition.Parent2);
            ItemStack stackResult = GeneticsUtils.stackFromSpecies((IAlleleSpecies)mutation.getTemplate()[0], GeneticsUtils.RecipePosition.Offspring);
            this.parrent1 = new LabeledPositionedStack(stackParent1, 22, 19, mutation.getAllele0().getName(), 13);
            this.parrent2 = new LabeledPositionedStack(stackParent2, 75, 19, mutation.getAllele1().getName(), 13);
            this.result = new LabeledPositionedStack(stackResult, 129, 19, mutation.getTemplate()[0].getName(), 13);
            this.chance = mutation.getBaseChance();
            this.requirements = mutation.getSpecialConditions();
            if (this.requirements == null) {
                AddonForestry.instance.logWarning("Mutation %s + %s -> %s is returning null from getSpecialConditions", mutation.getAllele0().getUID(), mutation.getAllele1().getUID(), mutation.getTemplate()[0].getUID());
                this.requirements = new ArrayList<String>();
            }
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            list.add(this.parrent1);
            list.add(this.parrent2);
            return list;
        }
    }
}

