/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world.terrain;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import mcjty.rftools.dimension.world.GenericChunkProvider;
import mcjty.rftools.dimension.world.terrain.BaseTerrainGenerator;
import mcjty.rftools.dimension.world.types.FeatureType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class IslandTerrainGenerator
implements BaseTerrainGenerator {
    private GenericChunkProvider provider;
    private double[] densities;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    private NoiseGeneratorOctaves noiseGen5;
    private double[] stoneNoise = new double[256];
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData3;
    private double[] noiseData4;
    private double[] noiseData5;
    public static final int NORMAL = 0;
    public static final int CHAOTIC = 1;
    public static final int PLATEAUS = 3;
    public static final int ISLANDS = 4;
    private final int type;
    private final double topFactor;
    private final double botFactor;
    private final int bottomOffset;

    public IslandTerrainGenerator(int type) {
        this.type = type;
        switch (type) {
            case 3: {
                this.topFactor = -1000.0;
                this.botFactor = -300.0;
                break;
            }
            case 4: {
                this.topFactor = -600.0;
                this.botFactor = -200.0;
                break;
            }
            default: {
                this.topFactor = -3000.0;
                this.botFactor = -30.0;
            }
        }
        this.bottomOffset = type == 3 ? 14 : (type == 4 ? 11 : 8);
    }

    @Override
    public void setup(World world, GenericChunkProvider provider) {
        this.provider = provider;
        this.noiseGen1 = new NoiseGeneratorOctaves(provider.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(provider.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(provider.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(provider.rand, 10);
        this.noiseGen5 = new NoiseGeneratorOctaves(provider.rand, 16);
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.noiseGen1, this.noiseGen2, this.noiseGen3, this.noiseGen4, this.noiseGen5};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)world, (Random)provider.rand, (NoiseGenerator[])noiseGens);
        this.noiseGen1 = (NoiseGeneratorOctaves)noiseGens[0];
        this.noiseGen2 = (NoiseGeneratorOctaves)noiseGens[1];
        this.noiseGen3 = (NoiseGeneratorOctaves)noiseGens[2];
        this.noiseGen4 = (NoiseGeneratorOctaves)noiseGens[3];
        this.noiseGen5 = (NoiseGeneratorOctaves)noiseGens[4];
    }

    private double[] initializeNoiseField(double[] densities, int chunkX2, int chunkY2, int chunkZ2, int sizeX, int sizeY, int sizeZ) {
        ChunkProviderEvent.InitNoiseField event = new ChunkProviderEvent.InitNoiseField((IChunkProvider)this.provider, densities, chunkX2, chunkY2, chunkZ2, sizeX, sizeY, sizeZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.noisefield;
        }
        if (densities == null) {
            densities = new double[sizeX * sizeY * sizeZ];
        }
        boolean shallowOcean = this.provider.dimensionInformation.hasFeatureType(FeatureType.FEATURE_SHALLOW_OCEAN);
        double d0 = 684.412;
        double d1 = 684.412;
        this.noiseData4 = this.noiseGen4.func_76305_a(this.noiseData4, chunkX2, chunkZ2, sizeX, sizeZ, 1.121, 1.121, 0.5);
        this.noiseData5 = this.noiseGen5.func_76305_a(this.noiseData5, chunkX2, chunkZ2, sizeX, sizeZ, 200.0, 200.0, 0.5);
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, chunkX2, chunkY2, chunkZ2, sizeX, sizeY, sizeZ, (d0 *= 2.0) / 80.0, d1 / 160.0, d0 / 80.0);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, chunkX2, chunkY2, chunkZ2, sizeX, sizeY, sizeZ, d0, d1, d0);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, chunkX2, chunkY2, chunkZ2, sizeX, sizeY, sizeZ, d0, d1, d0);
        int k1 = 0;
        Random random = new Random(chunkX2 * 13 + chunkY2 * 157 + chunkZ2 * 13883);
        random.nextFloat();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                float f2 = 0.0f;
                switch (this.type) {
                    case 0: {
                        float xx = (float)(x + chunkX2) / 1.0f;
                        float zz = (float)(z + chunkZ2) / 1.0f;
                        f2 = 100.0f - MathHelper.func_76129_c((float)(xx * xx + zz * zz)) * 8.0f;
                        if (f2 > 80.0f) {
                            f2 = 80.0f;
                            break;
                        }
                        if (!(f2 < -100.0f)) break;
                        f2 = -100.0f;
                        break;
                    }
                    case 1: {
                        f2 = 0.0f;
                        break;
                    }
                    case 3: {
                        f2 = -5.0f;
                        break;
                    }
                    case 4: {
                        f2 = -20.0f;
                    }
                }
                for (int y = 0; y < sizeY; ++y) {
                    double d10;
                    double d5 = 0.0;
                    double d7 = this.noiseData2[k1] / 512.0;
                    double d8 = this.noiseData3[k1] / 512.0;
                    double d9 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d5 = d9 < 0.0 ? d7 : (d9 > 1.0 ? d8 : d7 + (d8 - d7) * d9);
                    d5 -= 8.0;
                    d5 += (double)f2;
                    int b0 = 2;
                    if (y > sizeY / 2 - b0) {
                        d10 = (float)(y - (sizeY / 2 - b0)) / 64.0f;
                        if (d10 < 0.0) {
                            d10 = 0.0;
                        } else if (d10 > 1.0) {
                            d10 = 1.0;
                        }
                        d5 = d5 * (1.0 - d10) + this.topFactor * d10;
                    }
                    if (y < (b0 = this.bottomOffset)) {
                        d10 = (float)(b0 - y) / ((float)b0 - 1.0f);
                        d5 = d5 * (1.0 - d10) + this.botFactor * d10;
                    }
                    densities[k1] = shallowOcean && y == 0 ? 100.0 : (shallowOcean && y == 1 ? (double)(50.0f + random.nextFloat() * 200.0f) : d5);
                    ++k1;
                }
            }
        }
        return densities;
    }

    @Override
    public void generate(int chunkX, int chunkZ, Block[] aBlock, byte[] meta) {
        Block baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain().getBlock();
        byte baseMeta = this.provider.dimensionInformation.getBaseBlockForTerrain().getMeta();
        int b0 = 2;
        int k = b0 + 1;
        int b1 = 33;
        int l = b0 + 1;
        this.densities = this.initializeNoiseField(this.densities, chunkX * b0, 0, chunkZ * b0, k, b1, l);
        for (int x2 = 0; x2 < b0; ++x2) {
            for (int z2 = 0; z2 < b0; ++z2) {
                for (int height32 = 0; height32 < 32; ++height32) {
                    double d0 = 0.25;
                    double d1 = this.densities[((x2 + 0) * l + z2 + 0) * b1 + height32 + 0];
                    double d2 = this.densities[((x2 + 0) * l + z2 + 1) * b1 + height32 + 0];
                    double d3 = this.densities[((x2 + 1) * l + z2 + 0) * b1 + height32 + 0];
                    double d4 = this.densities[((x2 + 1) * l + z2 + 1) * b1 + height32 + 0];
                    double d5 = (this.densities[((x2 + 0) * l + z2 + 0) * b1 + height32 + 1] - d1) * d0;
                    double d6 = (this.densities[((x2 + 0) * l + z2 + 1) * b1 + height32 + 1] - d2) * d0;
                    double d7 = (this.densities[((x2 + 1) * l + z2 + 0) * b1 + height32 + 1] - d3) * d0;
                    double d8 = (this.densities[((x2 + 1) * l + z2 + 1) * b1 + height32 + 1] - d4) * d0;
                    for (int h = 0; h < 8; ++h) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            int height = height32 * 4 + h;
                            int index = i2 + x2 * 8 << 12 | 0 + z2 * 8 << 8 | height;
                            int maxheight = 256;
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 8; ++k2) {
                                if (d15 > 0.0) {
                                    aBlock[index] = baseBlock;
                                    meta[index] = baseMeta;
                                } else {
                                    aBlock[index] = null;
                                }
                                index += maxheight;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    @Override
    public void replaceBlocksForBiome(int chunkX, int chunkZ, Block[] aBlock, byte[] abyte, BiomeGenBase[] biomeGenBases) {
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen4.func_76305_a(this.stoneNoise, chunkX * 16, chunkZ * 16, 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                BiomeGenBase biomegenbase = biomeGenBases[l + k * 16];
                this.genBiomeTerrain(biomegenbase, aBlock, abyte, chunkX * 16 + k, chunkZ * 16 + l, this.stoneNoise[l + k * 16]);
            }
        }
    }

    public final void genBiomeTerrain(BiomeGenBase biomegenbase, Block[] blocks, byte[] abyte, int x, int z, double noise) {
        Block baseLiquid = this.provider.dimensionInformation.getFluidForTerrain();
        Block baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain().getBlock();
        byte baseMeta = this.provider.dimensionInformation.getBaseBlockForTerrain().getMeta();
        Block block = biomegenbase.field_76752_A;
        byte blockMeta = (byte)(biomegenbase.field_150604_aj & 0xFF);
        Block block1 = biomegenbase.field_76753_B;
        byte block1Meta = (byte)(biomegenbase.field_76754_C & 0xFF);
        int k = -1;
        int l = (int)(noise / 3.0 + 3.0 + this.provider.rand.nextDouble() * 0.25);
        int cx = x & 0xF;
        int cz = z & 0xF;
        int bottomIndex = (cz * 16 + cx) * (blocks.length / 256);
        boolean shallowOcean = this.provider.dimensionInformation.hasFeatureType(FeatureType.FEATURE_SHALLOW_OCEAN);
        int shallowWaterY = 30;
        for (int height = 255; height >= 0; --height) {
            int index = bottomIndex + height;
            if (height <= 2) {
                if (shallowOcean) {
                    blocks[index] = Blocks.field_150357_h;
                    continue;
                }
                blocks[index] = Blocks.field_150350_a;
                continue;
            }
            Block currentBlock = blocks[index];
            if (currentBlock == Blocks.field_150357_h && height <= 12) {
                blocks[index] = shallowOcean ? baseLiquid : Blocks.field_150350_a;
                k = -1;
                continue;
            }
            if (currentBlock != null && currentBlock.func_149688_o() != Material.field_151579_a) {
                if (currentBlock != baseBlock) continue;
                if (k == -1) {
                    if (l <= 0) {
                        block = null;
                        blockMeta = 0;
                        block1 = baseBlock;
                        block1Meta = baseMeta;
                    } else if (height >= 59 && height <= 64) {
                        block = biomegenbase.field_76752_A;
                        blockMeta = (byte)(biomegenbase.field_150604_aj & 0xFF);
                        block1 = baseBlock;
                        block1Meta = baseMeta;
                    }
                    if (height < 63 && (block == null || block.func_149688_o() == Material.field_151579_a)) {
                        if (biomegenbase.func_150564_a(x, height, z) < 0.15f) {
                            block = Blocks.field_150432_aD;
                            blockMeta = 0;
                        } else {
                            block = baseLiquid;
                            blockMeta = 0;
                        }
                    }
                    k = l;
                    if (height >= 62) {
                        blocks[index] = block;
                        abyte[index] = blockMeta;
                        continue;
                    }
                    if (height < 56 - l) {
                        block = null;
                        block1 = baseBlock;
                        block1Meta = baseMeta;
                        blocks[index] = biomegenbase.field_76753_B;
                        abyte[index] = (byte)(biomegenbase.field_76754_C & 0x10A);
                        continue;
                    }
                    blocks[index] = block1;
                    abyte[index] = block1Meta;
                    continue;
                }
                if (k <= 0) continue;
                blocks[index] = block1;
                abyte[index] = block1Meta;
                if (--k != 0 || block1 != Blocks.field_150354_m) continue;
                k = this.provider.rand.nextInt(4) + Math.max(0, height - 63);
                block1 = Blocks.field_150322_A;
                block1Meta = 0;
                continue;
            }
            if (shallowOcean && height <= shallowWaterY) {
                blocks[index] = baseLiquid;
            }
            k = -1;
        }
    }
}

