/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.container.EmptyContainer;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.Layout;
import mcjty.gui.layout.VerticalLayout;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.PacketGetPlayers;
import mcjty.rftools.blocks.teleporter.PlayerName;
import mcjty.rftools.network.Argument;
import mcjty.rftools.network.PacketHandler;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class GuiMatterTransmitter
extends GenericGuiContainer<MatterTransmitterTileEntity> {
    public static final int MATTER_WIDTH = 200;
    public static final int MATTER_HEIGHT = 180;
    public static final String ACCESS_PRIVATE = "Private";
    public static final String ACCESS_PUBLIC = "Public";
    private EnergyBar energyBar;
    private ChoiceLabel privateSetting;
    private WidgetList allowedPlayers;
    private Button addButton;
    private Button delButton;
    private TextField nameField;
    private List<String> players = null;
    private int listDirty = 0;
    private static Set<String> fromServer_allowedPlayers = new HashSet<String>();

    public static void storeAllowedPlayersForClient(List<PlayerName> players) {
        HashSet<String> p = new HashSet<String>();
        for (PlayerName n : players) {
            p.add(n.getName());
        }
        fromServer_allowedPlayers = p;
    }

    public GuiMatterTransmitter(MatterTransmitterTileEntity transmitterTileEntity, EmptyContainer container) {
        super(transmitterTileEntity, container);
        MatterTransmitterTileEntity.setCurrentRF(transmitterTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 200;
        this.field_147000_g = 180;
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int k = (this.field_146294_l - 200) / 2;
        int l = (this.field_146295_m - 180) / 2;
        int maxEnergyStored = ((MatterTransmitterTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setFilledRectThickness(1)).setHorizontal().setDesiredHeight(12)).setMaxValue(maxEnergyStored).setShowText(true);
        MatterTransmitterTileEntity cfr_ignored_0 = (MatterTransmitterTileEntity)this.tileEntity;
        this.energyBar.setValue(MatterTransmitterTileEntity.getCurrentRF());
        TextField textField = ((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Use this name to", "identify this transmitter", "in the dialer"})).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                GuiMatterTransmitter.this.setTransmitterName(newText);
            }
        });
        textField.setText(((MatterTransmitterTileEntity)this.tileEntity).getName());
        Panel namePanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Name:"))).addChild(textField)).setDesiredHeight(16);
        this.privateSetting = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(ACCESS_PUBLIC, ACCESS_PRIVATE).setDesiredHeight(13)).setDesiredWidth(60)).setChoiceTooltip(ACCESS_PUBLIC, "Everyone can access this transmitter", "and change the dialing destination").setChoiceTooltip(ACCESS_PRIVATE, "Only people in the access list below", "can access this transmitter").addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiMatterTransmitter.this.changeAccessMode(newChoice);
            }
        });
        if (((MatterTransmitterTileEntity)this.tileEntity).isPrivateAccess()) {
            this.privateSetting.setChoice(ACCESS_PRIVATE);
        } else {
            this.privateSetting.setChoice(ACCESS_PUBLIC);
        }
        Panel privatePanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Access:"))).addChild(this.privateSetting)).setDesiredHeight(16);
        this.allowedPlayers = (WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setFilledRectThickness(1);
        Slider allowedPlayerSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(15)).setVertical().setScrollable(this.allowedPlayers);
        Panel allowedPlayersPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.allowedPlayers)).addChild(allowedPlayerSlider);
        this.nameField = new TextField(this.field_146297_k, (Gui)this);
        this.addButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Add")).setDesiredHeight(13)).setDesiredWidth(34)).setTooltips(new String[]{"Add a player to the access list"})).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiMatterTransmitter.this.addPlayer();
            }
        });
        this.delButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Del")).setDesiredHeight(13)).setDesiredWidth(34)).setTooltips(new String[]{"Remove the selected player", "from the access list"})).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiMatterTransmitter.this.delPlayer();
            }
        });
        Panel buttonPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.nameField)).addChild(this.addButton)).addChild(this.delButton)).setDesiredHeight(16);
        Object toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)((VerticalLayout)new VerticalLayout().setHorizontalMargin(6)).setVerticalMargin(6)).addChild(this.energyBar)).addChild(namePanel)).addChild(privatePanel)).addChild(allowedPlayersPanel)).addChild(buttonPanel);
        toplevel.setBounds(new Rectangle(k, l, 200, 180));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        Keyboard.enableRepeatEvents((boolean)true);
        this.listDirty = 0;
        this.requestPlayers();
        ((MatterTransmitterTileEntity)this.tileEntity).requestRfFromServer();
    }

    private void setTransmitterName(String text) {
        this.sendServerCommand("setName", new Argument("name", text));
    }

    private void changeAccessMode(String newAccess) {
        this.sendServerCommand("setAccess", new Argument("private", ACCESS_PRIVATE.equals(newAccess)));
    }

    private void addPlayer() {
        this.sendServerCommand("addPlayer", new Argument("player", this.nameField.getText()));
        this.listDirty = 0;
    }

    private void delPlayer() {
        this.sendServerCommand("delPlayer", new Argument("player", this.players.get(this.allowedPlayers.getSelected())));
        this.listDirty = 0;
    }

    private void requestPlayers() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetPlayers(((MatterTransmitterTileEntity)this.tileEntity).field_145851_c, ((MatterTransmitterTileEntity)this.tileEntity).field_145848_d, ((MatterTransmitterTileEntity)this.tileEntity).field_145849_e));
    }

    private void populatePlayers() {
        ArrayList<String> newPlayers = new ArrayList<String>(fromServer_allowedPlayers);
        Collections.sort(newPlayers);
        if (((Object)newPlayers).equals(this.players)) {
            return;
        }
        this.players = new ArrayList<String>(newPlayers);
        this.allowedPlayers.removeChildren();
        for (String player : this.players) {
            this.allowedPlayers.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText(player)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
        }
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestPlayers();
            this.listDirty = 20;
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populatePlayers();
        this.enableButtons();
        this.window.draw();
        MatterTransmitterTileEntity cfr_ignored_0 = (MatterTransmitterTileEntity)this.tileEntity;
        int currentRF = MatterTransmitterTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((MatterTransmitterTileEntity)this.tileEntity).requestRfFromServer();
    }

    private void enableButtons() {
        boolean isPrivate = ACCESS_PRIVATE.equals(this.privateSetting.getCurrentChoice());
        this.allowedPlayers.setEnabled(isPrivate);
        this.nameField.setEnabled(isPrivate);
        int isPlayerSelected = this.allowedPlayers.getSelected();
        this.delButton.setEnabled(isPrivate && isPlayerSelected != -1);
        String name = this.nameField.getText();
        this.addButton.setEnabled(isPrivate && name != null && !name.isEmpty());
    }
}

