/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui;

import java.util.List;
import mcjty.gui.widgets.Widget;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Mouse;

public class Window {
    private final Widget toplevel;
    private final GuiScreen gui;
    private Widget textFocus = null;

    public Window(GuiScreen gui, Widget toplevel) {
        this.gui = gui;
        this.toplevel = toplevel;
    }

    public Widget getToplevel() {
        return this.toplevel;
    }

    public void mouseClicked(int x, int y, int button) {
        this.textFocus = null;
        if (this.toplevel.in(x, y) && this.toplevel.isVisible()) {
            this.toplevel.mouseClick(this, x, y, button);
        }
    }

    public void handleMouseInput() {
        int x = Mouse.getEventX() * this.gui.field_146294_l / this.gui.field_146297_k.field_71443_c;
        int y = this.gui.field_146295_m - Mouse.getEventY() * this.gui.field_146295_m / this.gui.field_146297_k.field_71440_d - 1;
        int k = Mouse.getEventButton();
        if (k == -1) {
            this.mouseMovedOrUp(x, y, k);
        }
    }

    public void mouseMovedOrUp(int x, int y, int button) {
        if (button != -1) {
            this.toplevel.mouseRelease(x, y, button);
        } else {
            this.toplevel.mouseMove(x, y);
        }
    }

    public void setTextFocus(Widget focus) {
        this.textFocus = focus;
    }

    public Widget getTextFocus() {
        return this.textFocus;
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (this.textFocus != null) {
            return this.textFocus.keyTyped(this, typedChar, keyCode);
        }
        return false;
    }

    public void draw() {
        int dwheel = Mouse.getDWheel();
        if (dwheel != 0) {
            int x = Mouse.getEventX() * this.gui.field_146294_l / this.gui.field_146297_k.field_71443_c;
            int y = this.gui.field_146295_m - Mouse.getEventY() * this.gui.field_146295_m / this.gui.field_146297_k.field_71440_d - 1;
            this.toplevel.mouseWheel(dwheel, x, y);
        }
        this.toplevel.draw(this, 0, 0);
    }

    public List<String> getTooltips() {
        Widget w;
        List<String> tooltips;
        int y;
        int x = Mouse.getEventX() * this.gui.field_146294_l / this.gui.field_146297_k.field_71443_c;
        if (this.toplevel.in(x, y = this.gui.field_146295_m - Mouse.getEventY() * this.gui.field_146295_m / this.gui.field_146297_k.field_71440_d - 1) && this.toplevel.isVisible() && (tooltips = (w = this.toplevel.getWidgetAtPosition(x, y)).getTooltips()) != null) {
            return tooltips;
        }
        return null;
    }
}

