/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.base;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ILocationBound;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBound;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.TooltipHelper;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class ItemLocationBoundModular
extends ItemLocationBound
implements IModular,
IKeyBound {
    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && player != null && player.func_70093_af()) {
            boolean adjustPosHit = UtilItemModular.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0;
            this.setTarget(stack, player, x, y, z, side, hitX, hitY, hitZ, adjustPosHit, false);
        }
        return true;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (moduleStack != null && moduleStack.func_77973_b() instanceof ILocationBound) {
            NBTTagCompound tagDisplay;
            String itemName = StatCollector.func_74838_a((String)(this.func_77667_c(stack) + ".name")).trim();
            NBTTagCompound nbt = moduleStack.func_77978_p();
            String pre = EnumChatFormatting.GREEN.toString() + EnumChatFormatting.ITALIC.toString();
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
            if (nbt != null && nbt.func_150297_b("display", 10) && (tagDisplay = nbt.func_74775_l("display")).func_150297_b("Name", 8)) {
                if (itemName.length() >= 14) {
                    return EUStringUtils.getInitialsWithDots(itemName) + " " + pre + tagDisplay.func_74779_i("Name") + rst;
                }
                return itemName + " " + pre + tagDisplay.func_74779_i("Name") + rst;
            }
            NBTHelperTarget target = ((ILocationBound)moduleStack.func_77973_b()).getTarget(moduleStack);
            if (target != null) {
                if (itemName.length() >= 14) {
                    itemName = EUStringUtils.getInitialsWithDots(itemName);
                }
                String dimName = TooltipHelper.getDimensionName(target.dimension, target.dimensionName, true);
                pre = EnumChatFormatting.GREEN.toString();
                return itemName + " " + pre + dimName + rst;
            }
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        if (stack.func_77978_p() == null) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.usetoolworkstation"));
            return;
        }
        ItemStack linkCrystalStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        String preBlue = EnumChatFormatting.BLUE.toString();
        String preWhiteIta = EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        if (linkCrystalStack != null) {
            if (NBTHelperTarget.itemHasTargetTag(linkCrystalStack)) {
                super.addInformationSelective(linkCrystalStack, player, list, advancedTooltips, verbose);
            } else {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.notargetset"));
            }
            if (verbose) {
                int num = UtilItemModular.getModuleCount(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) + 1;
                String dName = linkCrystalStack.func_82837_s() ? preWhiteIta + linkCrystalStack.func_82833_r() + rst + " " : "";
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedlinkcrystal.short") + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
            }
        } else {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nolinkcrystals"));
        }
        if (verbose) {
            ItemStack capacitorStack;
            if (this.getMaxModules(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                String s = this.getModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0 ? StatCollector.func_74838_a((String)"enderutilities.tooltip.item.jailer") + ": " + EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst : StatCollector.func_74838_a((String)"enderutilities.tooltip.item.jailer") + ": " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
                list.add(s);
            }
            if ((capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) != null && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
                ((ItemEnderCapacitor)capacitorStack.func_77973_b()).func_77624_a(capacitorStack, player, list, advancedTooltips);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemLocationBoundModular.addTooltips("enderutilities.tooltips.itemlocationboundmodular", list, verbose);
        super.addTooltips(stack, list, verbose);
    }

    @Override
    public void setTarget(ItemStack stack, EntityPlayer player, boolean storeRotation) {
        UtilItemModular.setTarget(stack, player, storeRotation);
    }

    @Override
    public void setTarget(ItemStack toolStack, EntityPlayer player, int x, int y, int z, int side, double hitX, double hitY, double hitZ, boolean doHitOffset, boolean storeRotation) {
        UtilItemModular.setTarget(toolStack, player, x, y, z, side, hitX, hitY, hitZ, doHitOffset, storeRotation);
    }

    @Override
    public void changePrivacyMode(ItemStack stack, EntityPlayer player) {
        NBTHelperPlayer data = NBTHelperPlayer.getPlayerDataFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (data != null && data.isOwner(player)) {
            data.isPublic = !data.isPublic;
            data.writeToSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, ReferenceKeys.keypressContainsControl(key));
        } else {
            super.doKeyBindingAction(player, stack, key);
        }
    }

    @Override
    public int getModuleCount(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getModuleCount(stack, moduleType);
    }

    @Override
    public int getMaxModules(ItemStack stack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack stack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack toolStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 0) {
            return this.getMaxModules(toolStack, moduleType);
        }
        return 0;
    }

    @Override
    public int getMaxModuleTier(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getMaxModuleTier(stack, moduleType);
    }

    @Override
    public int getSelectedModuleTier(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getSelectedModuleTier(stack, moduleType);
    }

    @Override
    public ItemStack getSelectedModuleStack(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getSelectedModuleStack(stack, moduleType);
    }

    @Override
    public ItemStack setSelectedModuleStack(ItemStack toolStack, ItemModule.ModuleType moduleType, ItemStack moduleStack) {
        return UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
    }

    @Override
    public ItemStack changeSelectedModule(ItemStack stack, ItemModule.ModuleType moduleType, boolean reverse) {
        return UtilItemModular.changeSelectedModule(stack, moduleType, reverse);
    }

    @Override
    public List<NBTTagCompound> getAllModules(ItemStack stack) {
        return UtilItemModular.getAllModules(stack);
    }

    @Override
    public ItemStack setAllModules(ItemStack stack, List<NBTTagCompound> modules) {
        return UtilItemModular.setAllModules(stack, modules);
    }

    @Override
    public ItemStack setModule(ItemStack stack, int index, NBTTagCompound nbt) {
        return UtilItemModular.setModule(stack, index, nbt);
    }
}

