/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import openperipheral.addons.glasses.GlassesEvent;
import openperipheral.addons.glasses.GuiCapture;
import openperipheral.addons.glasses.SurfaceClient;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.addons.glasses.drawable.Drawable;
import org.lwjgl.opengl.GL11;

public class TerminalManagerClient {
    public static final TerminalManagerClient instance = new TerminalManagerClient();
    private final Table<Long, String, SurfaceClient> surfaces = HashBasedTable.create();

    private TerminalManagerClient() {
    }

    private void tryDrawSurface(long guid, String player, float partialTicks, ScaledResolution resolution) {
        SurfaceClient surface = (SurfaceClient)this.surfaces.get((Object)guid, (Object)player);
        if (surface != null) {
            GL11.glPushAttrib((int)24576);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            for (Drawable drawable : surface) {
                if (!drawable.shouldRender()) continue;
                drawable.draw(resolution, partialTicks);
            }
            GL11.glPopAttrib();
        }
    }

    private static String getSurfaceName(boolean isPrivate) {
        return isPrivate ? "PRIVATE" : "GLOBAL";
    }

    public Object createForgeBusListener() {
        return new ForgeBusListener();
    }

    public Object createFmlBusListener() {
        return new FmlBusListener();
    }

    public DrawableHitInfo findDrawableHit(long guid, ScaledResolution resolution, int x, int y) {
        DrawableHitInfo result = this.findDrawableHit(guid, resolution, x, y, false);
        if (result != null) {
            return result;
        }
        return this.findDrawableHit(guid, resolution, x, y, true);
    }

    private DrawableHitInfo findDrawableHit(long guid, ScaledResolution resolution, int x, int y, boolean isPrivate) {
        String surfaceName = TerminalManagerClient.getSurfaceName(isPrivate);
        SurfaceClient surface = (SurfaceClient)this.surfaces.get((Object)guid, (Object)surfaceName);
        if (surface == null) {
            return null;
        }
        DrawableHitInfo result = null;
        for (Drawable d : surface) {
            float scaledX = (float)d.getX(resolution);
            float scaledY = (float)d.getY(resolution);
            float dx = (float)x - scaledX;
            float dy = (float)y - scaledY;
            if (!(0.0f <= dx) || !(0.0f <= dy) || !(dx < (float)d.getWidth()) || !(dy < (float)d.getHeight()) || result != null && result.z > d.z) continue;
            result = new DrawableHitInfo(d.getId(), isPrivate, dx, dy, d.z);
        }
        return result;
    }

    public class FmlBusListener {
        @SubscribeEvent
        public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent evt) {
            TerminalManagerClient.this.surfaces.clear();
        }
    }

    public class ForgeBusListener {
        @SubscribeEvent
        public void onRenderGameOverlay(RenderGameOverlayEvent evt) {
            EntityClientPlayerMP player;
            Long guid;
            if (evt.type == RenderGameOverlayEvent.ElementType.HELMET && evt instanceof RenderGameOverlayEvent.Post && (guid = TerminalUtils.tryGetTerminalGuid((EntityPlayer)(player = Minecraft.func_71410_x().field_71439_g))) != null) {
                TerminalManagerClient.this.tryDrawSurface(guid, "GLOBAL", evt.partialTicks, evt.resolution);
                TerminalManagerClient.this.tryDrawSurface(guid, "PRIVATE", evt.partialTicks, evt.resolution);
            }
        }

        @SubscribeEvent
        public void onTerminalData(TerminalEvent.TerminalDataEvent evt) {
            String surfaceName = TerminalManagerClient.getSurfaceName(evt.isPrivate);
            SurfaceClient surface = (SurfaceClient)TerminalManagerClient.this.surfaces.get((Object)evt.terminalId, (Object)surfaceName);
            if (surface == null) {
                surface = new SurfaceClient(evt.terminalId, evt.isPrivate);
                TerminalManagerClient.this.surfaces.put((Object)evt.terminalId, (Object)surfaceName, (Object)surface);
            }
            surface.interpretCommandList((List)evt.commands);
        }

        @SubscribeEvent
        public void onTerminalClear(TerminalEvent.TerminalClearEvent evt) {
            String surfaceName = TerminalManagerClient.getSurfaceName(evt.isPrivate);
            TerminalManagerClient.this.surfaces.remove((Object)evt.terminalId, (Object)surfaceName);
        }

        @SubscribeEvent
        public void onBackgroundChange(GlassesEvent.GlassesChangeBackground evt) {
            GuiCapture capture;
            long guid;
            GuiScreen gui = FMLClientHandler.instance().getClient().field_71462_r;
            if (gui instanceof GuiCapture && (guid = (capture = (GuiCapture)gui).getGuid()) == evt.guid) {
                capture.setBackground(evt.backgroundColor);
            }
        }

        @SubscribeEvent
        public void onKeyRepeatSet(GlassesEvent.GlassesSetKeyRepeat evt) {
            GuiCapture capture;
            long guid;
            GuiScreen gui = FMLClientHandler.instance().getClient().field_71462_r;
            if (gui instanceof GuiCapture && (guid = (capture = (GuiCapture)gui).getGuid()) == evt.guid) {
                capture.setKeyRepeat(evt.repeat);
            }
        }

        @SubscribeEvent
        public void onCaptureForce(GlassesEvent.GlassesStopCaptureEvent evt) {
            long guid;
            GuiScreen gui = FMLClientHandler.instance().getClient().field_71462_r;
            if (gui instanceof GuiCapture && (guid = ((GuiCapture)gui).getGuid()) == evt.guid) {
                FMLCommonHandler.instance().showGuiScreen(null);
            }
        }
    }

    public static class DrawableHitInfo {
        public final int id;
        public final boolean isPrivate;
        public final float dx;
        public final float dy;
        public final int z;

        public DrawableHitInfo(int id, boolean isPrivate, float dx, float dy, int z) {
            this.id = id;
            this.isPrivate = isPrivate;
            this.dx = dx;
            this.dy = dy;
            this.z = z;
        }
    }
}

