/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.ArrayUtils;
import tterrag.core.IModTT;
import tterrag.core.TTCore;

public class Handlers {
    private static Set<String> packageSet = new HashSet<String>();
    private static boolean registered = false;

    public static void findPackages() {
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (!(mod.getMod() instanceof IModTT)) continue;
            Handlers.addPackage(Handlers.getEnclosingPackage(mod.getMod()));
        }
    }

    private static String getEnclosingPackage(Object obj) {
        Class<?> modClass = obj.getClass();
        while (modClass.getComponentType() != null) {
            modClass = modClass.getComponentType();
        }
        while (modClass.getEnclosingClass() != null) {
            modClass = modClass.getEnclosingClass();
        }
        String name = modClass.getName();
        int lastDot = name.lastIndexOf(46);
        return lastDot == -1 ? name : name.substring(0, lastDot);
    }

    public static void addPackage(String packageName) {
        if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new RuntimeException("This method must only be called in preinit");
        }
        TTCore.logger.info("Adding package " + packageName + " to handler search.");
        packageSet.add(packageName);
    }

    public static void register() {
        ClassPath classpath;
        if (registered) {
            throw new IllegalStateException("I warned you!");
        }
        try {
            classpath = ClassPath.from((ClassLoader)TTCore.class.getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String packageName : packageSet) {
            ImmutableSet classes = classpath.getTopLevelClassesRecursive(packageName);
            for (ClassPath.ClassInfo info : classes) {
                if (!info.getPackageName().contains("client") || FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                    try {
                        Class c = info.load();
                        Handler a = c.getAnnotation(Handler.class);
                        if (a == null) continue;
                        Handlers.registerHandler(c, a);
                    }
                    catch (Throwable t) {
                        TTCore.logger.error(String.format("[Handlers] %s threw an error on load, skipping...", info.getName()));
                        t.printStackTrace();
                    }
                    continue;
                }
                TTCore.logger.info(String.format("[Handlers] Skipping client class %s, we are on a dedicated server", info.getSimpleName()));
            }
        }
        registered = true;
    }

    private static void registerHandler(Class<?> c, Handler handler) throws InstantiationException, IllegalAccessException {
        TTCore.logger.info(String.format("[Handlers] Registering handler %s to busses: %s", c.getSimpleName(), Arrays.deepToString((Object[])handler.value())));
        Handler.HandlerType[] types = handler.value();
        Object inst = Handlers.tryInit(handler, c);
        if (ArrayUtils.contains((Object[])types, (Object)((Object)Handler.HandlerType.FORGE))) {
            MinecraftForge.EVENT_BUS.register(inst);
        }
        if (ArrayUtils.contains((Object[])types, (Object)((Object)Handler.HandlerType.FML))) {
            FMLCommonHandler.instance().bus().register(inst);
        }
    }

    private static Object tryInit(Handler annot, Class<?> c) {
        Handler.Inst pref = annot.getInstFrom();
        if (pref.matches(Handler.Inst.CONSTRUCTOR)) {
            try {
                return c.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (pref.matches(Handler.Inst.FIELD)) {
            try {
                Field inst = c.getDeclaredField("INSTANCE");
                inst.setAccessible(true);
                return inst.get(null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (pref.matches(Handler.Inst.METHOD)) {
            try {
                Method inst = c.getDeclaredMethod("instance", new Class[0]);
                inst.setAccessible(true);
                return inst.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Could not instantiate @Handler class " + c.getName() + " or access INSTANCE field or instance() method.");
    }

    private Handlers() {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Handler {
        public HandlerType[] value() default {HandlerType.FORGE, HandlerType.FML};

        public Inst getInstFrom() default Inst.AUTO;

        public static enum Inst {
            AUTO,
            CONSTRUCTOR,
            FIELD,
            METHOD;


            boolean matches(Inst other) {
                return this == AUTO || other == AUTO || other == this;
            }
        }

        public static enum HandlerType {
            FORGE,
            FML;

        }
    }
}

