/*
 * Decompiled with CFR 0.152.
 */
package openeye.storage;

import com.google.common.base.Throwables;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import openeye.storage.GsonStreamSource;
import openeye.storage.IAppendableStorage;
import openeye.storage.IDataSource;

public class GsonSessionStorage<T>
implements IAppendableStorage<T> {
    private static final DateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private final File archiveFile;
    private ZipOutputStream archiveStream;
    protected final Class<? extends T> cls;
    protected final Gson gson;
    private final String ext;
    private int counter;

    public GsonSessionStorage(File dir, String ext, Class<? extends T> cls, Gson gson) {
        this.ext = ext;
        this.gson = gson;
        this.cls = cls;
        String name = GsonSessionStorage.generateId() + ".zip";
        this.archiveFile = new File(dir, name);
    }

    private static String generateId() {
        return FORMATTER.format(new Date());
    }

    @Override
    public IDataSource<T> createNew() {
        return this.createNew("data");
    }

    private ZipOutputStream archiveStream() throws IOException {
        if (this.archiveStream == null) {
            FileOutputStream stream = new FileOutputStream(this.archiveFile);
            this.archiveStream = new ZipOutputStream(stream);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        if (GsonSessionStorage.this.archiveStream != null) {
                            GsonSessionStorage.this.archiveStream.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.archiveStream;
    }

    @Override
    public IDataSource<T> createNew(String id) {
        final String fullId = String.format("%s-%04d.%s", id, this.counter++, this.ext);
        return new GsonStreamSource<T>(fullId, this.cls, this.gson){

            @Override
            public void delete() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected InputStream createInputStream() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void afterWrite(Writer writer) throws IOException {
                writer.flush();
                ZipOutputStream archiveStream = GsonSessionStorage.this.archiveStream();
                archiveStream.closeEntry();
                archiveStream.flush();
            }

            @Override
            protected OutputStream createOutputStream() {
                try {
                    ZipOutputStream stream = GsonSessionStorage.this.archiveStream();
                    stream.putNextEntry(new ZipEntry(fullId));
                    return stream;
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }

            @Override
            protected String description() {
                return String.format("%s in archive %s", fullId, GsonSessionStorage.this.archiveFile);
            }

            @Override
            protected boolean sourceExists() {
                return false;
            }
        };
    }
}

