/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mc1710.util.MineTweakerPlatformUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryGrindable;
import powercrystals.minefactoryreloaded.api.MobDrop;
import stanhebben.zenscript.annotations.ZenClass;

@ZenClass(value="mods.mfr.Grinder")
@ModOnly(value={"MineFactoryReloaded"})
public class Grinder {
    public static void addBlacklist(String entityClassName) {
        Class<? extends EntityLivingBase> entityClass = MineTweakerPlatformUtils.getLivingEntityClass(entityClassName);
        MineTweakerAPI.apply(new AddBlacklistAction(entityClass));
    }

    public static void removeBlacklist(String entityClassName) {
        Class<? extends EntityLivingBase> entityClass = MineTweakerPlatformUtils.getLivingEntityClass(entityClassName);
        if (!MFRRegistry.getGrinderBlacklist().contains(entityClass)) {
            MineTweakerAPI.logWarning(entityClassName + " is not blacklisted in the MFR Grinder");
        } else {
            MineTweakerAPI.apply(new RemoveBlacklistAction(entityClass));
        }
    }

    public static void addGrindable(String entityClassName) {
        Grinder.addGrindable(entityClassName, new WeightedItemStack[0]);
    }

    public static void addGrindable(String entityClassName, WeightedItemStack possibleDrop) {
        Grinder.addGrindable(entityClassName, new WeightedItemStack[]{possibleDrop});
    }

    public static void addGrindable(String entityClassName, WeightedItemStack[] possibleDrops) {
        Class<? extends EntityLivingBase> entityClass = MineTweakerPlatformUtils.getLivingEntityClass(entityClassName);
        MineTweakerAPI.apply(new AddGrindableAction(entityClass, possibleDrops));
    }

    public static void removeGrindable(String entityClassName) {
        Class<? extends EntityLivingBase> entityClass = MineTweakerPlatformUtils.getLivingEntityClass(entityClassName);
        if (!MFRRegistry.getGrindables().containsKey(entityClass)) {
            MineTweakerAPI.logError("No such grindable entity: " + entityClassName);
        } else {
            MineTweakerAPI.apply(new RemoveGrindableAction(entityClass));
        }
    }

    private static class RemoveGrindableAction
    implements IUndoableAction {
        private final Class<? extends EntityLivingBase> entityClass;
        private final IFactoryGrindable grindable;

        public RemoveGrindableAction(Class<? extends EntityLivingBase> entityClass) {
            this.entityClass = entityClass;
            this.grindable = (IFactoryGrindable)MFRRegistry.getGrindables().get(entityClass);
        }

        @Override
        public void apply() {
            MFRRegistry.getGrindables().remove(this.entityClass);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.registerGrindable((IFactoryGrindable)this.grindable);
        }

        @Override
        public String describe() {
            return "Removing grindable " + this.entityClass.getName();
        }

        @Override
        public String describeUndo() {
            return "Restoring grindable " + this.entityClass.getName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddGrindableAction
    implements IUndoableAction {
        private final SimpleGrindable grindable;

        public AddGrindableAction(Class<? extends EntityLivingBase> entityClass, WeightedItemStack[] possibleDrops) {
            this.grindable = new SimpleGrindable(entityClass, possibleDrops);
        }

        @Override
        public void apply() {
            MFRRegistry.registerGrindable((IFactoryGrindable)this.grindable);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getGrindables().remove(this.grindable.entityClass);
        }

        @Override
        public String describe() {
            return "Adding MFR Grindable " + this.grindable.entityClass.getName();
        }

        @Override
        public String describeUndo() {
            return "Removing MFR Grindable " + this.grindable.entityClass.getName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveBlacklistAction
    implements IUndoableAction {
        private final Class<? extends EntityLivingBase> entityClass;

        public RemoveBlacklistAction(Class<? extends EntityLivingBase> entityClass) {
            this.entityClass = entityClass;
        }

        @Override
        public void apply() {
            MFRRegistry.getGrinderBlacklist().remove(this.entityClass);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.registerGrinderBlacklist(this.entityClass);
        }

        @Override
        public String describe() {
            return "Removing " + this.entityClass + " from the MFR Grinder blacklist";
        }

        @Override
        public String describeUndo() {
            return "Restoring " + this.entityClass + " to the MFR Grinder blacklist";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddBlacklistAction
    implements IUndoableAction {
        private final Class<? extends EntityLivingBase> entityClass;

        public AddBlacklistAction(Class<? extends EntityLivingBase> entityClass) {
            this.entityClass = entityClass;
        }

        @Override
        public void apply() {
            MFRRegistry.registerGrinderBlacklist(this.entityClass);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getGrinderBlacklist().remove(this.entityClass);
        }

        @Override
        public String describe() {
            return "Adding " + this.entityClass.getName() + " to the MFR Grinder blacklist";
        }

        @Override
        public String describeUndo() {
            return "Removing " + this.entityClass.getName() + " from the MFR Grinder blacklist";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class SimpleGrindable
    implements IFactoryGrindable {
        private final Class<? extends EntityLivingBase> entityClass;
        private final WeightedItemStack[] drops;

        public SimpleGrindable(Class<? extends EntityLivingBase> entityClass, WeightedItemStack[] drops) {
            this.entityClass = entityClass;
            this.drops = drops;
        }

        public Class<? extends EntityLivingBase> getGrindableEntity() {
            return this.entityClass;
        }

        public List<MobDrop> grind(World world, EntityLivingBase entity, Random random) {
            ArrayList<MobDrop> dropList = new ArrayList<MobDrop>();
            for (IItemStack itemStack : WeightedItemStack.pickRandomDrops(random, this.drops)) {
                dropList.add(new MobDrop(1, MineTweakerMC.getItemStack(itemStack)));
            }
            return dropList;
        }

        public boolean processEntity(EntityLivingBase entity) {
            entity.func_70097_a(DamageSource.field_76377_j, entity.func_110138_aP() * 20.0f);
            return entity.field_70128_L;
        }
    }
}

