/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cofh.api.inventory.IInventoryConnection;
import cofh.api.tileentity.IPortableData;
import cofh.asm.relauncher.Strippable;
import cofh.lib.util.position.IRotateableTile;
import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MineFactoryReloadedClient;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.IHarvestAreaContainer;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.net.Packets;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityBase;

@Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public abstract class TileEntityFactory
extends TileEntityBase
implements IRotateableTile,
IInventoryConnection,
IPortableData,
IHarvestAreaContainer,
IPipeConnection {
    private static final int[][] _textureSelection = new int[][]{{0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 3, 2, 5, 4}, {0, 1, 5, 4, 2, 3}, {0, 1, 4, 5, 3, 2}};
    private ForgeDirection _forwardDirection;
    private boolean _canRotate = false;
    private boolean _manageFluids = false;
    private boolean _manageSolids = false;
    private boolean _isActive = false;
    private boolean _prevActive;
    protected byte _activeSyncTimeout = (byte)101;
    private long _lastActive = -100L;
    private int _lastUpgrade = 0;
    protected int _rednetState;
    protected HarvestAreaManager<TileEntityFactory> _areaManager;
    protected Machine _machine;
    protected String _owner = "";

    protected TileEntityFactory(Machine machine) {
        this._machine = machine;
        this._forwardDirection = ForgeDirection.NORTH;
    }

    public void cofh_validate() {
        this.onRotate();
        if (this.field_145850_b.field_72995_K && this.hasHAM()) {
            MineFactoryReloadedClient.addTileToAreaList(this);
        }
    }

    public void onChunkUnload() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.hasHAM()) {
            MineFactoryReloadedClient.removeTileFromAreaList(this);
        }
        super.onChunkUnload();
    }

    protected static void createEntityHAM(TileEntityFactory tileEntityFactory) {
        TileEntityFactory.createHAM(tileEntityFactory, 2, 2, 1, 1.0f, false);
    }

    protected static void createHAM(TileEntityFactory tileEntityFactory, int n) {
        TileEntityFactory.createHAM(tileEntityFactory, n, 0, 0, 1.0f, true);
    }

    protected static void createHAM(TileEntityFactory tileEntityFactory, int n, int n2, int n3, boolean bl) {
        TileEntityFactory.createHAM(tileEntityFactory, n, n2, n3, 1.0f, bl);
    }

    protected static void createHAM(TileEntityFactory tileEntityFactory, int n, int n2, int n3, float f, boolean bl) {
        tileEntityFactory._areaManager = new FactoryAreaManager(tileEntityFactory, n, n2, n3, f, bl);
    }

    @Override
    public boolean hasHAM() {
        return this.getHAM() != null;
    }

    public HarvestAreaManager<TileEntityFactory> getHAM() {
        return this._areaManager;
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public ForgeDirection getDirectionFacing() {
        return this._forwardDirection;
    }

    public boolean canRotate() {
        return this._canRotate;
    }

    public boolean canRotate(ForgeDirection forgeDirection) {
        return this._canRotate;
    }

    protected void setCanRotate(boolean bl) {
        this._canRotate = bl;
    }

    public void rotate(ForgeDirection forgeDirection) {
        if (this.canRotate()) {
            this.rotate(false);
        }
    }

    public void rotate(boolean bl) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            switch ((bl ? this._forwardDirection.getOpposite() : this._forwardDirection).ordinal()) {
                case 2: {
                    this._forwardDirection = ForgeDirection.EAST;
                    break;
                }
                case 5: {
                    this._forwardDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    this._forwardDirection = ForgeDirection.WEST;
                    break;
                }
                case 4: {
                    this._forwardDirection = ForgeDirection.NORTH;
                    break;
                }
                default: {
                    this._forwardDirection = ForgeDirection.NORTH;
                }
            }
            this.onRotate();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void rotateDirectlyTo(int n) {
        ForgeDirection forgeDirection = this._forwardDirection;
        this._forwardDirection = ForgeDirection.getOrientation((int)n);
        if (this.field_145850_b != null && forgeDirection != this._forwardDirection) {
            this.onRotate();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    protected void onRotate() {
        if (!this.func_145837_r() && this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            MFRUtil.notifyNearbyBlocks(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public int getRotatedSide(int n) {
        return _textureSelection[this._forwardDirection.ordinal()][n];
    }

    public ForgeDirection getDropDirection() {
        if (this.canRotate()) {
            return this.getDirectionFacing().getOpposite();
        }
        return ForgeDirection.UP;
    }

    public ForgeDirection[] getDropDirections() {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setIsActive(boolean bl) {
        if (this._isActive != bl & this.field_145850_b != null && !this.field_145850_b.field_72995_K && this._lastActive < this.field_145850_b.func_82737_E()) {
            this._lastActive = this.field_145850_b.func_82737_E() + (long)this._activeSyncTimeout;
            this._prevActive = this._isActive;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this._isActive = bl;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this._prevActive != this._isActive && this._lastActive < this.field_145850_b.func_82737_E()) {
            this._prevActive = this._isActive;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void setOwner(String string) {
        if (string == null) {
            string = "";
        }
        if (this._owner == null || this._owner.isEmpty()) {
            this._owner = string;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return null;
    }

    public ContainerFactoryInventory getContainer(InventoryPlayer inventoryPlayer) {
        return null;
    }

    public String getGuiBackground() {
        if (this._machine == null) {
            return null;
        }
        return this._machine.getName().toLowerCase() + ".png";
    }

    public void func_70296_d() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.hasHAM()) {
            HarvestAreaManager<TileEntityFactory> harvestAreaManager = this.getHAM();
            int n = harvestAreaManager.getUpgradeLevel();
            if (this._lastUpgrade != n) {
                Packets.sendToAllPlayersWatching(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, harvestAreaManager.getUpgradePacket());
            }
            this._lastUpgrade = n;
        }
        super.func_70296_d();
    }

    public Packet func_145844_m() {
        if (this.field_145850_b != null && this._lastActive < this.field_145850_b.func_82737_E()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74774_a("r", (byte)this._forwardDirection.ordinal());
            nBTTagCompound.func_74757_a("a", this._isActive);
            S35PacketUpdateTileEntity s35PacketUpdateTileEntity = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nBTTagCompound);
            return s35PacketUpdateTileEntity;
        }
        return null;
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity s35PacketUpdateTileEntity) {
        NBTTagCompound nBTTagCompound = s35PacketUpdateTileEntity.func_148857_g();
        switch (s35PacketUpdateTileEntity.func_148853_f()) {
            case 0: {
                this.rotateDirectlyTo(nBTTagCompound.func_74771_c("r"));
                this._prevActive = this._isActive;
                this._isActive = nBTTagCompound.func_74767_n("a");
                if (this._prevActive != this._isActive) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this._lastActive < 0L && this.hasHAM()) {
                    Packets.sendToServer((short)3, this, new Object[0]);
                }
                this._lastActive = 5L;
                break;
            }
            case 255: {
                if (!this.hasHAM()) break;
                this.getHAM().setUpgradeLevel(nBTTagCompound.func_74762_e("_upgradeLevel"));
            }
        }
    }

    public String getDataType() {
        return this._machine.getInternalName() + ".name";
    }

    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
    }

    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("rotation", this.getDirectionFacing().ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        int n = nBTTagCompound.func_74762_e("rotation");
        this.rotateDirectlyTo(n);
        this._owner = nBTTagCompound.func_74779_i("owner");
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        if (!Strings.isNullOrEmpty((String)this._owner)) {
            nBTTagCompound.func_74778_a("owner", this._owner);
        }
    }

    public void onRedNetChanged(ForgeDirection forgeDirection, int n) {
        this._rednetState = n;
    }

    public int getRedNetOutput(ForgeDirection forgeDirection) {
        return 0;
    }

    public void setManageFluids(boolean bl) {
        this._manageFluids = bl;
    }

    public boolean manageFluids() {
        return this._manageFluids;
    }

    public void setManageSolids(boolean bl) {
        this._manageSolids = bl;
    }

    public boolean manageSolids() {
        return this._manageSolids;
    }

    public IInventoryConnection.ConnectionType canConnectInventory(ForgeDirection forgeDirection) {
        return this.manageSolids() ? IInventoryConnection.ConnectionType.FORCE : IInventoryConnection.ConnectionType.DENY;
    }

    @Strippable(value={"buildcraft.api.transport.IPipeConnection"})
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        if (pipeType == IPipeTile.PipeType.FLUID) {
            return this.manageFluids() ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
        }
        if (pipeType == IPipeTile.PipeType.ITEM) {
            return this.canConnectInventory((ForgeDirection)forgeDirection).canConnect ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
        }
        if (pipeType == IPipeTile.PipeType.STRUCTURE) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    protected static class FactoryAreaManager
    extends HarvestAreaManager<TileEntityFactory> {
        public FactoryAreaManager(TileEntityFactory tileEntityFactory, int n, int n2, int n3, float f, boolean bl) {
            super(tileEntityFactory, n, n2, n3, f, bl);
        }
    }
}

