/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.version;

import appeng.services.version.Channel;
import appeng.services.version.Version;

public abstract class BaseVersion
implements Version {
    private final int revision;
    private final Channel channel;
    private final int build;

    public BaseVersion(int revision, Channel channel, int build) {
        assert (revision >= 0);
        assert (build >= 0);
        this.revision = revision;
        this.channel = channel;
        this.build = build;
    }

    @Override
    public final int revision() {
        return this.revision;
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    @Override
    public final int build() {
        return this.build;
    }

    @Override
    public String formatted() {
        return "rv" + this.revision + '-' + this.channel.name().toLowerCase() + '-' + this.build;
    }

    public final int hashCode() {
        int result = this.revision;
        result = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
        result = 31 * result + this.build;
        return result;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version that = (Version)o;
        if (this.revision != that.revision()) {
            return false;
        }
        if (this.build != that.build()) {
            return false;
        }
        return this.channel == that.channel();
    }

    public final String toString() {
        return "Version{revision=" + this.revision + ", channel=" + (Object)((Object)this.channel) + ", build=" + this.build + '}';
    }
}

