/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.recipes.RecipeHandler;
import appeng.recipes.handlers.IWebsiteSerializer;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.item.ItemStack;

public class Smelt
implements ICraftHandler,
IWebsiteSerializer {
    IIngredient in;
    IIngredient out;

    @Override
    public void setup(List<List<IIngredient>> input, List<List<IIngredient>> output) throws RecipeError {
        if (input.size() == 1 && output.size() == 1) {
            List<IIngredient> inputList = input.get(0);
            List<IIngredient> outputList = output.get(0);
            if (inputList.size() == 1 && outputList.size() == 1) {
                this.in = inputList.get(0);
                this.out = outputList.get(0);
                return;
            }
        }
        throw new RecipeError("Smelting recipe can only have a single input and output.");
    }

    @Override
    public void register() throws RegistrationError, MissingIngredientError {
        if (this.in.getItemStack().func_77973_b() == null) {
            throw new RegistrationError(this.in.toString() + ": Smelting Input is not a valid item.");
        }
        if (this.out.getItemStack().func_77973_b() == null) {
            throw new RegistrationError(this.out.toString() + ": Smelting Output is not a valid item.");
        }
        GameRegistry.addSmelting((ItemStack)this.in.getItemStack(), (ItemStack)this.out.getItemStack(), (float)0.0f);
    }

    @Override
    public String getPattern(RecipeHandler h) {
        return "smelt " + this.out.getQty() + '\n' + h.getName(this.out) + '\n' + h.getName(this.in);
    }

    @Override
    public boolean canCraft(ItemStack reqOutput) throws RegistrationError, MissingIngredientError {
        return Platform.isSameItemPrecise(this.out.getItemStack(), reqOutput);
    }
}

