/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import java.util.ArrayList;
import java.util.Random;
import mod.lucky.util.LuckyFunction;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CustomNBTTags {
    public static final NBTTagCompound protection = CustomNBTTags.getEnchantment(0, 4);
    public static final NBTTagCompound fireProtection = CustomNBTTags.getEnchantment(1, 4);
    public static final NBTTagCompound featherFalling = CustomNBTTags.getEnchantment(2, 4);
    public static final NBTTagCompound blastProtection = CustomNBTTags.getEnchantment(3, 4);
    public static final NBTTagCompound projectileProtection = CustomNBTTags.getEnchantment(4, 4);
    public static final NBTTagCompound respiration = CustomNBTTags.getEnchantment(5, 3);
    public static final NBTTagCompound aquaAffinity = CustomNBTTags.getEnchantment(6, 1);
    public static final NBTTagCompound thorns = CustomNBTTags.getEnchantment(7, 3);
    public static final NBTTagCompound sharpness = CustomNBTTags.getEnchantment(16, 5);
    public static final NBTTagCompound smite = CustomNBTTags.getEnchantment(17, 5);
    public static final NBTTagCompound baneOfArthroponds = CustomNBTTags.getEnchantment(18, 5);
    public static final NBTTagCompound knockBack = CustomNBTTags.getEnchantment(19, 2);
    public static final NBTTagCompound fireAspect = CustomNBTTags.getEnchantment(20, 2);
    public static final NBTTagCompound looting = CustomNBTTags.getEnchantment(21, 3);
    public static final NBTTagCompound efficiency = CustomNBTTags.getEnchantment(32, 5);
    public static final NBTTagCompound silkTouch = CustomNBTTags.getEnchantment(33, 1);
    public static final NBTTagCompound unbreaking = CustomNBTTags.getEnchantment(34, 3);
    public static final NBTTagCompound fortune = CustomNBTTags.getEnchantment(35, 3);
    public static final NBTTagCompound power = CustomNBTTags.getEnchantment(48, 5);
    public static final NBTTagCompound punch = CustomNBTTags.getEnchantment(49, 2);
    public static final NBTTagCompound flame = CustomNBTTags.getEnchantment(50, 1);
    public static final NBTTagCompound infinity = CustomNBTTags.getEnchantment(51, 1);
    public static final NBTTagCompound luckOfTheSea = CustomNBTTags.getEnchantment(61, 3);
    public static final NBTTagCompound lure = CustomNBTTags.getEnchantment(62, 3);
    public static final NBTTagCompound speed = CustomNBTTags.getPotionEffect(1, 3, 9600);
    public static final NBTTagCompound slowness = CustomNBTTags.getPotionEffect(2, 3, 9600);
    public static final NBTTagCompound haste = CustomNBTTags.getPotionEffect(3, 3, 9600);
    public static final NBTTagCompound miningFatigue = CustomNBTTags.getPotionEffect(4, 3, 9600);
    public static final NBTTagCompound strength = CustomNBTTags.getPotionEffect(5, 3, 9600);
    public static final NBTTagCompound instantHealth = CustomNBTTags.getPotionEffect(6, 3, 0);
    public static final NBTTagCompound instantDamage = CustomNBTTags.getPotionEffect(7, 3, 0);
    public static final NBTTagCompound jumpBoost = CustomNBTTags.getPotionEffect(8, 3, 9600);
    public static final NBTTagCompound nausea = CustomNBTTags.getPotionEffect(9, 0, 9600);
    public static final NBTTagCompound regeneration = CustomNBTTags.getPotionEffect(10, 3, 9600);
    public static final NBTTagCompound resistance = CustomNBTTags.getPotionEffect(11, 3, 9600);
    public static final NBTTagCompound fireResistance = CustomNBTTags.getPotionEffect(12, 0, 9600);
    public static final NBTTagCompound waterBreathing = CustomNBTTags.getPotionEffect(13, 0, 9600);
    public static final NBTTagCompound invisibility = CustomNBTTags.getPotionEffect(14, 0, 9600);
    public static final NBTTagCompound blindness = CustomNBTTags.getPotionEffect(15, 0, 9600);
    public static final NBTTagCompound nightVision = CustomNBTTags.getPotionEffect(16, 0, 9600);
    public static final NBTTagCompound hunger = CustomNBTTags.getPotionEffect(17, 3, 9600);
    public static final NBTTagCompound weakness = CustomNBTTags.getPotionEffect(18, 3, 9600);
    public static final NBTTagCompound poison = CustomNBTTags.getPotionEffect(19, 3, 9600);
    public static final NBTTagCompound wither = CustomNBTTags.getPotionEffect(20, 3, 9600);
    public static final NBTTagCompound healthBoost = CustomNBTTags.getPotionEffect(21, 3, 9600);
    public static final NBTTagCompound absorbtion = CustomNBTTags.getPotionEffect(22, 3, 9600);
    public static final NBTTagCompound saturation = CustomNBTTags.getPotionEffect(23, 3, 9600);
    public static Random random = new Random();

    public static NBTTagCompound getEnchantment(int id, int maxLevel) {
        NBTTagCompound nbttag = new NBTTagCompound();
        nbttag.func_74777_a("id", (short)id);
        nbttag.func_74777_a("lvl", (short)maxLevel);
        return nbttag;
    }

    public static NBTTagCompound getPotionEffect(int id, int amplifier, int duration) {
        NBTTagCompound nbttag = new NBTTagCompound();
        nbttag.func_74774_a("Id", (byte)id);
        nbttag.func_74774_a("Amplifier", (byte)amplifier);
        nbttag.func_74768_a("Duration", duration);
        return nbttag;
    }

    public static ArrayList<NBTTagCompound> getRandomList(int minAmount, int maxAmount, NBTTagCompound ... elements) {
        int amountToRemove = elements.length - (random.nextInt(maxAmount + 1 - minAmount) + minAmount);
        ArrayList<NBTTagCompound> chosenElementList = new ArrayList<NBTTagCompound>(elements.length);
        for (NBTTagCompound element : elements) {
            chosenElementList.add((NBTTagCompound)element.func_74737_b());
        }
        for (int a = 0; a < amountToRemove; ++a) {
            int index = random.nextInt(chosenElementList.size());
            chosenElementList.remove(index);
        }
        return chosenElementList;
    }

    public static NBTTagList getRandomEnchantmentList(int minAmount, int maxAmount, NBTTagCompound ... enchantments) {
        ArrayList<NBTTagCompound> chosenEnchantments = CustomNBTTags.getRandomList(minAmount, maxAmount, enchantments);
        NBTTagList nbttaglist = new NBTTagList();
        for (NBTTagCompound enchantment : chosenEnchantments) {
            enchantment.func_74777_a("lvl", (short)(random.nextInt(enchantment.func_74765_d("lvl")) + 1));
            nbttaglist.func_74742_a((NBTBase)enchantment);
        }
        return nbttaglist;
    }

    public static NBTTagList getRandomPotionEffectList(int minAmount, int maxAmount, NBTTagCompound ... potionEffects) {
        ArrayList<NBTTagCompound> chosenPotionEffects = CustomNBTTags.getRandomList(minAmount, maxAmount, potionEffects);
        NBTTagList nbttaglist = new NBTTagList();
        for (NBTTagCompound potionEffect : chosenPotionEffects) {
            potionEffect.func_74774_a("Amplifier", (byte)random.nextInt(potionEffect.func_74771_c("Amplifier") + 1));
            int minDuration = (int)((float)potionEffect.func_74762_e("Duration") / 3.0f);
            potionEffect.func_74768_a("Duration", random.nextInt(potionEffect.func_74762_e("Duration") + 1 - minDuration) + minDuration);
            nbttaglist.func_74742_a((NBTBase)potionEffect);
        }
        return nbttaglist;
    }

    public static NBTBase getNBTTagFromString(String name) {
        if (name.equals("#luckySwordEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, sharpness, smite, baneOfArthroponds, knockBack, fireAspect, looting, unbreaking);
        }
        if (name.equals("#luckyAxeEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, sharpness, smite, baneOfArthroponds, efficiency, unbreaking, fortune);
        }
        if (name.equals("#luckyToolEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(2, 3, efficiency, unbreaking, fortune);
        }
        if (name.equals("#luckyHelmetEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, respiration, aquaAffinity, unbreaking);
        }
        if (name.equals("#luckyChestplateEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyLeggingsEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyBootsEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(4, 6, protection, fireProtection, featherFalling, blastProtection, projectileProtection, thorns, unbreaking);
        }
        if (name.equals("#luckyBowEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(3, 5, unbreaking, power, punch, flame, infinity);
        }
        if (name.equals("#luckyFishingRodEnchantments")) {
            return CustomNBTTags.getRandomEnchantmentList(2, 3, unbreaking, luckOfTheSea, lure);
        }
        if (name.equals("#randomEnchantment")) {
            return CustomNBTTags.getRandomEnchantmentList(1, 1, protection, fireProtection, featherFalling, blastProtection, projectileProtection, thorns, sharpness, smite, baneOfArthroponds, knockBack, fireAspect, looting, efficiency, silkTouch, unbreaking, fortune, power, punch, flame, infinity, luckOfTheSea, lure);
        }
        if (name.equals("#luckyPotionEffects")) {
            return CustomNBTTags.getRandomPotionEffectList(7, 10, speed, haste, strength, instantHealth, jumpBoost, regeneration, resistance, fireResistance, waterBreathing, invisibility, nightVision, healthBoost, absorbtion, saturation);
        }
        if (name.equals("#unluckyPotionEffects")) {
            return CustomNBTTags.getRandomPotionEffectList(5, 7, slowness, miningFatigue, instantDamage, nausea, blindness, hunger, weakness, poison, wither);
        }
        if (name.equals("#randomFireworkRocket")) {
            EntityFireworkRocket firework = new EntityFireworkRocket(null, 0.0, 0.0, 0.0, LuckyFunction.getRandomFireworkRocket());
            NBTTagCompound fireworkTag = new NBTTagCompound();
            firework.func_70014_b(fireworkTag);
            return fireworkTag;
        }
        return null;
    }
}

