/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item;

import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.config.Config;
import crazypants.util.BlockCoord;
import crazypants.util.InventoryWrapper;
import crazypants.util.ItemUtil;
import crazypants.util.RoundRobinIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class NetworkedInventory {
    private ISidedInventory inv;
    IItemConduit con;
    ForgeDirection conDir;
    BlockCoord location;
    int inventorySide;
    List<Target> sendPriority = new ArrayList<Target>();
    RoundRobinIterator<Target> rrIter = new RoundRobinIterator<Target>(this.sendPriority);
    private int extractFromSlot = -1;
    int tickDeficit;
    boolean recheckInv = false;
    boolean ticHack = false;
    World world;
    ItemConduitNetwork network;

    NetworkedInventory(ItemConduitNetwork network, IInventory inv, IItemConduit con, ForgeDirection conDir, BlockCoord location) {
        this.network = network;
        this.inventorySide = conDir.getOpposite().ordinal();
        this.con = con;
        this.conDir = conDir;
        this.location = location;
        this.world = con.getBundle().getWorld();
        TileEntity te = this.world.func_147438_o(location.x, location.y, location.z);
        if (te.getClass().getName().equals("tconstruct.tools.logic.CraftingStationLogic")) {
            this.ticHack = true;
        } else if (te.getClass().getName().contains("cpw.mods.ironchest")) {
            this.recheckInv = true;
        } else if (te instanceof TileEntityChest) {
            this.recheckInv = true;
        }
        this.updateInventory();
    }

    public boolean hasTarget(IItemConduit conduit, ForgeDirection dir) {
        for (Target t : this.sendPriority) {
            if (t.inv.con != conduit || t.inv.conDir != dir) continue;
            return true;
        }
        return false;
    }

    boolean canExtract() {
        ConnectionMode mode = this.con.getConnectionMode(this.conDir);
        return mode == ConnectionMode.INPUT || mode == ConnectionMode.IN_OUT;
    }

    boolean canInsert() {
        ConnectionMode mode = this.con.getConnectionMode(this.conDir);
        return mode == ConnectionMode.OUTPUT || mode == ConnectionMode.IN_OUT;
    }

    boolean isSticky() {
        return this.con.getOutputFilter(this.conDir) != null && this.con.getOutputFilter(this.conDir).isValid() && this.con.getOutputFilter(this.conDir).isSticky();
    }

    int getPriority() {
        return this.con.getOutputPriority(this.conDir);
    }

    public void onTick(long tick) {
        if (this.tickDeficit <= 0 && this.canExtract() && this.con.isExtractionRedstoneConditionMet(this.conDir)) {
            this.transferItems();
        }
        --this.tickDeficit;
        if (this.tickDeficit < -1) {
            this.tickDeficit = 20;
        }
    }

    private boolean canExtractThisTick(long tick) {
        return this.con.isExtractionRedstoneConditionMet(this.conDir);
    }

    private int nextSlot(int numSlots) {
        ++this.extractFromSlot;
        if (this.extractFromSlot >= numSlots || this.extractFromSlot < 0) {
            this.extractFromSlot = 0;
        }
        return this.extractFromSlot;
    }

    private void setNextStartingSlot(int slot) {
        this.extractFromSlot = slot;
        --this.extractFromSlot;
    }

    private boolean transferItems() {
        int[] slotIndices;
        if (this.recheckInv) {
            this.updateInventory();
        }
        if ((slotIndices = this.getInventory().func_94128_d(this.inventorySide)) == null) {
            return false;
        }
        int numSlots = slotIndices.length;
        ItemStack extractItem = null;
        int maxExtracted = this.con.getMaximumExtracted(this.conDir);
        int slot = -1;
        int slotChecksPerTick = Math.min(numSlots, ItemConduitNetwork.MAX_SLOT_CHECK_PER_TICK);
        for (int i = 0; i < slotChecksPerTick; ++i) {
            int index = this.nextSlot(numSlots);
            slot = slotIndices[index];
            ItemStack item = this.getInventory().func_70301_a(slot);
            if (!this.canExtractItem(item)) continue;
            extractItem = item.func_77946_l();
            if (!this.getInventory().func_102008_b(slot, extractItem, this.inventorySide) || !this.doTransfer(extractItem, slot, maxExtracted)) continue;
            this.setNextStartingSlot(slot);
            return true;
        }
        return false;
    }

    private boolean canExtractItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        IItemFilter filter = this.con.getInputFilter(this.conDir);
        if (filter == null) {
            return true;
        }
        return filter.doesItemPassFilter(this, itemStack);
    }

    private boolean doTransfer(ItemStack extractedItem, int slot, int maxExtract) {
        if (extractedItem == null || extractedItem.func_77973_b() == null) {
            return false;
        }
        ItemStack toExtract = extractedItem.func_77946_l();
        toExtract.field_77994_a = Math.min(maxExtract, toExtract.field_77994_a);
        int numInserted = this.insertIntoTargets(toExtract);
        if (numInserted <= 0) {
            return false;
        }
        ItemStack curStack = this.getInventory().func_70301_a(slot);
        if (curStack != null) {
            if (this.ticHack) {
                this.getInventory().func_70298_a(slot, numInserted);
                this.getInventory().func_70296_d();
            } else {
                curStack = curStack.func_77946_l();
                curStack.field_77994_a -= numInserted;
                if (curStack.field_77994_a > 0) {
                    this.getInventory().func_70299_a(slot, curStack);
                    this.getInventory().func_70296_d();
                } else {
                    this.getInventory().func_70299_a(slot, null);
                    this.getInventory().func_70296_d();
                }
            }
        }
        this.con.itemsExtracted(numInserted, slot);
        this.tickDeficit = Math.round((float)numInserted * this.con.getTickTimePerItem(this.conDir));
        return true;
    }

    int insertIntoTargets(ItemStack toExtract) {
        int totalToInsert;
        if (toExtract == null) {
            return 0;
        }
        int leftToInsert = totalToInsert = toExtract.field_77994_a;
        boolean matchedStickyInput = false;
        Iterable<Target> targets = this.getTargetIterator();
        for (Target target : targets) {
            int inserted;
            if (target.stickyInput && !matchedStickyInput) {
                IItemFilter of = target.inv.con.getOutputFilter(target.inv.conDir);
                boolean bl = matchedStickyInput = of != null && of.isValid() && of.doesItemPassFilter(this, toExtract);
            }
            if (!target.stickyInput && matchedStickyInput) continue;
            if (target.inv.recheckInv) {
                target.inv.updateInventory();
            }
            if ((inserted = target.inv.insertItem(toExtract)) > 0) {
                toExtract.field_77994_a -= inserted;
                leftToInsert -= inserted;
            }
            if (leftToInsert > 0) continue;
            return totalToInsert;
        }
        return totalToInsert - leftToInsert;
    }

    private Iterable<Target> getTargetIterator() {
        if (this.con.isRoundRobinEnabled(this.conDir)) {
            return this.rrIter;
        }
        return this.sendPriority;
    }

    public final void updateInventory() {
        TileEntity te = this.world.func_147438_o(this.location.x, this.location.y, this.location.z);
        if (te instanceof ISidedInventory) {
            this.inv = (ISidedInventory)te;
        } else if (te instanceof IInventory) {
            this.inv = new InventoryWrapper((IInventory)te);
        }
    }

    private int insertItem(ItemStack item) {
        if (!this.canInsert() || item == null) {
            return 0;
        }
        IItemFilter filter = this.con.getOutputFilter(this.conDir);
        if (filter != null && !filter.doesItemPassFilter(this, item)) {
            return 0;
        }
        return ItemUtil.doInsertItem(this.getInventory(), item, ForgeDirection.values()[this.inventorySide]);
    }

    void updateInsertOrder() {
        this.sendPriority.clear();
        if (!this.canExtract()) {
            return;
        }
        ArrayList<Target> result = new ArrayList<Target>();
        for (NetworkedInventory other : this.network.inventories) {
            if (!this.con.isSelfFeedEnabled(this.conDir) && other == this || !other.canInsert() || this.con.getInputColor(this.conDir) != other.con.getOutputColor(other.conDir)) continue;
            if (Config.itemConduitUsePhyscialDistance) {
                this.sendPriority.add(new Target(other, this.distanceTo(other), other.isSticky(), other.getPriority()));
                continue;
            }
            result.add(new Target(other, 9999999, other.isSticky(), other.getPriority()));
        }
        if (Config.itemConduitUsePhyscialDistance) {
            Collections.sort(this.sendPriority);
        } else if (!result.isEmpty()) {
            HashMap<BlockCoord, Integer> visited = new HashMap<BlockCoord, Integer>();
            ArrayList<BlockCoord> steps = new ArrayList<BlockCoord>();
            steps.add(this.con.getLocation());
            this.calculateDistances(result, visited, steps, 0);
            this.sendPriority.addAll(result);
            Collections.sort(this.sendPriority);
        }
    }

    private void calculateDistances(List<Target> targets, Map<BlockCoord, Integer> visited, List<BlockCoord> steps, int distance) {
        if (steps == null || steps.isEmpty()) {
            return;
        }
        ArrayList<BlockCoord> nextSteps = new ArrayList<BlockCoord>();
        for (BlockCoord bc : steps) {
            IItemConduit con = this.network.conMap.get(bc);
            if (con == null) continue;
            for (ForgeDirection dir : con.getExternalConnections()) {
                Target target = this.getTarget(targets, con, dir);
                if (target == null || target.distance <= distance) continue;
                target.distance = distance;
            }
            if (!visited.containsKey(bc)) {
                visited.put(bc, distance);
            } else {
                int prevDist = visited.get(bc);
                if (prevDist <= distance) continue;
                visited.put(bc, distance);
            }
            for (ForgeDirection dir : con.getConduitConnections()) {
                nextSteps.add(bc.getLocation(dir));
            }
        }
        this.calculateDistances(targets, visited, nextSteps, distance + 1);
    }

    private Target getTarget(List<Target> targets, IItemConduit con, ForgeDirection dir) {
        if (targets == null || con == null || con.getLocation() == null) {
            return null;
        }
        for (Target target : targets) {
            BlockCoord targetConLoc = null;
            if (target != null && target.inv != null && target.inv.con != null) {
                targetConLoc = target.inv.con.getLocation();
            }
            if (targetConLoc == null || target.inv.conDir != dir || !targetConLoc.equals(con.getLocation())) continue;
            return target;
        }
        return null;
    }

    private int distanceTo(NetworkedInventory other) {
        return this.con.getLocation().distanceSquared(other.con.getLocation());
    }

    public ISidedInventory getInventory() {
        return this.inv;
    }

    public int getInventorySide() {
        return this.inventorySide;
    }

    public void setInventorySide(int inventorySide) {
        this.inventorySide = inventorySide;
    }

    static class Target
    implements Comparable<Target> {
        NetworkedInventory inv;
        int distance;
        boolean stickyInput;
        int priority;

        Target(NetworkedInventory inv, int distance, boolean stickyInput, int priority) {
            this.inv = inv;
            this.distance = distance;
            this.stickyInput = stickyInput;
            this.priority = priority;
        }

        @Override
        public int compareTo(Target o) {
            if (this.stickyInput && !o.stickyInput) {
                return -1;
            }
            if (!this.stickyInput && o.stickyInput) {
                return 1;
            }
            if (this.priority != o.priority) {
                return ItemConduitNetwork.compare(o.priority, this.priority);
            }
            return ItemConduitNetwork.compare(this.distance, o.distance);
        }
    }
}

