/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter.inbound;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import openperipheral.api.converter.IConverter;
import openperipheral.api.converter.IGenericInboundTypeConverter;

public class ConverterArrayInbound
implements IGenericInboundTypeConverter {
    @Override
    public Object toJava(IConverter registry, Object o, Type required) {
        TypeToken type;
        if (o instanceof Map && (type = TypeToken.of((Type)required)).isArray()) {
            int index;
            Map m = (Map)o;
            TypeToken component = type.getComponentType();
            Class rawComponent = component.getRawType();
            Type genericComponent = component.getType();
            if (m.isEmpty()) {
                return Array.newInstance(rawComponent, 0);
            }
            int indexMin = Integer.MAX_VALUE;
            int indexMax = Integer.MIN_VALUE;
            HashMap tmp = Maps.newHashMap();
            for (Map.Entry e : m.entrySet()) {
                Object k = e.getKey();
                if (!(k instanceof Number)) {
                    return null;
                }
                index = ((Number)k).intValue();
                if (index < indexMin) {
                    indexMin = index;
                }
                if (index > indexMax) {
                    indexMax = index;
                }
                tmp.put(index, e.getValue());
            }
            int size = indexMax - indexMin + 1;
            if (indexMin != 0 && indexMin != 1) {
                return null;
            }
            Object result = Array.newInstance(rawComponent, size);
            int i = 0;
            index = indexMin;
            while (i < size) {
                Object in = tmp.get(index);
                if (in != null) {
                    Object out = registry.toJava(in, genericComponent);
                    Array.set(result, i, out);
                }
                ++i;
                ++index;
            }
            return result;
        }
        return null;
    }
}

