/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;

public abstract class FieldsSelector {
    private static final Comparator<Field> FIELD_NAME_COMPARATOR = new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final Map<Class<?>, Collection<Field>> syncedFields = Maps.newIdentityHashMap();

    protected abstract boolean shouldInclude(Field var1);

    protected abstract Field[] listFields(Class<?> var1);

    private Collection<Field> scanForFields(Class<?> cls) {
        TreeSet fields = Sets.newTreeSet(FIELD_NAME_COMPARATOR);
        for (Field field : this.listFields(cls)) {
            if (!this.shouldInclude(field)) continue;
            fields.add(field);
            field.setAccessible(true);
        }
        return ImmutableList.copyOf((Collection)fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Field> getFields(Class<?> cls) {
        Collection<Field> result;
        Map<Class<?>, Collection<Field>> map = this.syncedFields;
        synchronized (map) {
            result = this.syncedFields.get(cls);
        }
        if (result == null) {
            result = this.scanForFields(cls);
            map = this.syncedFields;
            synchronized (map) {
                this.syncedFields.put(cls, result);
            }
        }
        return result;
    }
}

