/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable.cls;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import openmods.serializable.IObjectSerializer;
import openmods.serializable.cls.ComposedSerializer;
import openmods.serializable.cls.SerializableField;
import openmods.serializable.cls.Serialize;
import openmods.utils.CachedFactory;
import openmods.utils.FieldsSelector;

public class ClassSerializer<T>
extends CachedFactory<Class<? extends T>, IObjectSerializer<T>>
implements IObjectSerializer<T> {
    private final FieldsSelector SELECTOR = new FieldsSelector(){

        @Override
        protected boolean shouldInclude(Field field) {
            return field.isAnnotationPresent(Serialize.class);
        }

        @Override
        protected Field[] listFields(Class<?> cls) {
            return cls.getFields();
        }
    };

    public static <T> IObjectSerializer<T> createFieldsSerializer(Iterable<Field> fields) {
        ArrayList result = Lists.newArrayList();
        for (Field f : fields) {
            result.add(new SerializableField(f));
        }
        return new ComposedSerializer(result);
    }

    @Override
    protected IObjectSerializer<T> create(Class<? extends T> key) {
        Collection<Field> fields = this.SELECTOR.getFields(key);
        return ClassSerializer.createFieldsSerializer(fields);
    }

    public IObjectSerializer<T> getSerializer(T object) {
        return (IObjectSerializer)this.getOrCreate(object.getClass());
    }

    @Override
    public void readFromStream(T object, DataInput input) throws IOException {
        this.getSerializer(object).readFromStream(object, input);
    }

    @Override
    public void writeToStream(T object, DataOutput output) throws IOException {
        this.getSerializer(object).writeToStream(object, output);
    }
}

