/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.item;

import cofh.api.energy.IEnergyContainerItem;
import io.endertech.item.ItemETBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemETEnergyContainer
extends ItemETBase
implements IEnergyContainerItem {
    private int capacity;
    private int maxReceive;
    private int maxExtract;

    public ItemETEnergyContainer() {
    }

    public ItemETEnergyContainer(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.func_77656_e(1 + this.capacity);
    }

    public static ItemStack setDefaultTag(ItemStack container, int energy) {
        container.func_77982_d(new NBTTagCompound());
        container.field_77990_d.func_74768_a("Energy", energy);
        return container;
    }

    public ItemETEnergyContainer setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(this.getMaxReceiveRate(container), maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy") || this.getMaxExtractRate(container) == 0) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.getMaxExtractRate(container), maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public void setEnergyStored(ItemStack container, int energy) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        container.field_77990_d.func_74768_a("Energy", energy);
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    @Override
    public int getMaxEnergyStored(ItemStack stack) {
        return this.capacity;
    }

    public int getMaxReceiveRate(ItemStack stack) {
        return this.maxReceive;
    }

    public int getMaxExtractRate(ItemStack stack) {
        return this.maxExtract;
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return 1 + this.getMaxEnergyStored(stack);
        }
        return 1 + this.getMaxEnergyStored(stack) - this.getEnergyStored(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return 1 + this.getMaxEnergyStored(stack);
    }
}

