/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.client.effects.Particles;
import fi.dy.masa.enderutilities.creativetab.CreativeTab;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.item.part.ItemLinkCrystal;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.reference.ReferenceMaterial;
import fi.dy.masa.enderutilities.reference.ReferenceNames;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;

public class ItemEnderTool
extends ItemTool
implements IKeyBound,
IModular {
    public static final int ENDER_CHARGE_COST = 50;
    public float field_77864_a;
    public float field_77865_bY;
    private final Item.ToolMaterial material = ReferenceMaterial.Tool.ENDER_ALLOY_ADVANCED;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconEmpty;
    @SideOnly(value=Side.CLIENT)
    String[] parts;

    public ItemEnderTool() {
        super(2.0f, ReferenceMaterial.Tool.ENDER_ALLOY_ADVANCED, (Set)Sets.newHashSet((Object[])new Block[]{Blocks.field_150478_aa}));
        this.func_77625_d(1);
        this.func_77656_e(this.material.func_77997_a());
        this.setNoRepair();
        this.field_77864_a = this.material.func_77998_b();
        this.field_77865_bY = 2.0f + this.material.func_78000_c();
        this.func_77637_a(CreativeTab.ENDER_UTILITIES_TAB);
        this.func_77655_b(ReferenceNames.getPrefixedName("endertool"));
        this.func_111206_d(ReferenceTextures.getItemTextureName("endertool"));
    }

    public String func_77667_c(ItemStack stack) {
        ToolType toolType = this.getToolType(stack);
        if (toolType != ToolType.INVALID) {
            return super.func_77658_a() + "." + toolType.getName();
        }
        return super.func_77658_a();
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (player != null && player.func_70093_af() && te != null && (te instanceof IInventory || te.getClass() == TileEntityEnderChest.class) && UtilItemModular.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 1) {
            UtilItemModular.setTarget(stack, player, x, y, z, side, hitX, hitY, hitZ, false, false);
        } else if (player != null) {
            int origSlot = player.field_71071_by.field_70461_c;
            int slot = origSlot >= InventoryPlayer.func_70451_h() - 1 ? 0 : origSlot + 1;
            ItemStack targetStack = player.field_71071_by.func_70301_a(slot);
            if (!(origSlot != 0 || targetStack != null && targetStack.func_77973_b() instanceof ItemBlock)) {
                slot = InventoryPlayer.func_70451_h() - 1;
                targetStack = player.field_71071_by.func_70301_a(slot);
            }
            if (targetStack != null && targetStack.func_77973_b() instanceof ItemBlock) {
                player.field_71071_by.field_70461_c = slot;
                targetStack.func_77943_a(player, world, x, y, z, side, hitX, hitY, hitZ);
                player.field_71071_by.field_70461_c = origSlot;
                player.field_71071_by.func_70296_d();
                player.field_71069_bz.func_75142_b();
            }
        }
        return true;
    }

    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        ItemStack linkCrystalStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        ItemStack capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
        int coreTier = this.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE);
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        String preDGreen = EnumChatFormatting.DARK_GREEN.toString();
        String preBlue = EnumChatFormatting.BLUE.toString();
        byte mode = this.getToolModeByName(stack, "DropsMode");
        String str = mode == 0 ? "enderutilities.tooltip.item.normal" : (mode == 1 ? "enderutilities.tooltip.item.endertool.playerinv" : "enderutilities.tooltip.item.endertool.remote");
        str = StatCollector.func_74838_a((String)str);
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.endertool.dropsmode") + ": " + preDGreen + str + rst);
        mode = this.getToolModeByName(stack, "DigMode");
        str = mode == 0 ? "enderutilities.tooltip.item.normal" : "enderutilities.tooltip.item.fast";
        str = StatCollector.func_74838_a((String)str);
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.endertool.digmode") + ": " + preDGreen + str + rst);
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.endercore") + ": ";
        if (coreTier >= 0) {
            String coreType = coreTier == 0 ? "enderutilities.tooltip.item.basic" : (coreTier == 1 ? "enderutilities.tooltip.item.enhanced" : "enderutilities.tooltip.item.advanced");
            coreType = StatCollector.func_74838_a((String)coreType);
            str = str + preDGreen + coreType + rst + " (" + preBlue + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.tier") + " " + (coreTier + 1) + rst + ")";
        } else {
            String preRed = EnumChatFormatting.RED.toString();
            str = str + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.none") + rst;
        }
        list.add(str);
        if (linkCrystalStack != null && linkCrystalStack.func_77973_b() instanceof ItemLinkCrystal) {
            String preWhiteIta = EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC.toString();
            if (NBTHelperTarget.itemHasTargetTag(linkCrystalStack)) {
                ((ItemLinkCrystal)linkCrystalStack.func_77973_b()).addInformationSelective(linkCrystalStack, player, list, advancedTooltips, verbose);
            } else {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.notargetset"));
            }
            int num = UtilItemModular.getModuleCount(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) + 1;
            String dName = linkCrystalStack.func_82837_s() ? preWhiteIta + linkCrystalStack.func_82833_r() + rst + " " : "";
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedlinkcrystal.short") + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
        } else {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nolinkcrystals"));
        }
        if (capacitorStack != null && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
            ((ItemEnderCapacitor)capacitorStack.func_77973_b()).addInformationSelective(capacitorStack, player, list, advancedTooltips, verbose);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        ArrayList<String> tmpList = new ArrayList<String>();
        boolean verbose = EnderUtilities.proxy.isShiftKeyDown();
        if (stack != null && stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("AddTooltips") && !stack.func_77978_p().func_74764_b("ench") && !stack.func_77978_p().func_74764_b("Items")) {
            this.addTooltips(stack, tmpList, verbose);
            if (!verbose && tmpList.size() > 1) {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.holdshiftfordescription"));
            } else {
                list.addAll(tmpList);
            }
            return;
        }
        tmpList.clear();
        this.addInformationSelective(stack, player, tmpList, advancedTooltips, true);
        if (!verbose && tmpList.size() > 2) {
            tmpList.clear();
            this.addInformationSelective(stack, player, tmpList, advancedTooltips, false);
            list.add(tmpList.get(0));
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.holdshift"));
        } else {
            list.addAll(tmpList);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemEnderUtilities.addTooltips(this.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        if (!Configs.disableItemEnderTools.getBoolean(false)) {
            for (int i = 0; i <= 3; ++i) {
                ItemStack stack = new ItemStack((Item)this, 1, 0);
                this.setToolType(stack, ToolType.valueOf(i));
                stack.func_77978_p().func_74757_a("AddTooltips", true);
                list.add(stack);
            }
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public ToolType getToolType(ItemStack stack) {
        if (stack == null) {
            return ToolType.INVALID;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74779_i("ToolType").length() > 0) {
            return ToolType.valueOfType(nbt.func_74779_i("ToolType"));
        }
        this.setToolType(stack, ToolType.SHOVEL);
        return ToolType.SHOVEL;
    }

    public boolean setToolType(ItemStack stack, ToolType type) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74778_a("ToolType", type.getTypeString());
        return true;
    }

    public byte getToolModeByName(ItemStack stack, String name) {
        if (stack != null && stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74771_c(name);
        }
        return 0;
    }

    public void setToolModeByName(ItemStack stack, String name, byte value) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74774_a(name, value);
    }

    public String getToolClass(ItemStack stack) {
        ToolType type;
        if (stack != null && !(type = this.getToolType(stack)).equals(ToolType.INVALID)) {
            return type.getTypeString();
        }
        return null;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        String tc = this.getToolClass(stack);
        return tc != null ? ImmutableSet.of((Object)tc) : super.getToolClasses(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.func_77997_a();
    }

    public boolean isToolBroken(ItemStack stack) {
        return stack == null || stack.func_77960_j() >= this.getMaxDamage(stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase living1, EntityLivingBase living2) {
        if (stack == null || this.isToolBroken(stack)) {
            return false;
        }
        int amount = Math.min(2, this.getMaxDamage(stack) - stack.func_77960_j());
        stack.func_77972_a(amount, living2);
        if (this.isToolBroken(stack)) {
            living1.func_70669_a(stack);
        }
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        if (block.func_149688_o() != null && block.func_149688_o() == Material.field_151584_j && this.getToolType(stack).equals(ToolType.AXE)) {
            return false;
        }
        if (!this.isToolBroken(stack) && block.func_149712_f(world, x, y, z) > 0.0f) {
            int dmg = 1;
            if (this.getToolModeByName(stack, "DigMode") == 1) {
                dmg = 2;
            }
            dmg = Math.min(dmg, this.getMaxDamage(stack) - stack.func_77960_j());
            stack.func_77972_a(dmg, living);
            if (this.isToolBroken(stack)) {
                living.func_70669_a(stack);
            }
            return true;
        }
        return false;
    }

    public void handleHarvestDropsEvent(ItemStack toolStack, BlockEvent.HarvestDropsEvent event) {
        if (event.world == null || event.world.field_72995_K) {
            return;
        }
        byte mode = this.getToolModeByName(toolStack, "DropsMode");
        if (mode == 0) {
            return;
        }
        EntityPlayer player = event.harvester;
        boolean isSilk = event.isSilkTouching;
        int numDropsOriginal = event.drops.size();
        if (mode == 1 && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE) >= 0) {
            Iterator iter = event.drops.iterator();
            while (iter.hasNext()) {
                ItemStack stack = (ItemStack)iter.next();
                if (stack == null || !isSilk && !(event.world.field_73012_v.nextFloat() < event.dropChance) || !player.field_71071_by.func_70441_a(stack.func_77946_l())) continue;
                iter.remove();
            }
        } else if (mode == 2 && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE) >= 1 && UtilItemModular.useEnderCharge(toolStack, player, 50, false)) {
            NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (this.getSelectedModuleTier(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 1 && target != null && "minecraft:ender_chest".equals(target.blockName)) {
                Iterator iter = event.drops.iterator();
                while (iter.hasNext()) {
                    ItemStack stack = (ItemStack)iter.next();
                    if (stack == null || !isSilk && !(event.world.field_73012_v.nextFloat() < event.dropChance) || !InventoryUtils.tryInsertItemStackToInventory((IInventory)player.func_71005_bN(), stack.func_77946_l(), target.blockFace)) continue;
                    iter.remove();
                }
            } else {
                if (!NBTHelperPlayer.canAccessSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player) || target == null || target.dimension != player.field_71093_bK && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE) < 2) {
                    return;
                }
                WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(target.dimension);
                if (targetWorld == null) {
                    return;
                }
                ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, target.dimension, target.posX >> 4, target.posZ >> 4, 30);
                if (this.getSelectedModuleTier(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 1) {
                    TileEntity te = targetWorld.func_147438_o(target.posX, target.posY, target.posZ);
                    if (te == null || !(te instanceof IInventory) || !target.isTargetBlockUnchanged()) {
                        NBTHelperTarget.removeTargetTagFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("enderutilities.chat.message.enderbag.blockchanged", new Object[0]));
                        return;
                    }
                    if (te instanceof IInventory) {
                        Iterator iter = event.drops.iterator();
                        while (iter.hasNext()) {
                            ItemStack stack = (ItemStack)iter.next();
                            if (stack == null || !isSilk && !(event.world.field_73012_v.nextFloat() < event.dropChance) || !InventoryUtils.tryInsertItemStackToInventory((IInventory)te, stack.func_77946_l(), target.blockFace)) continue;
                            iter.remove();
                        }
                    }
                } else if (this.getSelectedModuleTier(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0) {
                    Iterator iter = event.drops.iterator();
                    while (iter.hasNext()) {
                        ItemStack stack = (ItemStack)iter.next();
                        if (stack == null || !isSilk && !(event.world.field_73012_v.nextFloat() < event.dropChance)) continue;
                        EntityItem entityItem = new EntityItem((World)targetWorld, target.dPosX, target.dPosY + 0.125, target.dPosZ, stack.func_77946_l());
                        entityItem.field_70179_y = 0.0;
                        entityItem.field_70159_w = 0.0;
                        entityItem.field_70181_x = 0.15;
                        if (!targetWorld.func_72838_d((Entity)entityItem)) continue;
                        Particles.spawnParticles((World)targetWorld, "portal", target.dPosX, target.dPosY, target.dPosZ, 3, 0.2, 1.0);
                        iter.remove();
                    }
                }
            }
        }
        if (event.drops.size() != numDropsOriginal) {
            if (mode == 2) {
                UtilItemModular.useEnderCharge(toolStack, player, 50, true);
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(2, 3, (double)event.x + 0.5, (double)event.y + 0.5, (double)event.z + 0.5, 8, 0.2, 0.3), new NetworkRegistry.TargetPoint(event.world.field_73011_w.field_76574_g, (double)event.x, (double)event.y, (double)event.z, 24.0));
        }
        if (event.drops.size() == 0) {
            event.dropChance = 0.0f;
        }
    }

    public boolean func_150897_b(Block block) {
        return false;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (this.isToolBroken(stack)) {
            return 0.2f;
        }
        if (this.canHarvestBlock(block, stack)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        if (this.isToolBroken(stack)) {
            return false;
        }
        return this.getToolType(stack).equals(ToolType.PICKAXE) ? block.func_149688_o() == Material.field_151576_e || block.func_149688_o() == Material.field_151592_s || block.func_149688_o() == Material.field_151588_w || block.func_149688_o() == Material.field_151598_x || block.func_149688_o() == Material.field_76233_E || block.func_149688_o() == Material.field_151573_f || block.func_149688_o() == Material.field_151574_g : (this.getToolType(stack).equals(ToolType.AXE) ? block.func_149688_o() == Material.field_151575_d || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151572_C || block.func_149688_o() == Material.field_151593_r || block.func_149688_o() == Material.field_151580_n || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151582_l : this.getToolType(stack).equals(ToolType.SHOVEL) && (block.func_149688_o() == Material.field_151578_c || block.func_149688_o() == Material.field_151577_b || block.func_149688_o() == Material.field_151595_p || block.func_149688_o() == Material.field_151597_y || block.func_149688_o() == Material.field_151596_z || block.func_149688_o() == Material.field_151571_B));
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.isToolBroken(stack)) {
            return 0.2f;
        }
        if (block.func_149688_o() != null && block.func_149688_o() == Material.field_151584_j && this.getToolType(stack).equals(ToolType.AXE)) {
            return 100.0f;
        }
        float eff = this.field_77864_a;
        if (this.getToolModeByName(stack, "DigMode") == 1) {
            eff = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)stack) >= 5 ? 124.0f : 24.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return eff;
        }
        if (this.canHarvestBlock(block, stack)) {
            return eff;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (stack == null) {
            return -1;
        }
        if (this.isToolBroken(stack)) {
            return -1;
        }
        if (toolClass.equals(this.getToolClass(stack))) {
            return this.func_150913_i().func_77996_d();
        }
        return -1;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.func_77995_e();
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        double dmg = this.field_77865_bY;
        dmg = this.isToolBroken(stack) ? 1.0 : (dmg += (double)this.getToolType(stack).getAttackDamage());
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", dmg, 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + "." + "enderpickaxe" + ".head.1");
        this.iconEmpty = iconRegister.func_94245_a(ReferenceTextures.getItemTextureName("empty"));
        this.parts = new String[]{"rod.1", "head.1", "head.2", "head.3", "head.1.glow", "head.2.glow", "head.3.glow", "head.1.broken", "head.2.broken", "head.3.broken", "head.1.glow.broken", "head.2.glow.broken", "head.3.glow.broken", "core.1", "core.2", "core.3", "capacitor.1", "capacitor.2", "capacitor.3", "linkcrystal.1", "linkcrystal.2"};
        this.iconArray = new IIcon[this.parts.length * 4];
        String prefix = this.func_111208_A() + ".";
        for (ToolType type : ToolType.values()) {
            int id = type.getId();
            int start = id * this.parts.length;
            for (int j = 0; id >= 0 && j < this.parts.length && start + j < this.iconArray.length; ++j) {
                this.iconArray[start + j] = iconRegister.func_94245_a(prefix + type.getName() + "." + this.parts[j]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.getIcon(stack, renderPass, null, null, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (stack == null) {
            return this.field_77791_bV;
        }
        ToolType type = this.getToolType(stack);
        if (type.equals(ToolType.INVALID)) {
            return this.field_77791_bV;
        }
        int i = type.getId() * this.parts.length;
        int tier = 0;
        switch (renderPass) {
            case 0: {
                break;
            }
            case 1: {
                i += this.getToolModeByName(stack, "DropsMode") + 1;
                if (this.getToolModeByName(stack, "DigMode") != 0) {
                    i += 3;
                }
                if (!this.isToolBroken(stack)) break;
                i += 6;
                break;
            }
            case 2: {
                tier = this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE);
                if (tier >= 0) {
                    i += tier + 13;
                    break;
                }
                return this.iconEmpty;
            }
            case 3: {
                tier = this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
                if (tier >= 0) {
                    i += tier + 16;
                    break;
                }
                return this.iconEmpty;
            }
            case 4: {
                ItemStack lcStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                tier = lcStack != null && lcStack.func_77973_b() instanceof ItemLinkCrystal ? ((ItemLinkCrystal)lcStack.func_77973_b()).getModuleTier(lcStack) : this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                if (tier >= 0) {
                    i += tier + 19;
                    break;
                }
                return this.iconEmpty;
            }
            default: {
                return this.iconEmpty;
            }
        }
        if (i < 0 || i >= this.iconArray.length) {
            return this.iconEmpty;
        }
        return this.iconArray[i];
    }

    public void changeDigMode(ItemStack stack) {
        byte mode = this.getToolModeByName(stack, "DigMode");
        if ((mode = (byte)(mode + 1)) > 1) {
            mode = 0;
        }
        this.setToolModeByName(stack, "DigMode", mode);
    }

    public void changeDropsMode(ItemStack stack) {
        byte mode = this.getToolModeByName(stack, "DropsMode");
        if ((mode = (byte)(mode + 1)) > 2) {
            mode = 0;
        }
        this.setToolModeByName(stack, "DropsMode", mode);
    }

    public void changePrivacyMode(ItemStack stack, EntityPlayer player) {
        NBTHelperPlayer data = NBTHelperPlayer.getPlayerDataFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (data != null && data.isOwner(player)) {
            data.isPublic = !data.isPublic;
            data.writeToSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (key == 1) {
            this.changeDigMode(stack);
        } else if (ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, ReferenceKeys.keypressContainsControl(key));
        } else if (ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsControl(key)) {
            UtilItemModular.setTarget(stack, player, true);
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeDropsMode(stack);
        } else if (ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key)) {
            this.changePrivacyMode(stack, player);
        }
    }

    @Override
    public int getModuleCount(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getModuleCount(stack, moduleType);
    }

    @Override
    public int getMaxModules(ItemStack stack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack stack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack toolStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 0 || imodule.getModuleTier(moduleStack) == 1) {
            return this.getMaxModules(toolStack, moduleType);
        }
        return 0;
    }

    @Override
    public int getMaxModuleTier(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getMaxModuleTier(stack, moduleType);
    }

    @Override
    public int getSelectedModuleTier(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getSelectedModuleTier(stack, moduleType);
    }

    @Override
    public ItemStack getSelectedModuleStack(ItemStack stack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getSelectedModuleStack(stack, moduleType);
    }

    @Override
    public ItemStack setSelectedModuleStack(ItemStack toolStack, ItemModule.ModuleType moduleType, ItemStack moduleStack) {
        return UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
    }

    @Override
    public ItemStack changeSelectedModule(ItemStack stack, ItemModule.ModuleType moduleType, boolean reverse) {
        return UtilItemModular.changeSelectedModule(stack, moduleType, reverse);
    }

    @Override
    public List<NBTTagCompound> getAllModules(ItemStack stack) {
        return UtilItemModular.getAllModules(stack);
    }

    @Override
    public ItemStack setAllModules(ItemStack stack, List<NBTTagCompound> modules) {
        return UtilItemModular.setAllModules(stack, modules);
    }

    @Override
    public ItemStack setModule(ItemStack stack, int index, NBTTagCompound nbt) {
        return UtilItemModular.setModule(stack, index, nbt);
    }

    public static enum ToolType {
        PICKAXE(0, "pickaxe", "enderpickaxe", 2.0f),
        AXE(1, "axe", "enderaxe", 3.0f),
        SHOVEL(2, "shovel", "endershovel", 1.0f),
        HOE(3, "hoe", "enderhoe", 0.0f),
        INVALID(-1, "null", "null", 0.0f);

        private final int id;
        private final String typeString;
        private final String name;
        private final float attackDamage;
        private static final Map<Integer, ToolType> mapInt;
        private static final Map<String, ToolType> mapType;

        private ToolType(int id, String type, String name, float attackDamage) {
            this.id = id;
            this.typeString = type;
            this.name = name;
            this.attackDamage = attackDamage;
        }

        public int getId() {
            return this.id;
        }

        public String getTypeString() {
            return this.typeString;
        }

        public String getName() {
            return this.name;
        }

        public float getAttackDamage() {
            return this.attackDamage;
        }

        public boolean equals(ToolType other) {
            return this.id == other.getId();
        }

        public static ToolType valueOf(int id) {
            ToolType type = mapInt.get(id);
            if (type != null) {
                return type;
            }
            return INVALID;
        }

        public static ToolType valueOfType(String typeName) {
            ToolType type = mapType.get(typeName);
            if (type != null) {
                return type;
            }
            return INVALID;
        }

        static {
            mapInt = new HashMap<Integer, ToolType>();
            mapType = new HashMap<String, ToolType>();
            for (ToolType type : ToolType.values()) {
                mapInt.put(type.getId(), type);
                mapType.put(type.getTypeString(), type);
            }
        }
    }
}

