/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.definitions.IMaterials;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;
import thaumicenergistics.container.ContainerPartEssentiaIOBus;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.gui.GuiEssentiaIO;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.integration.tc.EssentiaTileContainerHelper;
import thaumicenergistics.network.IAspectSlotPart;
import thaumicenergistics.network.packet.client.PacketClientAspectSlot;
import thaumicenergistics.network.packet.client.PacketClientEssentiaIOBus;
import thaumicenergistics.parts.AbstractAEPartBase;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.registries.EnumCache;
import thaumicenergistics.util.EffectiveSide;
import thaumicenergistics.util.IInventoryUpdateReceiver;

public abstract class AEPartEssentiaIO
extends AbstractAEPartBase
implements IGridTickable,
IInventoryUpdateReceiver,
IAspectSlotPart,
IAEAppEngInventory {
    private static final int BASE_TRANSFER_PER_SECOND = 4;
    private static final int ADDITIONAL_TRANSFER_PER_SECOND = 8;
    private static final int MINIMUM_TICKS_PER_OPERATION = 10;
    private static final int MAXIMUM_TICKS_PER_OPERATION = 40;
    private static final int MAXIMUM_TRANSFER_PER_SECOND = 64;
    private static final int MINIMUM_TRANSFER_PER_SECOND = 1;
    private static final int MAX_FILTER_SIZE = 9;
    private static final int BASE_SLOT_INDEX = 4;
    private static final int[] TIER2_INDEXS = new int[]{0, 2, 6, 8};
    private static final int[] TIER1_INDEXS = new int[]{1, 3, 5, 7};
    private static final int UPGRADE_INVENTORY_SIZE = 4;
    private static final double IDLE_POWER_DRAIN = 0.7;
    private static final double POWER_DRAIN_PER_ESSENTIA = 0.5;
    private boolean lastRedstone;
    private int[] availableFilterSlots = new int[]{4};
    private UpgradeInventory upgradeInventory = new StackUpgradeInventory(this.associatedItem, (IAEAppEngInventory)this, 4);
    private List<ContainerPartEssentiaIOBus> listeners = new ArrayList<ContainerPartEssentiaIOBus>();
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private MachineSource asMachineSource;
    protected List<Aspect> filteredAspects = new ArrayList<Aspect>(9);
    protected IAspectContainer facingContainer;
    protected byte filterSize;
    protected byte upgradeSpeedCount = 0;
    protected boolean redstoneControlled;

    public AEPartEssentiaIO(AEPartsEnum associatedPart) {
        super(associatedPart);
        for (int index = 0; index < 9; ++index) {
            this.filteredAspects.add(null);
        }
        this.asMachineSource = new MachineSource((IActionHost)this);
    }

    private boolean canDoWork() {
        boolean canWork = true;
        if (this.redstoneControlled) {
            switch (this.getRedstoneMode()) {
                case HIGH_SIGNAL: {
                    canWork = this.redstonePowered;
                    break;
                }
                case IGNORE: {
                    break;
                }
                case LOW_SIGNAL: {
                    canWork = !this.redstonePowered;
                    break;
                }
                case SIGNAL_PULSE: {
                    canWork = false;
                }
            }
        }
        return canWork;
    }

    private int getTransferAmountPerSecond() {
        return 4 + this.upgradeSpeedCount * 8;
    }

    private void notifyListenersOfFilterAspectChange() {
        for (ContainerPartEssentiaIOBus listener : this.listeners) {
            listener.setFilteredAspect(this.filteredAspects);
        }
    }

    private void notifyListenersOfFilterSizeChange() {
        for (ContainerPartEssentiaIOBus listener : this.listeners) {
            listener.setFilterSize(this.filterSize);
        }
    }

    private void notifyListenersOfRedstoneControlledChange() {
        for (ContainerPartEssentiaIOBus listener : this.listeners) {
            listener.setRedstoneControlled(this.redstoneControlled);
        }
    }

    private void notifyListenersOfRedstoneModeChange() {
        for (ContainerPartEssentiaIOBus listener : this.listeners) {
            listener.setRedstoneMode(this.redstoneMode);
        }
    }

    private void resizeAvailableArray() {
        this.availableFilterSlots = new int[1 + this.filterSize * 4];
        this.availableFilterSlots[0] = 4;
        if (this.filterSize < 2) {
            int i;
            for (i = 0; i < TIER2_INDEXS.length; ++i) {
                this.filteredAspects.set(TIER2_INDEXS[i], null);
            }
            if (this.filterSize < 1) {
                for (i = 0; i < TIER1_INDEXS.length; ++i) {
                    this.filteredAspects.set(TIER1_INDEXS[i], null);
                }
            } else {
                System.arraycopy(TIER1_INDEXS, 0, this.availableFilterSlots, 1, 4);
            }
        } else {
            System.arraycopy(TIER1_INDEXS, 0, this.availableFilterSlots, 1, 4);
            System.arraycopy(TIER2_INDEXS, 0, this.availableFilterSlots, 5, 4);
        }
    }

    private boolean takePowerFromNetwork(int essentiaAmount, Actionable mode) {
        IEnergyGrid eGrid = this.gridBlock.getEnergyGrid();
        if (eGrid == null) {
            return false;
        }
        double powerDrain = 0.5 * (double)essentiaAmount;
        return eGrid.extractAEPower(powerDrain, mode, PowerMultiplier.CONFIG) >= powerDrain;
    }

    protected boolean extractEssentiaFromNetwork(int amountToFillContainer) {
        if (this.facingContainer == null) {
            return false;
        }
        if (!this.takePowerFromNetwork(amountToFillContainer, Actionable.SIMULATE)) {
            return false;
        }
        for (Aspect filterAspect : this.filteredAspects) {
            int filledAmount;
            IAEFluidStack toExtract;
            IAEFluidStack extractedStack;
            GaseousEssentia essentiaGas;
            if (filterAspect == null || !this.aspectTransferAllowed(filterAspect) || EssentiaTileContainerHelper.instance.injectIntoContainer(this.facingContainer, 1, filterAspect, Actionable.SIMULATE) < 1L || (essentiaGas = GaseousEssentia.getGasFromAspect(filterAspect)) == null || (extractedStack = this.extractFluid(toExtract = EssentiaConversionHelper.instance.createAEFluidStackInEssentiaUnits(essentiaGas, amountToFillContainer), Actionable.SIMULATE)) == null || extractedStack.getStackSize() <= 0L || (filledAmount = (int)EssentiaTileContainerHelper.instance.injectIntoContainer(this.facingContainer, extractedStack, Actionable.MODULATE)) == 0) continue;
            this.takePowerFromNetwork((int)EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(filledAmount), Actionable.MODULATE);
            this.extractFluid(EssentiaConversionHelper.instance.createAEFluidStackInFluidUnits(essentiaGas, filledAmount), Actionable.MODULATE);
            return true;
        }
        return false;
    }

    protected final IAEFluidStack extractFluid(IAEFluidStack toExtract, Actionable action) {
        if (this.gridBlock == null || this.facingContainer == null) {
            return null;
        }
        IMEMonitor<IAEFluidStack> monitor = this.gridBlock.getFluidMonitor();
        if (monitor == null) {
            return null;
        }
        return (IAEFluidStack)monitor.extractItems((IAEStack)toExtract, action, (BaseActionSource)this.asMachineSource);
    }

    protected boolean injectEssentaToNetwork(int amountToDrainFromContainer) {
        Aspect aspectToDrain = EssentiaTileContainerHelper.instance.getAspectInContainer(this.facingContainer);
        if (aspectToDrain == null || !this.aspectTransferAllowed(aspectToDrain)) {
            return false;
        }
        FluidStack drained = EssentiaTileContainerHelper.instance.extractFromContainer(this.facingContainer, amountToDrainFromContainer, aspectToDrain, Actionable.SIMULATE);
        if (drained == null) {
            return false;
        }
        IAEFluidStack toFill = AEApi.instance().storage().createFluidStack(drained);
        IAEFluidStack notInjected = this.injectFluid(toFill, Actionable.SIMULATE);
        if (notInjected != null) {
            int amountInjected = (int)(toFill.getStackSize() - notInjected.getStackSize());
            if (amountInjected == 0) {
                return false;
            }
            amountToDrainFromContainer = amountInjected = (int)EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(amountInjected);
            toFill.setStackSize((long)amountInjected);
        }
        if (!this.takePowerFromNetwork(amountToDrainFromContainer, Actionable.SIMULATE)) {
            return false;
        }
        this.takePowerFromNetwork(amountToDrainFromContainer, Actionable.MODULATE);
        this.injectFluid(toFill, Actionable.MODULATE);
        EssentiaTileContainerHelper.instance.extractFromContainer(this.facingContainer, amountToDrainFromContainer, aspectToDrain, Actionable.MODULATE);
        return true;
    }

    protected final IAEFluidStack injectFluid(IAEFluidStack toInject, Actionable action) {
        if (this.gridBlock == null || this.facingContainer == null) {
            return null;
        }
        IMEMonitor<IAEFluidStack> monitor = this.gridBlock.getFluidMonitor();
        if (monitor == null) {
            return null;
        }
        return (IAEFluidStack)monitor.injectItems((IAEStack)toInject, action, (BaseActionSource)this.asMachineSource);
    }

    public boolean addFilteredAspectFromItemstack(EntityPlayer player, ItemStack itemStack) {
        Aspect itemAspect = EssentiaItemContainerHelper.instance.getAspectInContainer(itemStack);
        if (itemAspect != null) {
            if (this.filteredAspects.contains(itemAspect)) {
                return true;
            }
            for (int avalibleIndex = 0; avalibleIndex < this.availableFilterSlots.length; ++avalibleIndex) {
                int filterIndex = this.availableFilterSlots[avalibleIndex];
                if (this.filteredAspects.get(filterIndex) != null) continue;
                if (EffectiveSide.isServerSide()) {
                    this.setAspect(filterIndex, itemAspect, player);
                }
                return true;
            }
        }
        return false;
    }

    public void addListener(ContainerPartEssentiaIOBus container) {
        if (!this.listeners.contains((Object)container)) {
            this.listeners.add(container);
        }
    }

    public abstract boolean aspectTransferAllowed(Aspect var1);

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    public abstract boolean doWork(int var1);

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiEssentiaIO(this, player);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        if (wrenched) {
            return;
        }
        for (int slotIndex = 0; slotIndex < 4; ++slotIndex) {
            ItemStack slotStack = this.upgradeInventory.func_70301_a(slotIndex);
            if (slotStack == null || slotStack.field_77994_a <= 0) continue;
            drops.add(slotStack);
        }
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.7;
    }

    @Override
    public int getLightLevel() {
        return this.isActive ? 4 : 0;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerPartEssentiaIOBus(this, player);
    }

    public TickingRequest getTickingRequest(IGridNode arg0) {
        return new TickingRequest(10, 40, false, false);
    }

    public UpgradeInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 position) {
        boolean activated = super.onActivate(player, position);
        this.onInventoryChanged(null);
        return activated;
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.upgradeInventory) {
            this.onInventoryChanged(inv);
        }
    }

    public void onClientRequestChangeRedstoneMode(EntityPlayer player) {
        int nextOrdinal = this.redstoneMode.ordinal() + 1;
        if (nextOrdinal >= EnumCache.AE_REDSTONE_MODES.length) {
            nextOrdinal = 0;
        }
        this.redstoneMode = EnumCache.AE_REDSTONE_MODES[nextOrdinal];
        this.notifyListenersOfRedstoneModeChange();
    }

    public void onClientRequestFullUpdate(EntityPlayer player) {
        new PacketClientAspectSlot().createFilterListUpdate(this.filteredAspects, player).sendPacketToPlayer();
        new PacketClientEssentiaIOBus().createFullUpdate(player, this.redstoneMode, this.filterSize, this.redstoneControlled).sendPacketToPlayer();
    }

    @Override
    public void onInventoryChanged(IInventory sourceInventory) {
        byte oldFilterSize = this.filterSize;
        this.filterSize = 0;
        this.redstoneControlled = false;
        this.upgradeSpeedCount = 0;
        IMaterials aeMaterals = AEApi.instance().definitions().materials();
        for (int i = 0; i < this.upgradeInventory.func_70302_i_(); ++i) {
            ItemStack slotStack = this.upgradeInventory.func_70301_a(i);
            if (slotStack == null) continue;
            if (aeMaterals.cardCapacity().isSameAs(slotStack)) {
                this.filterSize = (byte)(this.filterSize + 1);
                continue;
            }
            if (aeMaterals.cardRedstone().isSameAs(slotStack)) {
                this.redstoneControlled = true;
                continue;
            }
            if (!aeMaterals.cardSpeed().isSameAs(slotStack)) continue;
            this.upgradeSpeedCount = (byte)(this.upgradeSpeedCount + 1);
        }
        if (oldFilterSize != this.filterSize) {
            this.resizeAvailableArray();
        }
        if (EffectiveSide.isClientSide()) {
            return;
        }
        this.notifyListenersOfFilterSizeChange();
        this.notifyListenersOfRedstoneControlledChange();
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        if (EffectiveSide.isClientSide()) {
            return;
        }
        this.facingContainer = null;
        TileEntity tileEntity = this.getFacingTile();
        if (tileEntity instanceof IAspectContainer) {
            this.facingContainer = (IAspectContainer)tileEntity;
        }
        if (this.redstoneMode == RedstoneMode.SIGNAL_PULSE && this.redstonePowered != this.lastRedstone) {
            this.lastRedstone = this.redstonePowered;
            this.doWork(this.getTransferAmountPerSecond());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.redstoneMode = EnumCache.AE_REDSTONE_MODES[data.func_74762_e("redstoneMode")];
        for (int index = 0; index < 9; ++index) {
            String aspectTag = data.func_74779_i("AspectFilter#" + index);
            if (aspectTag.equals("")) continue;
            this.filteredAspects.set(index, (Aspect)Aspect.aspects.get(aspectTag));
        }
        this.upgradeInventory.readFromNBT(data, "upgradeInventory");
        this.onInventoryChanged((IInventory)this.upgradeInventory);
    }

    @Override
    public final boolean readFromStream(ByteBuf stream) throws IOException {
        return super.readFromStream(stream);
    }

    @SideOnly(value=Side.CLIENT)
    public void receiveFilterList(List<Aspect> filteredAspects) {
        this.filteredAspects = filteredAspects;
    }

    @SideOnly(value=Side.CLIENT)
    public void receiveFilterSize(byte filterSize) {
        this.filterSize = filterSize;
        this.resizeAvailableArray();
    }

    public void removeListener(ContainerPartEssentiaIOBus container) {
        this.listeners.remove((Object)container);
    }

    public void saveChanges() {
        this.host.markForSave();
    }

    @Override
    public final void setAspect(int index, Aspect aspect, EntityPlayer player) {
        this.filteredAspects.set(index, aspect);
        this.notifyListenersOfFilterAspectChange();
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.canDoWork()) {
            int transferAmountPerSecond = this.getTransferAmountPerSecond();
            int transferAmount = (int)((float)transferAmountPerSecond * ((float)ticksSinceLastCall / 20.0f));
            if (transferAmount < 1) {
                transferAmount = 1;
            } else if (transferAmount > 64) {
                transferAmount = 64;
            }
            if (this.doWork(transferAmount)) {
                return TickRateModulation.URGENT;
            }
        }
        return TickRateModulation.IDLE;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("redstoneMode", this.redstoneMode.ordinal());
        for (int i = 0; i < 9; ++i) {
            Aspect aspect = this.filteredAspects.get(i);
            String aspectTag = "";
            if (aspect != null) {
                aspectTag = aspect.getTag();
            }
            data.func_74778_a("AspectFilter#" + i, aspectTag);
        }
        this.upgradeInventory.writeToNBT(data, "upgradeInventory");
    }

    @Override
    public final void writeToStream(ByteBuf stream) throws IOException {
        super.writeToStream(stream);
    }
}

