/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.implementaion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.blocks.BlockJarItem;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumicenergistics.api.IEssentiaContainerPermission;
import thaumicenergistics.api.ITransportPermissions;
import thaumicenergistics.util.ThELog;

class ThETransportPermissions
implements ITransportPermissions {
    private final HashMap<Class<? extends IEssentiaContainerItem>, ContainerCollection> itemWhitelist = new HashMap();
    private final List<Class<? extends TileEntity>> tileExtractWhiteList = new ArrayList<Class<? extends TileEntity>>();
    private final List<Class<? extends TileEntity>> tileInjectWhiteList = new ArrayList<Class<? extends TileEntity>>();

    ThETransportPermissions() {
    }

    @Override
    public boolean addAspectContainerTileToExtractPermissions(Class<? extends TileEntity> tileClass) {
        if (tileClass != null && IAspectContainer.class.isAssignableFrom(tileClass)) {
            if (!this.tileExtractWhiteList.contains(tileClass)) {
                this.tileExtractWhiteList.add(tileClass);
                ThELog.info("Added %s to extraction whitelist.", tileClass.toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAspectContainerTileToInjectPermissions(Class<? extends TileEntity> tileClass) {
        if (tileClass != null && IAspectContainer.class.isAssignableFrom(tileClass)) {
            if (!this.tileInjectWhiteList.contains(tileClass)) {
                this.tileInjectWhiteList.add(tileClass);
                ThELog.info("Added %s to injection whitelist.", tileClass.toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public void addEssentiaContainerItemToTransportPermissions(Class<? extends IEssentiaContainerItem> itemClass, int capacity, int damageValue, boolean canHoldPartialAmount) {
        if (itemClass != null) {
            if (this.itemWhitelist.containsKey(itemClass)) {
                this.itemWhitelist.get(itemClass).addContainer(capacity, canHoldPartialAmount, damageValue);
            } else {
                this.itemWhitelist.put(itemClass, new ContainerCollection(capacity, canHoldPartialAmount, damageValue));
            }
            ThELog.info("Adding %s[%d] to item whitelist.", itemClass.toString(), damageValue);
        }
    }

    @Override
    public void addEssentiaContainerItemToTransportPermissions(ItemStack containerItem, int capacity, boolean canHoldPartialAmount) {
        if (containerItem == null || !(containerItem.func_77973_b() instanceof IEssentiaContainerItem)) {
            return;
        }
        try {
            this.addEssentiaContainerItemToTransportPermissions(containerItem.func_77973_b().getClass(), capacity, containerItem.func_77960_j(), canHoldPartialAmount);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    @Override
    public boolean canExtractFromAspectContainerTile(IAspectContainer container) {
        if (!(container instanceof TileEntity)) {
            return false;
        }
        for (Class<? extends TileEntity> whiteClass : this.tileExtractWhiteList) {
            if (!whiteClass.isInstance(container)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canInjectToAspectContainerTile(IAspectContainer container) {
        if (!(container instanceof TileEntity)) {
            return false;
        }
        for (Class<? extends TileEntity> whiteClass : this.tileInjectWhiteList) {
            if (!whiteClass.isInstance(container)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IEssentiaContainerPermission getEssentiaContainerInfo(Class<? extends Item> itemClass, int damageValue) {
        if (this.itemWhitelist.containsKey(itemClass)) {
            return this.itemWhitelist.get(itemClass).getInfo(damageValue);
        }
        if (itemClass == BlockJarItem.class) {
            return this.itemWhitelist.get(ItemJarFilled.class).getInfo(damageValue);
        }
        return null;
    }

    private class ContainerInfo
    implements IEssentiaContainerPermission {
        private int capacity;
        private boolean canHoldPartialAmount;

        public ContainerInfo(int capacity, boolean canHoldPartialAmount) {
            this.capacity = capacity;
            this.canHoldPartialAmount = canHoldPartialAmount;
        }

        @Override
        public boolean canHoldPartialAmount() {
            return this.canHoldPartialAmount;
        }

        @Override
        public int maximumCapacity() {
            return this.capacity;
        }
    }

    private class ContainerCollection {
        private HashMap<Integer, ContainerInfo> containers = new HashMap();

        public ContainerCollection(int capacity, boolean canHoldPartialAmount, int damageValue) {
            this.addContainer(capacity, canHoldPartialAmount, damageValue);
        }

        public ContainerCollection addContainer(int capacity, boolean canHoldPartialAmount, int damageValue) {
            ContainerInfo info = new ContainerInfo(capacity, canHoldPartialAmount);
            this.containers.put(damageValue, info);
            return this;
        }

        public ContainerInfo getInfo(int damageValue) {
            return this.containers.get(damageValue);
        }
    }
}

