/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.network;

import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISecurable;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.lib.gui.container.IAugmentableContainer;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.gui.container.ISchematicContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PacketTEBase
extends PacketCoFHBase {
    public static void initialize() {
        PacketHandler.instance.registerPacket(PacketTEBase.class);
    }

    public void handlePacket(EntityPlayer entityPlayer, boolean bl) {
        try {
            byte by = this.getByte();
            switch (PacketTypes.values()[by]) {
                case RS_POWER_UPDATE: {
                    int[] nArray = this.getCoords();
                    IRedstoneControl iRedstoneControl = (IRedstoneControl)entityPlayer.field_70170_p.func_147438_o(nArray[0], nArray[1], nArray[2]);
                    iRedstoneControl.setPowered(this.getBool());
                    return;
                }
                case RS_CONFIG_UPDATE: {
                    int[] nArray = this.getCoords();
                    IRedstoneControl iRedstoneControl = (IRedstoneControl)entityPlayer.field_70170_p.func_147438_o(nArray[0], nArray[1], nArray[2]);
                    iRedstoneControl.setControl(IRedstoneControl.ControlMode.values()[this.getByte()]);
                    return;
                }
                case SECURITY_UPDATE: {
                    if (entityPlayer.field_71070_bA instanceof ISecurable) {
                        ((ISecurable)entityPlayer.field_71070_bA).setAccess(ISecurable.AccessMode.values()[this.getByte()]);
                    }
                    return;
                }
                case TAB_AUGMENT: {
                    if (entityPlayer.field_71070_bA instanceof IAugmentableContainer) {
                        ((IAugmentableContainer)entityPlayer.field_71070_bA).setAugmentLock(this.getBool());
                    }
                    return;
                }
                case TAB_SCHEMATIC: {
                    if (entityPlayer.field_71070_bA instanceof ISchematicContainer) {
                        ((ISchematicContainer)entityPlayer.field_71070_bA).writeSchematic();
                    }
                    return;
                }
                case CONFIG_SYNC: {
                    ThermalExpansion.instance.handleConfigSync(this);
                    return;
                }
            }
            ThermalExpansion.log.error("Unknown Packet! Internal: TEPH, ID: " + by);
        }
        catch (Exception exception) {
            ThermalExpansion.log.error("Packet payload failure! Please check your config files!");
            exception.printStackTrace();
        }
    }

    public static void sendRSPowerUpdatePacketToClients(IRedstoneControl iRedstoneControl, World world, int n, int n2, int n3) {
        PacketHandler.sendToAllAround((PacketBase)PacketTEBase.getPacket(PacketTypes.RS_POWER_UPDATE).addCoords(n, n2, n3).addBool(iRedstoneControl.isPowered()), (World)world, (int)n, (int)n2, (int)n3);
    }

    public static void sendRSConfigUpdatePacketToServer(IRedstoneControl iRedstoneControl, int n, int n2, int n3) {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.RS_CONFIG_UPDATE).addCoords(n, n2, n3).addByte(iRedstoneControl.getControl().ordinal()));
    }

    public static void sendSecurityPacketToServer(ISecurable iSecurable) {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.SECURITY_UPDATE).addByte(iSecurable.getAccess().ordinal()));
    }

    public static void sendTabAugmentPacketToServer(boolean bl) {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.TAB_AUGMENT).addBool(bl));
    }

    public static void sendTabSchematicPacketToServer() {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.TAB_SCHEMATIC));
    }

    public static void sendConfigSyncPacketToClient(EntityPlayer entityPlayer) {
        PacketHandler.sendTo((PacketBase)ThermalExpansion.instance.getConfigSync(), (EntityPlayer)entityPlayer);
    }

    public static PacketCoFHBase getPacket(PacketTypes packetTypes) {
        return new PacketTEBase().addByte(packetTypes.ordinal());
    }

    public static enum PacketTypes {
        RS_POWER_UPDATE,
        RS_CONFIG_UPDATE,
        SECURITY_UPDATE,
        TAB_AUGMENT,
        TAB_SCHEMATIC,
        CONFIG_SYNC;

    }
}

