/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.element;

import cofh.core.gui.element.TabConfiguration;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.cell.TileCell;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;

public class TabConfigCell
extends TabBase {
    TileCell myTile;

    public TabConfigCell(GuiBase guiBase, TileCell tileCell) {
        this(guiBase, TabConfiguration.defaultSide, tileCell);
    }

    public TabConfigCell(GuiBase guiBase, int n, TileCell tileCell) {
        super(guiBase, n);
        this.headerColor = TabConfiguration.defaultHeaderColor;
        this.subheaderColor = TabConfiguration.defaultSubHeaderColor;
        this.textColor = TabConfiguration.defaultTextColor;
        this.backgroundColor = TabConfiguration.defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.myTile = tileCell;
    }

    public void draw() {
        this.drawBackground();
        this.drawTabIcon("IconConfig");
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_78261_a(StringHelper.localize((String)"info.cofh.configuration"), this.posXOffset() + 18, ((ElementBase)this).posY + 6, this.headerColor);
        RenderHelper.setBlockTextureSheet();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (int i = 0; i < 3; ++i) {
            ((ElementBase)this).gui.drawIcon(this.myTile.getTexture(1, i), this.posX() + 40, ((ElementBase)this).posY + 24, 0);
            ((ElementBase)this).gui.drawIcon(this.myTile.getTexture(BlockHelper.SIDE_LEFT[this.myTile.getFacing()], i), this.posX() + 20, ((ElementBase)this).posY + 44, 0);
            ((ElementBase)this).gui.drawIcon(this.myTile.getTexture(this.myTile.getFacing(), i), this.posX() + 40, ((ElementBase)this).posY + 44, 0);
            ((ElementBase)this).gui.drawIcon(this.myTile.getTexture(BlockHelper.SIDE_RIGHT[this.myTile.getFacing()], i), this.posX() + 60, ((ElementBase)this).posY + 44, 0);
            ((ElementBase)this).gui.drawIcon(this.myTile.getTexture(0, i), this.posX() + 40, ((ElementBase)this).posY + 64, 0);
            ((ElementBase)this).gui.drawIcon(this.myTile.getTexture(BlockHelper.SIDE_OPPOSITE[this.myTile.getFacing()], i), this.posX() + 60, ((ElementBase)this).posY + 64, 0);
        }
        ((ElementBase)this).gui.drawIcon(this.myTile.getTexture(this.myTile.getFacing(), 3), this.posX() + 40, ((ElementBase)this).posY + 44, 0);
        GL11.glDisable((int)3042);
        RenderHelper.setDefaultFontTextureSheet();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize((String)"info.cofh.configuration"));
        }
    }

    public boolean onMousePressed(int n, int n2, int n3) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == 0) {
            n += this.currentWidth;
        }
        if ((n -= this.currentShiftX) < 16 || n >= 80 || (n2 -= this.currentShiftY) < 20 || n2 >= 84) {
            return false;
        }
        if (40 <= n && n < 56 && 24 <= n2 && n2 < 40) {
            this.handleSideChange(1, n3);
        } else if (20 <= n && n < 36 && 44 <= n2 && n2 < 60) {
            this.handleSideChange(BlockHelper.SIDE_LEFT[this.myTile.getFacing()], n3);
        } else if (40 <= n && n < 56 && 44 <= n2 && n2 < 60) {
            this.handleSideChange(this.myTile.getFacing(), n3);
        } else if (60 <= n && n < 76 && 44 <= n2 && n2 < 60) {
            this.handleSideChange(BlockHelper.SIDE_RIGHT[this.myTile.getFacing()], n3);
        } else if (40 <= n && n < 56 && 64 <= n2 && n2 < 80) {
            this.handleSideChange(0, n3);
        } else if (60 <= n && n < 76 && 64 <= n2 && n2 < 80) {
            this.handleSideChange(BlockHelper.SIDE_OPPOSITE[this.myTile.getFacing()], n3);
        }
        return true;
    }

    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float f = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float f2 = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float f3 = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GL11.glColor4f((float)f, (float)f2, (float)f3, (float)1.0f);
        ((ElementBase)this).gui.func_73729_b(this.posX() + 16, ((ElementBase)this).posY + 20, 16, 20, 64, 64);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    void handleSideChange(int n, int n2) {
        if (GuiScreen.func_146272_n()) {
            if (n == this.myTile.getFacing()) {
                if (this.myTile.resetSides()) {
                    GuiBase.playSound((String)"random.click", (float)1.0f, (float)0.2f);
                }
            } else if (this.myTile.setSide(n, 0)) {
                GuiBase.playSound((String)"random.click", (float)1.0f, (float)0.4f);
            }
            return;
        }
        if (n2 == 0) {
            if (this.myTile.incrSide(n)) {
                GuiBase.playSound((String)"random.click", (float)1.0f, (float)0.8f);
            }
        } else if (n2 == 1 && this.myTile.decrSide(n)) {
            GuiBase.playSound((String)"random.click", (float)1.0f, (float)0.6f);
        }
    }
}

