/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.cell;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.item.ItemBlockBase;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.RedstoneControlHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.cell.BlockCell;
import cofh.thermalexpansion.block.cell.TileCell;
import cofh.thermalexpansion.block.cell.TileCellCreative;
import cofh.thermalexpansion.util.ReconfigurableHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;

public class ItemBlockCell
extends ItemBlockBase
implements IEnergyContainerItem {
    public static ItemStack setDefaultTag(ItemStack itemStack, int n) {
        ReconfigurableHelper.setFacing(itemStack, 3);
        ReconfigurableHelper.setSideCache(itemStack, ItemHelper.getItemDamage((ItemStack)itemStack) == BlockCell.Types.CREATIVE.ordinal() ? TileCellCreative.DEFAULT_SIDES : TileCell.DEFAULT_SIDES);
        RedstoneControlHelper.setControl((ItemStack)itemStack, (IRedstoneControl.ControlMode)IRedstoneControl.ControlMode.LOW);
        EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)n);
        itemStack.field_77990_d.func_74768_a("Send", TileCell.MAX_SEND[itemStack.func_77960_j()]);
        itemStack.field_77990_d.func_74768_a("Recv", TileCell.MAX_RECEIVE[itemStack.func_77960_j()]);
        return itemStack;
    }

    public ItemBlockCell(Block block) {
        super(block);
        this.func_77627_a(true);
        this.func_77656_e(1);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public String func_77667_c(ItemStack itemStack) {
        return "tile.thermalexpansion.cell." + BlockCell.NAMES[ItemHelper.getItemDamage((ItemStack)itemStack)] + ".name";
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return TileCell.CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)];
        }
        return TileCell.CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)] - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return TileCell.CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)];
    }

    public boolean isDamaged(ItemStack itemStack) {
        return ItemHelper.getItemDamage((ItemStack)itemStack) != BlockCell.Types.CREATIVE.ordinal();
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        switch (BlockCell.Types.values()[ItemHelper.getItemDamage((ItemStack)itemStack)]) {
            case CREATIVE: {
                return EnumRarity.epic;
            }
            case RESONANT: {
                return EnumRarity.rare;
            }
            case REINFORCED: {
                return EnumRarity.uncommon;
            }
        }
        return EnumRarity.common;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (itemStack.field_77990_d == null) {
            ItemBlockCell.setDefaultTag(itemStack, 0);
        }
        SecurityHelper.addOwnerInformation((ItemStack)itemStack, (List)list);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        SecurityHelper.addAccessInformation((ItemStack)itemStack, (List)list);
        if (ItemHelper.getItemDamage((ItemStack)itemStack) == BlockCell.Types.CREATIVE.ordinal()) {
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
        } else {
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)itemStack.field_77990_d.func_74762_e("Energy")) + " / " + StringHelper.getScaledNumber((long)TileCell.CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)]) + " RF");
        }
        list.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + itemStack.field_77990_d.func_74762_e("Send") + "/" + itemStack.field_77990_d.func_74762_e("Recv") + " RF/t");
        RedstoneControlHelper.addRSControlInformation((ItemStack)itemStack, (List)list);
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        int n2;
        if (itemStack.field_77990_d == null) {
            ItemBlockCell.setDefaultTag(itemStack, 0);
        }
        if ((n2 = ItemHelper.getItemDamage((ItemStack)itemStack)) == BlockCell.Types.CREATIVE.ordinal()) {
            return 0;
        }
        int n3 = itemStack.field_77990_d.func_74762_e("Energy");
        int n4 = Math.min(n, Math.min(TileCell.CAPACITY[n2] - n3, TileCell.MAX_RECEIVE[n2]));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n3 += n4);
        }
        return n4;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        int n2;
        if (itemStack.field_77990_d == null) {
            ItemBlockCell.setDefaultTag(itemStack, 0);
        }
        if ((n2 = ItemHelper.getItemDamage((ItemStack)itemStack)) == BlockCell.Types.CREATIVE.ordinal()) {
            return n;
        }
        int n3 = itemStack.field_77990_d.func_74762_e("Energy");
        int n4 = Math.min(n, Math.min(n3, TileCell.MAX_SEND[n2]));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n3 -= n4);
        }
        return n4;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            ItemBlockCell.setDefaultTag(itemStack, 0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return TileCell.CAPACITY[ItemHelper.getItemDamage((ItemStack)itemStack)];
    }
}

