/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.lib.world.feature.FeatureBase;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FeatureGenUniform
extends FeatureBase {
    final WorldGenerator worldGen;
    final int count;
    final int minY;
    final int maxY;

    public FeatureGenUniform(String name, WorldGenerator worldGen, int count, int minY, int maxY, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public boolean generateFeature(Random random, int chunkX, int chunkZ, World world) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        boolean generated = false;
        for (int i = 0; i < this.count; ++i) {
            int x = blockX + random.nextInt(16);
            int y = this.minY + random.nextInt(this.maxY - this.minY);
            int z = blockZ + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z, random)) continue;
            generated |= this.worldGen.func_76484_a(world, random, x, y, z);
        }
        return generated;
    }
}

