/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.Log;
import openmods.block.BlockRotationMode;

public class RotationHelper {
    private final BlockRotationMode mode;
    private final int originalMeta;
    private ForgeDirection rotation;
    private final World world;
    private final int x;
    private final int y;
    private final int z;

    public static boolean rotate(BlockRotationMode mode, World world, int x, int y, int z, ForgeDirection axis) {
        if (mode == BlockRotationMode.NONE) {
            return false;
        }
        return new RotationHelper(mode, world, x, y, z).rotate(axis);
    }

    private RotationHelper(BlockRotationMode mode, World world, int x, int y, int z) {
        this.mode = mode;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        int meta = world.func_72805_g(x, y, z);
        this.originalMeta = meta & ~mode.mask;
        int dirPart = meta & mode.mask;
        this.rotation = mode.fromValue(dirPart);
    }

    public boolean rotate(ForgeDirection axis) {
        ForgeDirection newRotation = this.calculateRotation(axis);
        if (newRotation != null) {
            this.setBlockRotation(newRotation);
            return true;
        }
        return false;
    }

    private ForgeDirection calculateRotation(ForgeDirection axis) {
        switch (this.mode) {
            case TWO_DIRECTIONS: {
                return this.rotateTwoDirections(axis);
            }
            case FOUR_DIRECTIONS: {
                return this.rotateFourDirections(axis);
            }
            case SIX_DIRECTIONS: {
                return this.rotateSixDirection(axis);
            }
        }
        return null;
    }

    private void setBlockRotation(ForgeDirection dir) {
        int dirPart = this.mode.toValue(dir);
        int newMeta = this.originalMeta | dirPart;
        this.world.func_72921_c(this.x, this.y, this.z, newMeta, 3);
        this.rotation = dir;
    }

    private ForgeDirection rotateTwoDirections(ForgeDirection axis) {
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            switch (this.rotation) {
                case EAST: 
                case WEST: {
                    return ForgeDirection.NORTH;
                }
                case NORTH: 
                case SOUTH: {
                    return ForgeDirection.WEST;
                }
            }
            Log.warn("Invalid rotation from dir: %s", this.rotation);
            return ForgeDirection.NORTH;
        }
        return null;
    }

    private ForgeDirection rotateFourDirections(ForgeDirection axis) {
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return this.rotation.getRotation(axis);
        }
        return null;
    }

    private ForgeDirection rotateSixDirection(ForgeDirection axis) {
        return this.rotation.getRotation(axis);
    }
}

